/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.command.CommandSource;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.jigsaw.JigsawPattern;
import net.minecraft.world.gen.feature.jigsaw.JigsawPiece;
import net.minecraft.world.gen.feature.jigsaw.SingleJigsawPiece;
import net.minecraft.world.gen.feature.structure.DesertVillagePools;
import net.minecraft.world.gen.feature.structure.PlainsVillagePools;
import net.minecraft.world.gen.feature.structure.SavannaVillagePools;
import net.minecraft.world.gen.feature.structure.SnowyVillagePools;
import net.minecraft.world.gen.feature.structure.TaigaVillagePools;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.event.server.FMLServerAboutToStartEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import online.kingdomkeys.kingdomkeys.block.ModBlocks;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.command.DimensionCommand;
import online.kingdomkeys.kingdomkeys.command.KKDriveLevelCommand;
import online.kingdomkeys.kingdomkeys.command.KKDrivePointsCommand;
import online.kingdomkeys.kingdomkeys.command.KKExpCommand;
import online.kingdomkeys.kingdomkeys.command.KKHeartsCommand;
import online.kingdomkeys.kingdomkeys.command.KKLevelCommand;
import online.kingdomkeys.kingdomkeys.command.KKMaterialCommand;
import online.kingdomkeys.kingdomkeys.command.KKMunnyCommand;
import online.kingdomkeys.kingdomkeys.command.KKRecipeCommand;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.container.ModContainers;
import online.kingdomkeys.kingdomkeys.datagen.DataGeneration;
import online.kingdomkeys.kingdomkeys.entity.MobSpawnings;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.handler.EntityEvents;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationDataLoader;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.proxy.IProxy;
import online.kingdomkeys.kingdomkeys.proxy.ProxyClient;
import online.kingdomkeys.kingdomkeys.proxy.ProxyServer;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeDataLoader;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeDataLoader;
import online.kingdomkeys.kingdomkeys.world.biome.ModBiomes;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;
import online.kingdomkeys.kingdomkeys.world.features.ModFeatures;
import online.kingdomkeys.kingdomkeys.world.features.OreGen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="kingdomkeys")
public class KingdomKeys {
    public static final Logger LOGGER = LogManager.getLogger();
    public static KingdomKeys instance;
    public static final String MODID = "kingdomkeys";
    public static final String MODNAME = "Kingdom Keys";
    public static final String MODVER = "2.0.1.6";
    public static final String MCVER = "1.15.2";
    public static IProxy proxy;
    public static ItemGroup orgWeaponsGroup;
    public static ItemGroup keybladesGroup;
    public static ItemGroup miscGroup;

    public KingdomKeys() {
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        ModBlocks.BLOCKS.register(modEventBus);
        ModItems.ITEMS.register(modEventBus);
        ModSounds.SOUNDS.register(modEventBus);
        ModEntities.TILE_ENTITIES.register(modEventBus);
        ModContainers.CONTAINERS.register(modEventBus);
        ModEntities.ENTITIES.register(modEventBus);
        ModFeatures.FEATURES.register(modEventBus);
        ModBiomes.BIOMES.register(modEventBus);
        ModDimensions.DIMENSIONS.register(modEventBus);
        modEventBus.addListener(this::setup);
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, ModConfigs.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.COMMON, ModConfigs.COMMON_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, ModConfigs.SERVER_SPEC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new DataGeneration());
        modEventBus.addListener(this::oreGen);
        MinecraftForge.EVENT_BUS.register((Object)new EntityEvents());
        MinecraftForge.EVENT_BUS.register((Object)new ModCapabilities());
    }

    private void setup(FMLCommonSetupEvent event) {
        proxy.setup(event);
        ModCapabilities.register();
        ModBiomes.init();
        DeferredWorkQueue.runLater(PacketHandler::register);
        DeferredWorkQueue.runLater(MobSpawnings::addSpawns);
        DeferredWorkQueue.runLater(ModEntities::registerPlacements);
        DeferredWorkQueue.runLater(this::addMoogleHouse);
    }

    public void addMoogleHouse() {
        PlainsVillagePools.func_214744_a();
        DesertVillagePools.func_222739_a();
        SavannaVillagePools.func_214745_a();
        SnowyVillagePools.func_214746_a();
        TaigaVillagePools.func_214806_a();
        this.addPieceToPattern(new ResourceLocation("village/plains/houses"), new ResourceLocation(MODID, "village/moogle_house_plains"), 2);
        this.addPieceToPattern(new ResourceLocation("village/desert/houses"), new ResourceLocation(MODID, "village/moogle_house_desert"), 2);
        this.addPieceToPattern(new ResourceLocation("village/savanna/houses"), new ResourceLocation(MODID, "village/moogle_house_savanna"), 2);
        this.addPieceToPattern(new ResourceLocation("village/snowy/houses"), new ResourceLocation(MODID, "village/moogle_house_snowy"), 2);
        this.addPieceToPattern(new ResourceLocation("village/taiga/houses"), new ResourceLocation(MODID, "village/moogle_house_taiga"), 2);
    }

    public void addPieceToPattern(ResourceLocation pattern, ResourceLocation structure, int weight) {
        JigsawPattern pat = JigsawManager.field_214891_a.func_214933_a(pattern);
        ArrayList<Pair> newList = new ArrayList<Pair>((Collection<Pair>)pat.field_214952_d);
        newList.add(Pair.of((Object)new SingleJigsawPiece(structure.toString(), (List)ImmutableList.of(), JigsawPattern.PlacementBehaviour.RIGID), (Object)weight));
        pat.field_214952_d = ImmutableList.copyOf(newList);
        pat.field_214953_e.clear();
        for (Pair pair : pat.field_214952_d) {
            for (int integer = 0; integer < (Integer)pair.getSecond(); ++integer) {
                pat.field_214953_e.add(((JigsawPiece)pair.getFirst()).func_214845_a(((JigsawPiece)pair.getFirst()).func_214854_c()));
            }
        }
        JigsawManager.field_214891_a.func_214932_a(pat);
    }

    @SubscribeEvent
    public void onServerStarting(FMLServerAboutToStartEvent event) {
        this.registerResourceLoader(event.getServer().func_195570_aG());
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
        CommandDispatcher dispatcher = event.getServer().func_195571_aL().func_197054_a();
        KKMunnyCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKRecipeCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKMaterialCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKLevelCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKDriveLevelCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKExpCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        DimensionCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKHeartsCommand.register((CommandDispatcher<CommandSource>)dispatcher);
        KKDrivePointsCommand.register((CommandDispatcher<CommandSource>)dispatcher);
    }

    public void oreGen(FMLLoadCompleteEvent event) {
        OreGen.generateOre();
        for (GenerationStage.Decoration i : GenerationStage.Decoration.values()) {
            ((Biome)ModBiomes.diveToTheHeart.get()).func_203607_a(i).clear();
        }
    }

    private void registerResourceLoader(IReloadableResourceManager resourceManager) {
        resourceManager.func_219534_a((IFutureReloadListener)new KeybladeDataLoader());
        resourceManager.func_219534_a((IFutureReloadListener)new OrganizationDataLoader());
        resourceManager.func_219534_a((IFutureReloadListener)new RecipeDataLoader());
    }

    static {
        proxy = (IProxy)DistExecutor.safeRunForDist(() -> ProxyClient::new, () -> ProxyServer::new);
        orgWeaponsGroup = new ItemGroup("kingdomkeys_org_weapons"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModItems.eternalFlames.get());
            }
        };
        keybladesGroup = new ItemGroup("kingdomkeys_keyblades"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModItems.kingdomKey.get());
            }
        };
        miscGroup = new ItemGroup("kingdomkeys_misc"){

            public ItemStack func_78016_d() {
                return new ItemStack((IItemProvider)ModBlocks.normalBlox.get());
            }
        };
    }
}

