/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.block.BlastBloxBlock;
import online.kingdomkeys.kingdomkeys.block.BounceBloxBlock;
import online.kingdomkeys.kingdomkeys.block.DangerBloxBlock;
import online.kingdomkeys.kingdomkeys.block.GhostBloxBlock;
import online.kingdomkeys.kingdomkeys.block.MagicalChestBlock;
import online.kingdomkeys.kingdomkeys.block.MagnetBloxBlock;
import online.kingdomkeys.kingdomkeys.block.MoogleProjectorBlock;
import online.kingdomkeys.kingdomkeys.block.MosaicStainedGlassBlock;
import online.kingdomkeys.kingdomkeys.block.OrgPortalBlock;
import online.kingdomkeys.kingdomkeys.block.PairBloxBlock;
import online.kingdomkeys.kingdomkeys.block.PedestalBlock;
import online.kingdomkeys.kingdomkeys.block.SavePointBlock;
import online.kingdomkeys.kingdomkeys.block.SoADoorBlock;
import online.kingdomkeys.kingdomkeys.block.SoAPlatformCoreBlock;
import online.kingdomkeys.kingdomkeys.item.ModItems;

public class ModBlocks {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"kingdomkeys");
    public static final RegistryObject<Block> normalBlox = ModBlocks.createNewBlock("normal_blox", Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 10.0f));
    public static final RegistryObject<Block> hardBlox = ModBlocks.createNewBlock("hard_blox", Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(5.0f, 20.0f));
    public static final RegistryObject<Block> metalBlox = ModBlocks.createNewBlock("metal_blox", Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(10.0f, 60.0f));
    public static final RegistryObject<Block> dangerBlox = ModBlocks.createNewBlock("danger_blox", () -> new DangerBloxBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(1.0f)));
    public static final RegistryObject<Block> bounceBlox = ModBlocks.createNewBlock("bounce_blox", () -> new BounceBloxBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 10.0f)));
    public static final RegistryObject<Block> blastBlox = ModBlocks.createNewBlock("blast_blox", () -> new BlastBloxBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 10.0f)));
    public static final RegistryObject<Block> ghostBlox = ModBlocks.createNewBlock("ghost_blox", () -> new GhostBloxBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 10.0f)));
    public static final RegistryObject<Block> prizeBlox = ModBlocks.createNewBlock("prize_blox", Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 10.0f));
    public static final RegistryObject<Block> rarePrizeBlox = ModBlocks.createNewBlock("rare_prize_blox", Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 10.0f));
    public static final RegistryObject<Block> magnetBlox = ModBlocks.createNewBlock("magnet_blox", () -> new MagnetBloxBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 1.0f)));
    public static final RegistryObject<Block> pairBlox = ModBlocks.createNewBlock("pair_blox", () -> new PairBloxBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200948_a(1.0f, 10.0f)));
    public static final RegistryObject<Block> blazingOre = ModBlocks.createNewBlock("blazing_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200948_a(2.0f, 1.0f).func_200951_a(4));
    public static final RegistryObject<Block> blazingOreN = ModBlocks.createNewBlock("blazing_ore_n", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200948_a(2.0f, 1.0f).func_200951_a(4));
    public static final RegistryObject<Block> soothingOre = ModBlocks.createNewBlock("soothing_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> writhingOre = ModBlocks.createNewBlock("writhing_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> writhingOreN = ModBlocks.createNewBlock("writhing_ore_n", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> writhingOreE = ModBlocks.createNewBlock("writhing_ore_e", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> betwixtOre = ModBlocks.createNewBlock("betwixt_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> wellspringOre = ModBlocks.createNewBlock("wellspring_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> wellspringOreN = ModBlocks.createNewBlock("wellspring_ore_n", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> frostOre = ModBlocks.createNewBlock("frost_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> lucidOre = ModBlocks.createNewBlock("lucid_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> lightningOre = ModBlocks.createNewBlock("lightning_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200948_a(2.0f, 1.0f).func_200951_a(4));
    public static final RegistryObject<Block> pulsingOre = ModBlocks.createNewBlock("pulsing_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> pulsingOreE = ModBlocks.createNewBlock("pulsing_ore_e", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> remembranceOre = ModBlocks.createNewBlock("remembrance_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> hungryOre = ModBlocks.createNewBlock("hungry_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> sinisterOre = ModBlocks.createNewBlock("sinister_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> stormyOre = ModBlocks.createNewBlock("stormy_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> tranquilityOre = ModBlocks.createNewBlock("tranquility_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(1).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> twilightOre = ModBlocks.createNewBlock("twilight_ore", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> twilightOreN = ModBlocks.createNewBlock("twilight_ore_n", Block.Properties.func_200945_a((Material)Material.field_151576_e).harvestLevel(2).func_200948_a(2.0f, 1.0f));
    public static final RegistryObject<Block> savepoint = ModBlocks.createNewBlock("savepoint", () -> new SavePointBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestLevel(2).func_200948_a(2.0f, 1.0f)));
    public static final RegistryObject<Block> magicalChest = ModBlocks.createNewBlock("magical_chest", () -> new MagicalChestBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestLevel(2).func_200948_a(2.0f, 1.0f)));
    public static final RegistryObject<Block> soADoor = ModBlocks.createNewBlock("soa_door", () -> new SoADoorBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestLevel(2).func_200948_a(2.0f, 1.0f)));
    public static final RegistryObject<Block> pedestal = ModBlocks.createNewBlock("pedestal", () -> new PedestalBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestLevel(2).func_200948_a(2.0f, 1.0f)));
    public static final RegistryObject<Block> mosaic_stained_glass = ModBlocks.createNewBlock("mosaic_stained_glass", () -> new MosaicStainedGlassBlock(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_226896_b_().func_200947_a(SoundType.field_185853_f).func_200948_a(1.0f, 10.0f)));
    public static final RegistryObject<Block> station_of_awakening_core = ModBlocks.createNewBlock("station_of_awakening_core", () -> new SoAPlatformCoreBlock(Block.Properties.func_200945_a((Material)Material.field_151592_s).func_226896_b_().func_200947_a(SoundType.field_185853_f).func_200948_a(1.0f, 10.0f)));
    public static final RegistryObject<Block> orgPortal = ModBlocks.createNewBlock("org_portal", () -> new OrgPortalBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).harvestLevel(2).func_200948_a(2.0f, 1.0f)));
    public static final RegistryObject<Block> moogleProjector = ModBlocks.createNewBlock("moogle_projector", () -> new MoogleProjectorBlock(Block.Properties.func_200945_a((Material)Material.field_151573_f).func_200951_a(6).func_226896_b_().harvestLevel(0).func_200948_a(2.0f, 1.0f)));

    private static RegistryObject<Block> createNewBlock(String name, Block.Properties properties) {
        RegistryObject newBlock = BLOCKS.register(name, () -> new Block(properties));
        ModBlocks.createNewBlockItem(name, newBlock);
        return newBlock;
    }

    private static RegistryObject<Block> createNewBlock(String name, Block.Properties properties, ItemGroup tab) {
        RegistryObject newBlock = BLOCKS.register(name, () -> new Block(properties));
        ModBlocks.createNewBlockItem(name, newBlock, tab);
        return newBlock;
    }

    private static <T extends Block> RegistryObject<T> createNewBlock(String name, Supplier<? extends T> block) {
        RegistryObject newBlock = BLOCKS.register(name, block);
        ModBlocks.createNewBlockItem(name, newBlock);
        return newBlock;
    }

    private static <T extends Block> void createNewBlockItem(String name, Supplier<? extends T> block) {
        Supplier<BlockItem> item = () -> new BlockItem((Block)Objects.requireNonNull(block.get()), new Item.Properties().func_200916_a(KingdomKeys.miscGroup));
        ModItems.ITEMS.register(name, item);
    }

    private static <T extends Block> void createNewBlockItem(String name, Supplier<? extends T> block, ItemGroup tab) {
        Supplier<BlockItem> item = () -> new BlockItem((Block)Objects.requireNonNull(block.get()), new Item.Properties().func_200916_a(tab));
        ModItems.ITEMS.register(name, item);
    }
}

