/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.block;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import net.minecraftforge.items.CapabilityItemHandler;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.block.PedestalTileEntity;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCOpenChoiceScreen;

public class PedestalBlock
extends ContainerBlock {
    private static final VoxelShape collision = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)16.0);

    public PedestalBlock(Block.Properties properties) {
        super(properties);
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return collision;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.func_220053_a(state, worldIn, pos, context);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult rayTraceResult) {
        PedestalTileEntity te;
        if (worldIn.field_72995_K) {
            return ActionResultType.SUCCESS;
        }
        INamedContainerProvider namedContainerProvider = this.func_220052_b(state, worldIn, pos);
        if (namedContainerProvider == null) return ActionResultType.SUCCESS;
        if (!(player instanceof ServerPlayerEntity)) {
            return ActionResultType.FAIL;
        }
        ServerPlayerEntity serverPlayerEntity = (ServerPlayerEntity)player;
        if (!state.hasTileEntity() || !(worldIn.func_175625_s(pos) instanceof PedestalTileEntity) || (te = (PedestalTileEntity)worldIn.func_175625_s(pos)) == null) return ActionResultType.SUCCESS;
        if (te.isStationOfAwakeningMarker()) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            SoAState soAState = playerData.getSoAState();
            if (soAState != SoAState.CHOICE && (soAState != SoAState.SACRIFICE || playerData.getChoicePedestal().equals((Object)pos))) return ActionResultType.FAIL;
            PacketHandler.sendTo(new SCOpenChoiceScreen(te.getDisplayStack(), soAState, pos), serverPlayerEntity);
            return ActionResultType.SUCCESS;
        } else {
            NetworkHooks.openGui((ServerPlayerEntity)serverPlayerEntity, (INamedContainerProvider)namedContainerProvider, packetBuffer -> packetBuffer.func_179255_a(pos));
        }
        return ActionResultType.SUCCESS;
    }

    public void func_196243_a(BlockState state, World world, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.hasTileEntity() && state.func_177230_c() != newState.func_177230_c()) {
            world.func_175625_s(pos).getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY).ifPresent(inv -> {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    PedestalBlock.func_180635_a((World)world, (BlockPos)pos, (ItemStack)inv.getStackInSlot(i));
                }
            });
            world.func_175713_t(pos);
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Deprecated
    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public boolean func_220081_d(BlockState p_220081_1_, IBlockReader p_220081_2_, BlockPos p_220081_3_) {
        return false;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return this.func_196283_a_(world);
    }

    public TileEntity func_196283_a_(IBlockReader worldIn) {
        return new PedestalTileEntity();
    }
}

