/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.capability;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import online.kingdomkeys.kingdomkeys.capability.GlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.GlobalCapabilitiesProvider;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.PlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.PlayerCapabilitiesProvider;
import online.kingdomkeys.kingdomkeys.capability.PlayerCapabilitiesStorage;
import online.kingdomkeys.kingdomkeys.capability.WorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.WorldCapabilitiesProvider;

public class ModCapabilities {
    @CapabilityInject(value=IPlayerCapabilities.class)
    public static final Capability<IPlayerCapabilities> PLAYER_CAPABILITIES = null;
    @CapabilityInject(value=IGlobalCapabilities.class)
    public static final Capability<IGlobalCapabilities> GLOBAL_CAPABILITIES = null;
    @CapabilityInject(value=IWorldCapabilities.class)
    public static final Capability<IWorldCapabilities> WORLD_CAPABILITIES = null;

    public static IPlayerCapabilities getPlayer(PlayerEntity player) {
        LazyOptional playerData = player.getCapability(PLAYER_CAPABILITIES, null);
        return (IPlayerCapabilities)playerData.orElse(null);
    }

    public static IGlobalCapabilities getGlobal(LivingEntity e) {
        LazyOptional globalData = e.getCapability(GLOBAL_CAPABILITIES, null);
        return (IGlobalCapabilities)globalData.orElse(null);
    }

    public static IWorldCapabilities getWorld(World w) {
        LazyOptional worldData = w.getCapability(WORLD_CAPABILITIES, null);
        return (IWorldCapabilities)worldData.orElse(null);
    }

    public static void register() {
        CapabilityManager.INSTANCE.register(IPlayerCapabilities.class, (Capability.IStorage)new PlayerCapabilitiesStorage(), PlayerCapabilities::new);
        CapabilityManager.INSTANCE.register(IGlobalCapabilities.class, (Capability.IStorage)new GlobalCapabilities.Storage(), GlobalCapabilities::new);
        CapabilityManager.INSTANCE.register(IWorldCapabilities.class, (Capability.IStorage)new WorldCapabilities.Storage(), WorldCapabilities::new);
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("kingdomkeys", "global_capabilities"), (ICapabilityProvider)new GlobalCapabilitiesProvider());
            if (event.getObject() instanceof PlayerEntity) {
                event.addCapability(new ResourceLocation("kingdomkeys", "player_capabilities"), (ICapabilityProvider)new PlayerCapabilitiesProvider());
            }
        }
    }

    @SubscribeEvent
    public void attachWorldCapabilities(AttachCapabilitiesEvent<World> event) {
        event.addCapability(new ResourceLocation("kingdomkeys", "world_capabilities"), (ICapabilityProvider)new WorldCapabilitiesProvider());
    }
}

