/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.capability;

import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.capabilities.Capability;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.lib.SoAState;

public class PlayerCapabilitiesStorage
implements Capability.IStorage<IPlayerCapabilities> {
    public INBT writeNBT(Capability<IPlayerCapabilities> capability, IPlayerCapabilities instance, Direction side) {
        CompoundNBT storage = new CompoundNBT();
        storage.func_74768_a("level", instance.getLevel());
        storage.func_74768_a("experience", instance.getExperience());
        storage.func_74768_a("experience_given", instance.getExperienceGiven());
        storage.func_74768_a("strength", instance.getStrength());
        storage.func_74768_a("magic", instance.getMagic());
        storage.func_74768_a("defense", instance.getDefense());
        storage.func_74768_a("max_hp", instance.getMaxHP());
        storage.func_74768_a("max_ap", instance.getMaxAP());
        storage.func_74780_a("mp", instance.getMP());
        storage.func_74780_a("max_mp", instance.getMaxMP());
        storage.func_74757_a("recharge", instance.getRecharge());
        storage.func_74780_a("dp", instance.getDP());
        storage.func_74780_a("max_dp", instance.getMaxDP());
        storage.func_74780_a("fp", instance.getFP());
        storage.func_74778_a("drive_form", instance.getActiveDriveForm());
        storage.func_74768_a("anti_points", instance.getAntiPoints());
        storage.func_74768_a("aero_ticks", instance.getAeroTicks());
        storage.func_74768_a("reflect_ticks", instance.getReflectTicks());
        storage.func_74757_a("reflect_active", instance.getReflectActive());
        storage.func_74768_a("munny", instance.getMunny());
        storage.func_74774_a("soa_state", instance.getSoAState().get());
        storage.func_74774_a("soa_choice", instance.getChosen().get());
        storage.func_74774_a("soa_sacrifice", instance.getSacrificed().get());
        CompoundNBT returnCompound = new CompoundNBT();
        Vec3d pos = instance.getReturnLocation();
        returnCompound.func_74780_a("x", pos.field_72450_a);
        returnCompound.func_74780_a("y", pos.field_72448_b);
        returnCompound.func_74780_a("z", pos.field_72449_c);
        storage.func_218657_a("soa_return_pos", (INBT)returnCompound);
        storage.func_74768_a("soa_return_dim", instance.getReturnDimension().func_186068_a());
        CompoundNBT choicePedestalCompound = new CompoundNBT();
        BlockPos choicePos = instance.getChoicePedestal();
        choicePedestalCompound.func_74768_a("x", choicePos.func_177958_n());
        choicePedestalCompound.func_74768_a("y", choicePos.func_177956_o());
        choicePedestalCompound.func_74768_a("z", choicePos.func_177952_p());
        storage.func_218657_a("soa_choice_pedestal", (INBT)choicePedestalCompound);
        CompoundNBT sacrificePedestalCompound = new CompoundNBT();
        BlockPos sacrificePos = instance.getSacrificePedestal();
        sacrificePedestalCompound.func_74768_a("x", sacrificePos.func_177958_n());
        sacrificePedestalCompound.func_74768_a("y", sacrificePos.func_177956_o());
        sacrificePedestalCompound.func_74768_a("z", sacrificePos.func_177952_p());
        storage.func_218657_a("soa_sacrifice_pedestal", (INBT)sacrificePedestalCompound);
        CompoundNBT recipes = new CompoundNBT();
        for (ResourceLocation resourceLocation : instance.getKnownRecipeList()) {
            recipes.func_74778_a(resourceLocation.toString(), resourceLocation.toString());
        }
        storage.func_218657_a("recipes", (INBT)recipes);
        CompoundNBT magics = new CompoundNBT();
        for (String magic : instance.getMagicList()) {
            magics.func_74768_a(magic, 0);
        }
        storage.func_218657_a("magics", (INBT)magics);
        CompoundNBT compoundNBT = new CompoundNBT();
        for (Map.Entry<String, int[]> pair : instance.getDriveFormMap().entrySet()) {
            compoundNBT.func_74783_a(pair.getKey().toString(), pair.getValue());
        }
        storage.func_218657_a("drive_forms", (INBT)compoundNBT);
        CompoundNBT abilities = new CompoundNBT();
        for (Map.Entry<String, int[]> pair : instance.getAbilityMap().entrySet()) {
            abilities.func_74783_a(pair.getKey().toString(), pair.getValue());
        }
        storage.func_218657_a("abilities", (INBT)abilities);
        CompoundNBT keychains = new CompoundNBT();
        instance.getEquippedKeychains().forEach((form, chain) -> keychains.func_218657_a(form.toString(), (INBT)chain.serializeNBT()));
        storage.func_218657_a("keychains", (INBT)keychains);
        storage.func_74768_a("hearts", instance.getHearts());
        storage.func_74768_a("org_alignment", instance.getAlignmentIndex());
        storage.func_218657_a("org_equipped_weapon", (INBT)instance.getEquippedWeapon().serializeNBT());
        CompoundNBT unlockedWeapons = new CompoundNBT();
        instance.getWeaponsUnlocked().forEach(weapon -> unlockedWeapons.func_218657_a(weapon.func_77973_b().getRegistryName().toString(), (INBT)weapon.serializeNBT()));
        storage.func_218657_a("org_weapons_unlocked", (INBT)unlockedWeapons);
        CompoundNBT parties = new CompoundNBT();
        for (int i = 0; i < instance.getPartiesInvited().size(); ++i) {
            parties.func_74768_a(instance.getPartiesInvited().get(i), i);
        }
        storage.func_218657_a("parties", (INBT)parties);
        CompoundNBT mats = new CompoundNBT();
        for (Map.Entry<String, Integer> pair : instance.getMaterialMap().entrySet()) {
            mats.func_74768_a(pair.getKey().toString(), pair.getValue().intValue());
            if (mats.func_74762_e(pair.getKey()) != 0 || pair.getKey().toString() == null) continue;
            mats.func_82580_o(pair.getKey().toString());
        }
        storage.func_218657_a("materials", (INBT)mats);
        storage.func_74768_a("limit_cooldown", instance.getLimitCooldown());
        return storage;
    }

    public void readNBT(Capability<IPlayerCapabilities> capability, IPlayerCapabilities instance, Direction side, INBT nbt) {
        CompoundNBT storage = (CompoundNBT)nbt;
        instance.setLevel(storage.func_74762_e("level"));
        instance.setExperience(storage.func_74762_e("experience"));
        instance.setExperienceGiven(storage.func_74762_e("experience_given"));
        instance.setStrength(storage.func_74762_e("strength"));
        instance.setMagic(storage.func_74762_e("magic"));
        instance.setDefense(storage.func_74762_e("defense"));
        instance.setMaxHP(storage.func_74762_e("max_hp"));
        instance.setMaxAP(storage.func_74762_e("max_ap"));
        instance.setMP(storage.func_74769_h("mp"));
        instance.setMaxMP(storage.func_74769_h("max_mp"));
        instance.setRecharge(storage.func_74767_n("recharge"));
        instance.setDP(storage.func_74769_h("dp"));
        instance.setMaxDP(storage.func_74769_h("max_dp"));
        instance.setFP(storage.func_74769_h("fp"));
        instance.setActiveDriveForm(storage.func_74779_i("drive_form"));
        instance.setAntiPoints(storage.func_74762_e("anti_points"));
        instance.setAeroTicks(storage.func_74762_e("aero_ticks"));
        instance.setReflectTicks(storage.func_74762_e("reflect_ticks"));
        instance.setReflectActive(storage.func_74767_n("reflect_active"));
        instance.setMunny(storage.func_74762_e("munny"));
        instance.setSoAState(SoAState.fromByte(storage.func_74771_c("soa_state")));
        instance.setChoice(SoAState.fromByte(storage.func_74771_c("soa_choice")));
        instance.setSacrifice(SoAState.fromByte(storage.func_74771_c("soa_sacrifice")));
        CompoundNBT returnCompound = storage.func_74775_l("soa_return_pos");
        instance.setReturnLocation(new Vec3d(returnCompound.func_74769_h("x"), returnCompound.func_74769_h("y"), returnCompound.func_74769_h("z")));
        instance.setReturnDimension(DimensionType.func_186069_a((int)storage.func_74762_e("soa_return_dim")));
        CompoundNBT choicePedestal = storage.func_74775_l("soa_choice_pedestal");
        instance.setChoicePedestal(new BlockPos(choicePedestal.func_74762_e("x"), choicePedestal.func_74762_e("y"), choicePedestal.func_74762_e("z")));
        CompoundNBT sacrificePedestal = storage.func_74775_l("soa_sacrifice_pedestal");
        instance.setSacrificePedestal(new BlockPos(sacrificePedestal.func_74762_e("x"), sacrificePedestal.func_74762_e("y"), sacrificePedestal.func_74762_e("z")));
        for (String key2 : storage.func_74775_l("recipes").func_150296_c()) {
            instance.getKnownRecipeList().add(new ResourceLocation(key2));
        }
        for (String key3 : storage.func_74775_l("magics").func_150296_c()) {
            instance.getMagicList().add(key3.toString());
        }
        for (String driveFormName : storage.func_74775_l("drive_forms").func_150296_c()) {
            instance.getDriveFormMap().put(driveFormName.toString(), storage.func_74775_l("drive_forms").func_74759_k(driveFormName));
        }
        for (String abilityName : storage.func_74775_l("abilities").func_150296_c()) {
            instance.getAbilityMap().put(abilityName.toString(), storage.func_74775_l("abilities").func_74759_k(abilityName));
        }
        CompoundNBT keychainsNBT = storage.func_74775_l("keychains");
        keychainsNBT.func_150296_c().forEach(chain -> instance.setNewKeychain(new ResourceLocation(chain), ItemStack.func_199557_a((CompoundNBT)keychainsNBT.func_74775_l(chain))));
        instance.setHearts(storage.func_74762_e("hearts"));
        instance.setAlignment(storage.func_74762_e("org_alignment"));
        instance.equipWeapon(ItemStack.func_199557_a((CompoundNBT)storage.func_74775_l("org_equipped_weapon")));
        CompoundNBT unlocksCompound = storage.func_74775_l("org_weapons_unlocked");
        unlocksCompound.func_150296_c().forEach(key -> instance.unlockWeapon(ItemStack.func_199557_a((CompoundNBT)unlocksCompound.func_74775_l(key))));
        for (String key4 : storage.func_74775_l("parties").func_150296_c()) {
            instance.getPartiesInvited().add(key4.toString());
        }
        for (String mat : storage.func_74775_l("materials").func_150296_c()) {
            instance.getMaterialMap().put(mat.toString(), storage.func_74775_l("materials").func_74762_e(mat));
        }
        instance.setLimitCooldownTicks(storage.func_74762_e("limit_cooldown"));
    }
}

