/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.handler.EntityEvents;
import online.kingdomkeys.kingdomkeys.item.organization.ArrowgunItem;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.lib.PortalData;
import online.kingdomkeys.kingdomkeys.limit.Limit;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CommandMenuGui
extends Screen {
    public static final int TOP = 5;
    public static final int ATTACK = 4;
    public static final int MAGIC = 3;
    public static final int ITEMS = 2;
    public static final int DRIVE = 1;
    int TOP_WIDTH = 70;
    int TOP_HEIGHT = 15;
    int MENU_WIDTH = 71;
    int MENU_HEIGHT = 15;
    int iconWidth = 10;
    int textX = 0;
    public static final int SUB_MAIN = 0;
    public static final int SUB_MAGIC = 1;
    public static final int SUB_ITEMS = 2;
    public static final int SUB_DRIVE = 3;
    public static final int SUB_PORTALS = 4;
    public static final int SUB_ATTACKS = 5;
    public static final int SUB_TARGET = 6;
    public static final int SUB_LIMIT = 7;
    public static final int NONE = 0;
    public static int selected = 4;
    public static int targetSelected = 0;
    public static int submenu = 0;
    public static int magicSelected = 0;
    public static int potionSelected = 0;
    public static int driveSelected = 0;
    public static int portalSelected = 0;
    public static int attackSelected = 0;
    public static int limitSelected = 0;
    ResourceLocation texture = new ResourceLocation("kingdomkeys", "textures/gui/commandmenu.png");
    float alpha = 1.0f;
    float scale = 1.05f;
    float[] orgColor = new float[]{0.8f, 0.8f, 0.8f};
    float[] normalModeColor = new float[]{0.04f, 0.2f, 1.0f, 0.0f};
    float[] portalMenuColor = new float[]{0.8f, 0.8f, 0.8f, 4.0f};
    float[] combatModeColor = new float[]{1.0f, 0.0f, 0.0f, 0.0f};
    float[] magicMenuColor = new float[]{0.4f, 0.0f, 1.0f, 1.0f};
    float[] itemsMenuColor = new float[]{0.3f, 1.0f, 0.3f, 2.0f};
    float[] driveMenuColor = new float[]{0.0f, 1.0f, 1.0f, 3.0f};
    float[] limitMenuColor = new float[]{1.0f, 1.0f, 0.0f, 7.0f};
    float[] targetModeColor = new float[]{0.04f, 0.2f, 1.0f, 6.0f};

    public CommandMenuGui() {
        super((ITextComponent)new TranslationTextComponent("", new Object[0]));
        this.minecraft = Minecraft.func_71410_x();
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onRenderOverlayPost(RenderGameOverlayEvent event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            RenderSystem.pushMatrix();
            this.drawCommandMenu(this.minecraft.func_228018_at_().func_198107_o(), this.minecraft.func_228018_at_().func_198087_p());
            RenderSystem.popMatrix();
        }
    }

    private int getColor(int colour, int sub) {
        if (submenu == sub) {
            return colour;
        }
        Color c = Color.decode(String.valueOf(colour));
        return c.darker().darker().getRGB();
    }

    private void paintWithColorArray(float[] array, float alpha) {
        if (EntityEvents.isHostiles) {
            if ((float)submenu == array[3]) {
                RenderSystem.color4f((float)this.combatModeColor[0], (float)this.combatModeColor[1], (float)this.combatModeColor[2], (float)alpha);
            } else {
                RenderSystem.color4f((float)(this.combatModeColor[0] / 2.0f), (float)(array[1] / 2.0f), (float)(this.combatModeColor[2] / 2.0f), (float)alpha);
            }
        } else if (ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g).getAlignment() != Utils.OrgMember.NONE && array == this.normalModeColor) {
            if ((float)submenu == array[3]) {
                RenderSystem.color4f((float)this.orgColor[0], (float)this.orgColor[1], (float)this.orgColor[2], (float)alpha);
            } else {
                RenderSystem.color4f((float)(this.orgColor[0] / 2.0f), (float)(this.orgColor[1] / 2.0f), (float)(this.orgColor[2] / 2.0f), (float)alpha);
            }
        } else if ((float)submenu == array[3]) {
            RenderSystem.color4f((float)array[0], (float)array[1], (float)array[2], (float)alpha);
        } else {
            RenderSystem.color4f((float)(array[0] / 2.0f), (float)(array[1] / 2.0f), (float)(array[2] / 2.0f), (float)alpha);
        }
    }

    public void drawCommandMenu(int width, int height) {
        if (ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g) != null) {
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)ModConfigs.cmXPos, (double)0.0, (double)0.0);
            this.drawMain(width, height);
            if (submenu == 4) {
                this.drawSubPortals(width, height);
            }
            if (submenu == 1 || submenu == 6) {
                this.drawSubMagic(width, height);
            }
            if (submenu == 3) {
                this.drawSubDrive(width, height);
            }
            if (submenu == 7) {
                this.drawSubLimits(width, height);
            }
            if (submenu == 6) {
                this.drawSubTargetSelector(width, height);
            }
            RenderSystem.popMatrix();
        }
    }

    private String getCommandMenuName(int i) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g);
        switch (i) {
            case 4: {
                return playerData.getAlignment() == Utils.OrgMember.NONE ? "gui.commandmenu.attack" : "gui.commandmenu.portal";
            }
            case 3: {
                return "gui.commandmenu.magic";
            }
            case 2: {
                return "gui.commandmenu.items";
            }
            case 1: {
                return playerData.getAlignment() == Utils.OrgMember.NONE ? (playerData.getActiveDriveForm().equals(DriveForm.NONE.toString()) ? "gui.commandmenu.drive" : "gui.commandmenu.revert") : "gui.commandmenu.limit";
            }
        }
        return "";
    }

    public void drawMain(int width, int height) {
        RenderSystem.enableBlend();
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        this.minecraft.field_71446_o.func_110577_a(this.texture);
        RenderSystem.translatef((float)0.0f, (float)((float)height - (float)this.MENU_HEIGHT * this.scale * 5.0f), (float)0.0f);
        RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        this.textX = 0;
        this.paintWithColorArray(this.normalModeColor, this.alpha);
        this.drawHeader("gui.commandmenu.command", 0);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        boolean x = false;
        for (int i = 1; i <= 4; ++i) {
            ItemStack weapon;
            RenderSystem.pushMatrix();
            this.minecraft.field_71446_o.func_110577_a(this.texture);
            RenderSystem.translatef((float)((float)x), (float)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)i), (float)0.0f);
            RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
            this.paintWithColorArray(this.normalModeColor, this.alpha);
            ClientPlayerEntity player = this.minecraft.field_71439_g;
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            if (selected == i) {
                this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                this.drawSelectedSlot();
                if (selected == 4 && playerData.getAlignment() != Utils.OrgMember.NONE) {
                    this.drawIcon(selected + 1, 0);
                } else {
                    this.drawIcon(selected, 0);
                }
            } else {
                this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                this.drawUnselectedSlot();
            }
            int color = this.getColor(0xFFFFFF, 0);
            if (i == 3) {
                int n = color = playerData.getMagicList().isEmpty() || playerData.getMaxMP() == 0.0 || playerData.getActiveDriveForm().equals("kingdomkeys:form_valor") ? 0x888888 : this.getColor(0xFFFFFF, 0);
            }
            if (i == 2) {
                color = this.getColor(0x888888, 0);
            }
            if (i == 1) {
                color = this.getColor(0x888888, 0);
                color = playerData.getAlignment() != Utils.OrgMember.NONE ? (playerData.getLimitCooldown() <= 0 ? this.getColor(0xFFFFFF, 0) : this.getColor(0x888888, 0)) : (playerData.getActiveDriveForm().equals("kingdomkeys:form_anti") || playerData.getDriveFormMap().size() <= 1 ? this.getColor(0x888888, 0) : this.getColor(0xFFFFFF, 0));
            }
            this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal(this.getCommandMenuName(i)), this.textX, 4, color);
            if (i == 4 && player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ArrowgunItem && (weapon = player.func_184614_ca()).func_77942_o() && weapon.func_77978_p().func_74764_b("ammo")) {
                int ammo = weapon.func_77978_p().func_74762_e("ammo");
                this.drawString(this.minecraft.field_71466_p, ammo + "", (int)((double)this.TOP_WIDTH * ((double)ModConfigs.cmXScale / 100.0) + (double)this.TOP_WIDTH * ((double)ModConfigs.cmXScale / 100.0) * 0.1), 4, 0xFFFFFF);
            }
            RenderSystem.popMatrix();
        }
        RenderSystem.popMatrix();
        RenderSystem.disableBlend();
    }

    private void drawSubTargetSelector(int width, int height) {
        RenderSystem.enableBlend();
        IWorldCapabilities worldData = ModCapabilities.getWorld((World)this.minecraft.field_71441_e);
        if (worldData == null || worldData.getPartyFromMember(this.minecraft.field_71439_g.func_110124_au()) == null) {
            submenu = 1;
            return;
        }
        double x = (double)(20 * ModConfigs.cmSubXOffset) / 100.0;
        RenderSystem.pushMatrix();
        this.paintWithColorArray(this.targetModeColor, this.alpha);
        this.minecraft.field_71446_o.func_110577_a(this.texture);
        RenderSystem.translated((double)x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(worldData.getPartyFromMember(this.minecraft.field_71439_g.func_110124_au()).getMembers().size() + 1)), (double)0.0);
        RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        this.drawHeader("TARGET", 6);
        RenderSystem.popMatrix();
        for (int i = 0; i < worldData.getPartyFromMember(this.minecraft.field_71439_g.func_110124_au()).getMembers().size(); ++i) {
            RenderSystem.pushMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
            this.minecraft.field_71446_o.func_110577_a(this.texture);
            RenderSystem.translated((double)x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(worldData.getPartyFromMember(this.minecraft.field_71439_g.func_110124_au()).getMembers().size() - i)), (double)0.0);
            RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
            if (submenu == 6) {
                this.paintWithColorArray(this.targetModeColor, this.alpha);
                if (targetSelected == i) {
                    this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                    this.drawSelectedSlot();
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                    this.drawIcon(selected, 6);
                } else {
                    this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                    this.drawUnselectedSlot();
                }
                Party.Member member = worldData.getPartyFromMember(this.minecraft.field_71439_g.func_110124_au()).getMembers().get(i);
                int color = this.minecraft.field_71441_e.func_217371_b(member.getUUID()) != null && this.minecraft.field_71439_g.func_70032_d((Entity)this.minecraft.field_71441_e.func_217371_b(member.getUUID())) < (float)ModConfigs.partyRangeLimit ? 0xFFFFFF : 0x888888;
                this.drawString(this.minecraft.field_71466_p, member.getUsername(), (int)((float)this.textX + (float)ModConfigs.cmXScale / 100.0f), 4, color);
            }
            RenderSystem.popMatrix();
        }
        RenderSystem.disableBlend();
    }

    private void drawHeader(String text, int subMenu) {
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)((float)ModConfigs.cmXScale / 100.0f), (float)1.0f, (float)1.0f);
        this.blit(0, 0, 0, 0, this.TOP_WIDTH, this.TOP_HEIGHT);
        RenderSystem.popMatrix();
        if (ModConfigs.cmHeaderTextVisible) {
            this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal(text), (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset, 4, this.getColor(0xFFFFFF, subMenu));
        }
    }

    private void drawSelectedSlot() {
        RenderSystem.enableBlend();
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)((float)ModConfigs.cmXScale / 100.0f), (float)1.0f, (float)1.0f);
        this.blit(5, 0, this.TOP_WIDTH, this.MENU_HEIGHT, this.TOP_WIDTH, this.MENU_HEIGHT);
        RenderSystem.popMatrix();
        RenderSystem.disableBlend();
    }

    private void drawUnselectedSlot() {
        RenderSystem.enableBlend();
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)((float)ModConfigs.cmXScale / 100.0f), (float)1.0f, (float)1.0f);
        this.blit(0, 0, this.TOP_WIDTH, 0, this.TOP_WIDTH, 0 + this.MENU_HEIGHT);
        RenderSystem.popMatrix();
        RenderSystem.disableBlend();
    }

    private void drawIcon(int selected, int subMenu) {
        RenderSystem.enableBlend();
        if (subMenu == submenu) {
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        } else {
            RenderSystem.color4f((float)0.5f, (float)0.5f, (float)0.5f, (float)this.alpha);
        }
        this.blit((int)((double)this.TOP_WIDTH * ((double)ModConfigs.cmXScale / 100.0) - (double)this.TOP_WIDTH * ((double)ModConfigs.cmXScale / 100.0) * 0.15), 2, 140 + selected * this.iconWidth - this.iconWidth, 18, this.iconWidth, this.iconWidth);
        RenderSystem.disableBlend();
    }

    public void drawTop(int width, int height) {
        RenderSystem.enableBlend();
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
        this.minecraft.field_71446_o.func_110577_a(this.texture);
        RenderSystem.translatef((float)0.0f, (float)((float)height - (float)this.MENU_HEIGHT * this.scale * 5.0f), (float)0.0f);
        RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
        this.textX = 0;
        this.paintWithColorArray(this.normalModeColor, this.alpha);
        this.drawHeader("gui.commandmenu.command", 0);
        RenderSystem.popMatrix();
        RenderSystem.disableBlend();
    }

    public void drawSubPortals(int width, int height) {
        RenderSystem.enableBlend();
        IWorldCapabilities worldData = ModCapabilities.getWorld(this.minecraft.field_71439_g.field_70170_p);
        List<UUID> portals = worldData.getAllPortalsFromOwnerID(this.minecraft.field_71439_g.func_110124_au());
        if (portals != null && !portals.isEmpty()) {
            double x = (double)(10 * ModConfigs.cmSubXOffset) / 100.0;
            RenderSystem.pushMatrix();
            this.paintWithColorArray(this.portalMenuColor, this.alpha);
            this.minecraft.field_71446_o.func_110577_a(this.texture);
            RenderSystem.translated((double)x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(portals.size() + 1)), (double)0.0);
            RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
            this.drawHeader("gui.commandmenu.portal.title", 4);
            RenderSystem.popMatrix();
            for (int i = 0; i < portals.size(); ++i) {
                RenderSystem.pushMatrix();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                this.minecraft.field_71446_o.func_110577_a(this.texture);
                RenderSystem.translated((double)x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(portals.size() - i)), (double)0.0);
                RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
                if (submenu == 4) {
                    this.paintWithColorArray(this.portalMenuColor, this.alpha);
                    if (portalSelected == i) {
                        this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                        this.drawSelectedSlot();
                        this.drawIcon(selected, 4);
                    } else {
                        this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                        this.drawUnselectedSlot();
                    }
                    UUID portalUUID = portals.get(i);
                    PortalData portal = worldData.getPortalFromUUID(portalUUID);
                    if (portal != null) {
                        this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal(portal.getName()), this.textX, 4, 0xFFFFFF);
                    }
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                RenderSystem.popMatrix();
            }
        }
        RenderSystem.disableBlend();
    }

    private void drawSubMagic(int width, int height) {
        RenderSystem.enableBlend();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g);
        if (playerData != null && playerData.getMagicList() != null && !playerData.getMagicList().isEmpty()) {
            double x = (double)(10 * ModConfigs.cmSubXOffset) / 100.0;
            RenderSystem.pushMatrix();
            this.minecraft.field_71446_o.func_110577_a(this.texture);
            RenderSystem.translated((double)x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(playerData.getMagicList().size() + 1)), (double)0.0);
            RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
            this.paintWithColorArray(this.magicMenuColor, this.alpha);
            this.drawHeader("gui.commandmenu.magic.title", 1);
            RenderSystem.popMatrix();
            for (int i = 0; i < playerData.getMagicList().size(); ++i) {
                int colour;
                RenderSystem.pushMatrix();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                this.minecraft.field_71446_o.func_110577_a(this.texture);
                RenderSystem.translated((double)x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(playerData.getMagicList().size() - i)), (double)0.0);
                RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
                this.paintWithColorArray(this.magicMenuColor, this.alpha);
                if (magicSelected == i) {
                    this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                    this.drawSelectedSlot();
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                    this.drawIcon(selected, 1);
                } else {
                    this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                    this.drawUnselectedSlot();
                }
                String magic = playerData.getMagicList().get(i);
                Magic magicInstance = (Magic)ModMagic.registry.getValue(new ResourceLocation(magic));
                int cost = magicInstance.getCost();
                int n = colour = playerData.getMP() > (double)cost ? 0xFFFFFF : 0xFF9900;
                if (playerData.getMaxMP() == 0.0 || playerData.getRecharge() || (double)cost > playerData.getMaxMP() && cost < 300) {
                    colour = 0x888888;
                }
                magic = magicInstance.getTranslationKey();
                this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal(magic), this.textX, 4, this.getColor(colour, 1));
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.popMatrix();
            }
        }
        RenderSystem.disableBlend();
    }

    private void drawSubDrive(int width, int height) {
        RenderSystem.enableBlend();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g);
        LinkedHashMap<String, int[]> forms = Utils.getSortedDriveForms(playerData.getDriveFormMap());
        forms.remove(DriveForm.NONE.toString());
        double x = (double)(10 * ModConfigs.cmSubXOffset) / 100.0;
        if (playerData != null && forms != null && !forms.isEmpty()) {
            RenderSystem.pushMatrix();
            this.paintWithColorArray(this.driveMenuColor, this.alpha);
            this.minecraft.field_71446_o.func_110577_a(this.texture);
            RenderSystem.translated((double)x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(forms.size() + 1)), (double)0.0);
            RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
            this.drawHeader("gui.commandmenu.drive.title", 3);
            RenderSystem.popMatrix();
            for (int i = 0; i < forms.size(); ++i) {
                String formName = (String)forms.keySet().toArray()[i];
                if (formName.equals(DriveForm.NONE.toString())) continue;
                DriveForm form = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(formName));
                int cost = form.getDriveCost();
                int color = playerData.getDP() >= (double)cost ? 0xFFFFFF : 0x888888;
                formName = form.getTranslationKey();
                RenderSystem.pushMatrix();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                this.minecraft.field_71446_o.func_110577_a(this.texture);
                RenderSystem.translated((double)x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(forms.size() - i)), (double)0.0);
                RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
                if (submenu == 3) {
                    this.paintWithColorArray(this.driveMenuColor, this.alpha);
                    if (driveSelected == i) {
                        this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                        this.drawSelectedSlot();
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                        this.drawIcon(selected, 3);
                    } else {
                        this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0) + ModConfigs.cmTextXOffset;
                        this.drawUnselectedSlot();
                    }
                }
                RenderSystem.color4f((float)0.3f, (float)0.3f, (float)0.3f, (float)this.alpha);
                RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
                if (submenu == 3) {
                    this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal(formName), this.textX, 4, color);
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                RenderSystem.popMatrix();
            }
        }
        RenderSystem.disableBlend();
    }

    private void drawSubLimits(int width, int height) {
        RenderSystem.enableBlend();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g);
        List<Limit> limits = Utils.getPlayerLimitAttacks((PlayerEntity)this.minecraft.field_71439_g);
        if (playerData != null && limits != null && !limits.isEmpty()) {
            double x = (double)(10 * ModConfigs.cmSubXOffset) / 100.0;
            RenderSystem.pushMatrix();
            this.minecraft.field_71446_o.func_110577_a(this.texture);
            RenderSystem.translated((double)x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(limits.size() + 1)), (double)0.0);
            RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
            this.paintWithColorArray(this.limitMenuColor, this.alpha);
            this.drawHeader("gui.commandmenu.limit.title", 7);
            RenderSystem.popMatrix();
            for (int i = 0; i < limits.size(); ++i) {
                RenderSystem.pushMatrix();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)this.alpha);
                this.minecraft.field_71446_o.func_110577_a(this.texture);
                RenderSystem.translated((double)x, (double)((float)height - (float)this.MENU_HEIGHT * this.scale * (float)(limits.size() - i)), (double)0.0);
                RenderSystem.scalef((float)this.scale, (float)this.scale, (float)this.scale);
                this.paintWithColorArray(this.limitMenuColor, this.alpha);
                if (limitSelected == i) {
                    this.textX = (int)((double)(10 * ModConfigs.cmXScale) / 100.0 * 1.3) + ModConfigs.cmTextXOffset;
                    this.drawSelectedSlot();
                    this.drawIcon(selected, 7);
                } else {
                    this.textX = (int)((double)(5 * ModConfigs.cmXScale) / 100.0 * 1.3) + ModConfigs.cmTextXOffset;
                    this.drawUnselectedSlot();
                }
                int limitCost = limits.get(i).getCost();
                int color = playerData.getDP() >= (double)limitCost ? 0xFFFFFF : 0x888888;
                String name = limits.get(i).getTranslationKey();
                RenderSystem.scalef((float)(this.scale * 0.7f), (float)(this.scale * 0.9f), (float)this.scale);
                this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal(name), this.textX, 4, this.getColor(color, 7));
                RenderSystem.scalef((float)(this.scale * 1.3f), (float)(this.scale * 1.1f), (float)this.scale);
                this.drawString(this.minecraft.field_71466_p, limitCost / 100 + "", (int)((double)this.TOP_WIDTH * ((double)ModConfigs.cmXScale / 100.0) + (double)this.TOP_WIDTH * ((double)ModConfigs.cmXScale / 100.0) * 0.1), 4, this.getColor(65535, 7));
                RenderSystem.popMatrix();
            }
        }
        RenderSystem.disableBlend();
    }
}

