/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.network.play.NetworkPlayerInfo;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.config.ModConfigs;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class PartyHUDGui
extends Screen {
    int hpBarWidth;
    int guiHeight = 10;
    int counter = 0;

    public PartyHUDGui() {
        super((ITextComponent)new TranslationTextComponent("", new Object[0]));
        this.minecraft = Minecraft.func_71410_x();
    }

    public ResourceLocation getLocationSkin(PlayerEntity player) {
        NetworkPlayerInfo networkplayerinfo = Minecraft.func_71410_x().func_147114_u().func_175102_a(player.func_110124_au());
        return networkplayerinfo == null ? DefaultPlayerSkin.func_177334_a((UUID)player.func_110124_au()) : networkplayerinfo.func_178837_g();
    }

    @SubscribeEvent
    public void onRenderOverlayPost(RenderGameOverlayEvent event) {
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        if (!event.getType().equals((Object)RenderGameOverlayEvent.ElementType.HEALTH) || event.isCancelable()) {
            // empty if block
        }
        if (event.getType() == RenderGameOverlayEvent.ElementType.TEXT) {
            int screenWidth = this.minecraft.func_228018_at_().func_198107_o();
            int screenHeight = this.minecraft.func_228018_at_().func_198087_p();
            float scale = 0.5f;
            IWorldCapabilities worldData = ModCapabilities.getWorld((World)this.minecraft.field_71441_e);
            Party p = worldData.getPartyFromMember(player.func_110124_au());
            if (p == null) {
                return;
            }
            ArrayList<Party.Member> allies = new ArrayList<Party.Member>();
            allies.clear();
            for (Party.Member m : p.getMembers()) {
                if (m.getUUID().equals(player.func_110124_au())) continue;
                allies.add(m);
            }
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)ModConfigs.partyXPos, (double)ModConfigs.partyYPos, (double)0.0);
            for (int i = 0; i < allies.size(); ++i) {
                Party.Member member = (Party.Member)allies.get(i);
                PlayerEntity playerAlly = player.field_70170_p.func_217371_b(member.getUUID());
                if (playerAlly != null) {
                    this.renderFace(playerAlly, screenWidth, screenHeight, scale, i);
                    continue;
                }
                this.renderFace(null, screenWidth, screenHeight, scale, i);
            }
            RenderSystem.popMatrix();
        }
    }

    public void renderFace(PlayerEntity playerAlly, float screenWidth, float screenHeight, float scale, int i) {
        String name;
        ResourceLocation skin = playerAlly != null ? this.getLocationSkin(playerAlly) : new ResourceLocation("minecraft", "textures/entity/steve.png");
        this.minecraft.func_110434_K().func_110577_a(skin);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)-16.0f, (float)(-screenHeight / 4.0f * ((float)((i + 1) * ModConfigs.partyYOffset) / 100.0f)), (float)0.0f);
        int headWidth = 32;
        int headHeight = 32;
        float headPosX = 0.0f;
        float headPosY = 0.0f;
        float scaledHeadPosX = headPosX * scale;
        float scaledHeadPosY = headPosY * scale;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(screenWidth - (float)headWidth * scale - scaledHeadPosX), (float)(screenHeight - (float)headHeight * scale - scaledHeadPosY), (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        if (playerAlly == null) {
            RenderSystem.color4f((float)0.2f, (float)0.2f, (float)0.2f, (float)1.0f);
        }
        this.blit(0, 0, 32, 32, headWidth, headHeight);
        RenderSystem.popMatrix();
        int hatWidth = 32;
        int hatHeight = 32;
        float hatPosX = 0.0f;
        float hatPosY = 0.0f;
        float scaledHatPosX = hatPosX * scale;
        float scaledHatPosY = hatPosY * scale;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(screenWidth - (float)hatWidth * scale - scaledHatPosX), (float)(screenHeight - (float)hatHeight * scale - scaledHatPosY), (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        this.blit(0, 0, 160, 32, hatWidth, hatHeight);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(screenWidth - (float)hatWidth * scale - scaledHatPosX), (float)(screenHeight - (float)hatHeight * scale - scaledHatPosY), (float)0.0f);
        RenderSystem.scalef((float)scale, (float)scale, (float)scale);
        String string = name = playerAlly == null ? "Out of range" : playerAlly.func_145748_c_().func_150254_d();
        if (playerAlly != null && this.minecraft.field_71439_g.func_70032_d((Entity)playerAlly) >= (float)ModConfigs.partyRangeLimit) {
            this.drawCenteredString(this.minecraft.field_71466_p, "Out of range", 16, -20, 0xFFFFFF);
        }
        this.drawCenteredString(this.minecraft.field_71466_p, name, 16, -10, 0xFFFFFF);
        RenderSystem.popMatrix();
        if (playerAlly != null) {
            RenderSystem.translatef((float)(screenWidth - (float)headWidth * scale - scaledHeadPosX), (float)(screenHeight - (float)headHeight * scale - scaledHeadPosY), (float)0.0f);
            float val = playerAlly.func_110143_aJ();
            float max = playerAlly.func_110138_aP();
            this.minecraft.field_71446_o.func_110577_a(new ResourceLocation("kingdomkeys", "textures/gui/hpbar.png"));
            RenderSystem.translatef((float)-4.0f, (float)0.0f, (float)1.0f);
            RenderSystem.pushMatrix();
            RenderSystem.scalef((float)(scale / 3.0f * 2.0f), (float)scale, (float)1.0f);
            this.blit(0, 0, 0, 72, 12, 2);
            RenderSystem.popMatrix();
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)1.0f, (float)1.0f);
            RenderSystem.scalef((float)(scale / 3.0f * 2.0f), (float)(scale * 28.0f), (float)1.0f);
            this.blit(0, 0, 0, 74, 12, 1);
            RenderSystem.popMatrix();
            RenderSystem.pushMatrix();
            RenderSystem.translatef((float)0.0f, (float)30.0f, (float)1.0f);
            RenderSystem.scalef((float)(scale / 3.0f * 2.0f), (float)scale, (float)1.0f);
            this.blit(0, -30, 0, 72, 12, 2);
            RenderSystem.popMatrix();
            RenderSystem.pushMatrix();
            RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            RenderSystem.translatef((float)-4.0f, (float)-15.0f, (float)1.0f);
            RenderSystem.scalef((float)(scale * 0.66f), (float)(scale * 28.0f * val / max), (float)1.0f);
            this.blit(0, 0, 0, 78, 12, 1);
            RenderSystem.popMatrix();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(playerAlly);
            if (playerData != null) {
                val = (float)playerData.getMP();
                max = (float)playerData.getMaxMP();
                this.minecraft.field_71446_o.func_110577_a(new ResourceLocation("kingdomkeys", "textures/gui/mpbar.png"));
                RenderSystem.translatef((float)20.0f, (float)0.0f, (float)1.0f);
                RenderSystem.pushMatrix();
                RenderSystem.scalef((float)(scale / 3.0f * 2.0f), (float)scale, (float)1.0f);
                this.blit(0, 0, 0, 58, 12, 2);
                RenderSystem.popMatrix();
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)0.0f, (float)1.0f, (float)1.0f);
                RenderSystem.scalef((float)(scale / 3.0f * 2.0f), (float)(scale * 28.0f), (float)1.0f);
                this.blit(0, 0, 0, 60, 12, 1);
                RenderSystem.popMatrix();
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)0.0f, (float)30.0f, (float)1.0f);
                RenderSystem.scalef((float)(scale / 3.0f * 2.0f), (float)scale, (float)1.0f);
                this.blit(0, -30, 0, 58, 12, 2);
                RenderSystem.popMatrix();
                RenderSystem.pushMatrix();
                RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                RenderSystem.translatef((float)-4.0f, (float)-15.0f, (float)1.0f);
                RenderSystem.scalef((float)(scale / 3.0f * 2.0f), (float)(scale * 28.0f * val / max), (float)1.0f);
                this.blit(0, 0, 0, 64, 12, 1);
                RenderSystem.popMatrix();
            }
        }
        RenderSystem.popMatrix();
    }
}

