/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class SoAMessages
extends AbstractGui {
    public static final SoAMessages INSTANCE = new SoAMessages();
    private final Queue<Title> messages = new LinkedList<Title>();
    FontRenderer font;
    String displayedTitle;
    String displayedSubTitle;
    int titleFadeIn;
    int titleDisplayTime;
    int titleFadeOut;
    int titlesTimer;
    float scaledWidth;
    float scaledHeight;

    public void queueMessages(Title ... messages) {
        this.messages.addAll(Arrays.asList(messages));
    }

    public void queueMessage(Title message) {
        this.messages.add(message);
    }

    public void clearMessage() {
        this.messages.clear();
        this.displayedTitle = "";
        this.displayedSubTitle = "";
        this.titlesTimer = 0;
    }

    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Text event) {
        if (!this.messages.isEmpty() || this.titlesTimer != 0) {
            this.draw(event.getPartialTicks());
        }
    }

    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (!(Minecraft.func_71410_x().func_147113_T() || this.messages.isEmpty() && this.titlesTimer == 0)) {
            this.tick();
        }
    }

    private SoAMessages() {
        this.font = Minecraft.func_71410_x().field_71466_p;
    }

    public void displayTitle(String title, String subTitle, int timeFadeIn, int displayTime, int timeFadeOut) {
        if (title == null && subTitle == null && timeFadeIn < 0 && displayTime < 0 && timeFadeOut < 0) {
            this.displayedTitle = "";
            this.titlesTimer = 0;
        } else if (title != null) {
            this.displayedSubTitle = subTitle;
            this.displayedTitle = title;
            this.titleFadeIn = timeFadeIn;
            this.titleDisplayTime = displayTime;
            this.titleFadeOut = timeFadeOut;
            this.titlesTimer = this.titleFadeIn + this.titleDisplayTime + this.titleFadeOut;
        } else if (subTitle != null) {
            this.displayedTitle = "";
            this.displayedSubTitle = subTitle;
            this.titleFadeIn = timeFadeIn;
            this.titleDisplayTime = displayTime;
            this.titleFadeOut = timeFadeOut;
            this.titlesTimer = this.titleFadeIn + this.titleDisplayTime + this.titleFadeOut;
        } else {
            if (timeFadeIn >= 0) {
                this.titleFadeIn = timeFadeIn;
            }
            if (displayTime >= 0) {
                this.titleDisplayTime = displayTime;
            }
            if (timeFadeOut >= 0) {
                this.titleFadeOut = timeFadeOut;
            }
            if (this.titlesTimer > 0) {
                this.titlesTimer = this.titleFadeIn + this.titleDisplayTime + this.titleFadeOut;
            }
        }
    }

    public void draw(float partialTicks) {
        this.scaledWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        this.scaledHeight = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        if (this.titlesTimer > 0) {
            float f4 = (float)this.titlesTimer - partialTicks;
            int j1 = 255;
            if (this.titlesTimer > this.titleFadeOut + this.titleDisplayTime) {
                float f5 = (float)(this.titleFadeIn + this.titleDisplayTime + this.titleFadeOut) - f4;
                j1 = (int)(f5 * 255.0f / (float)this.titleFadeIn);
            }
            if (this.titlesTimer <= this.titleFadeOut) {
                j1 = (int)(f4 * 255.0f / (float)this.titleFadeOut);
            }
            if ((j1 = MathHelper.func_76125_a((int)j1, (int)0, (int)255)) > 8) {
                RenderSystem.pushMatrix();
                RenderSystem.translatef((float)(this.scaledWidth / 2.0f), (float)(this.scaledHeight / 2.0f), (float)0.0f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.pushMatrix();
                RenderSystem.scalef((float)4.0f, (float)4.0f, (float)4.0f);
                int l1 = j1 << 24 & 0xFF000000;
                int i2 = this.font.func_78256_a(Utils.translateToLocal(this.displayedTitle));
                this.renderTextBackground(this.font, -10, i2);
                this.font.func_175063_a(Utils.translateToLocal(this.displayedTitle), (float)(-i2 / 2), -10.0f, 0xFFFFFF | l1);
                RenderSystem.popMatrix();
                if (!this.displayedSubTitle.isEmpty()) {
                    RenderSystem.pushMatrix();
                    RenderSystem.scalef((float)2.0f, (float)2.0f, (float)2.0f);
                    int k = this.font.func_78256_a(Utils.translateToLocal(this.displayedSubTitle));
                    this.renderTextBackground(this.font, 5, k);
                    this.font.func_175063_a(Utils.translateToLocal(this.displayedSubTitle), (float)(-k / 2), 5.0f, 0xFFFFFF | l1);
                    RenderSystem.popMatrix();
                }
                RenderSystem.disableBlend();
                RenderSystem.popMatrix();
            }
        }
    }

    protected void renderTextBackground(FontRenderer fontRendererIn, int yIn, int stringWidthIn) {
        int i = Minecraft.func_71410_x().field_71474_y.func_216841_b(0.0f);
        if (i != 0) {
            int j = -stringWidthIn / 2;
            SoAMessages.fill((int)(j - 2), (int)(yIn - 2), (int)(j + stringWidthIn + 2), (int)(yIn + 9 + 2), (int)i);
        }
    }

    public void tick() {
        if (this.titlesTimer > 0) {
            --this.titlesTimer;
            if (this.titlesTimer <= 0) {
                this.displayedTitle = "";
                this.displayedSubTitle = "";
            }
        }
        if (!this.messages.isEmpty() && this.titlesTimer == 0) {
            Title t = this.messages.poll();
            this.displayTitle(t.title, t.subtitle, t.fadeIn, t.displayTime, t.fadeOut);
        }
    }

    public static class Title {
        public String title;
        public String subtitle;
        public int fadeIn = 10;
        public int fadeOut = 20;
        public int displayTime = 70;

        public Title(String title, String subtitle, int fadeIn, int displayTime, int fadeOut) {
            this.title = title;
            this.subtitle = subtitle;
            this.fadeIn = fadeIn;
            this.fadeOut = fadeOut;
            this.displayTime = displayTime;
        }

        public Title(String title, String subtitle) {
            this.title = title;
            this.subtitle = subtitle;
        }
    }
}

