/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.container;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.HiddenButton;
import online.kingdomkeys.kingdomkeys.container.SynthesisBagContainer;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSUpgradeSynthesisBagPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class SynthesisBagScreen
extends ContainerScreen<SynthesisBagContainer> {
    private static final String textureBase = "kingdomkeys:textures/gui/synthesis_bag_";
    int[] texHeight = new int[]{140, 176, 212};
    int bagLevel = 0;
    HiddenButton upgrade;

    public SynthesisBagScreen(SynthesisBagContainer container, PlayerInventory playerInv, ITextComponent title) {
        super((Container)container, playerInv, title);
        this.minecraft = Minecraft.func_71410_x();
    }

    protected void init() {
        CompoundNBT nbt = this.field_213127_e.func_70448_g().func_196082_o();
        this.bagLevel = nbt.func_74762_e("level");
        this.field_147000_g = this.texHeight[this.bagLevel];
        this.field_146999_f = 193;
        this.upgrade = new HiddenButton((this.width - this.field_146999_f) / 2 + this.field_146999_f - 20, this.height / 2 - this.field_147000_g / 2 + 17, 18, 18, e -> this.upgrade());
        this.addButton((Widget)this.upgrade);
        super.init();
    }

    private void upgrade() {
        if (this.bagLevel < 2 && ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g).getMunny() >= Utils.getBagCosts(this.bagLevel)) {
            PacketHandler.sendToServer(new CSUpgradeSynthesisBagPacket());
            this.onClose();
        }
    }

    public void render(int x, int y, float partialTicks) {
        this.renderBackground();
        super.render(x, y, partialTicks);
        this.func_191948_b(x, y);
        ArrayList<String> list = new ArrayList<String>();
        boolean bl = this.upgrade.visible = this.bagLevel < 2;
        if (this.upgrade.visible && x >= this.upgrade.x && x <= this.upgrade.x + this.upgrade.getWidth() && y >= this.upgrade.y && y <= this.upgrade.y + this.upgrade.getHeight()) {
            list.add(new TranslationTextComponent("gui.synthesisbag.upgrade", new Object[0]).func_150254_d());
            list.add(TextFormatting.YELLOW + new TranslationTextComponent("gui.synthesisbag.munny", new Object[0]).func_150254_d() + ": " + Utils.getBagCosts(this.bagLevel));
            if (ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g).getMunny() < Utils.getBagCosts(this.bagLevel)) {
                list.add(TextFormatting.RED + new TranslationTextComponent("gui.synthesisbag.notenoughmunny", new Object[0]).func_150254_d());
            }
            this.renderTooltip(list, x, y);
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String s = I18n.func_135052_a((String)("Synthesis Bag LV." + (this.bagLevel + 1)), (Object[])new Object[0]);
        this.font.func_211126_b(s, (float)(this.field_146999_f / 2 - 8 - this.font.func_78256_a(s) / 2), 5.0f, 0x404040);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        Minecraft mc = Minecraft.func_71410_x();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        mc.func_110434_K().func_110577_a(new ResourceLocation(textureBase + this.bagLevel + ".png"));
        int xPos = (this.width - this.field_146999_f) / 2;
        int yPos = this.height / 2 - this.field_147000_g / 2;
        this.blit(xPos, yPos, 0, 0, this.field_146999_f, this.field_147000_g);
    }
}

