/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButtonBase;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuBackground
extends Screen {
    int selected;
    String tip = null;
    Color color;
    public boolean drawPlayerInfo;
    MenuBar bottomLeftBar;
    MenuBar bottomRightBar;
    MenuBar topLeftBar;
    MenuBar topRightBar;
    protected float topBarHeight = (float)this.height * 0.17f;
    protected float bottomBarHeight;
    protected float topLeftBarWidth;
    protected float topRightBarWidth;
    protected float topGap;
    protected float bottomLeftBarWidth;
    protected float bottomRightBarWidth;
    protected float bottomGap;
    protected float middleHeight;
    public boolean drawSeparately = false;
    protected float buttonPosX;
    protected int buttonPosY;
    protected float buttonWidth;
    public static final ResourceLocation optionsBackground = new ResourceLocation("kingdomkeys", "textures/gui/menubg.png");
    public static final ResourceLocation menu = new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png");

    public MenuBackground(String name, Color rgb) {
        super((ITextComponent)new TranslationTextComponent(name, new Object[0]));
        this.minecraft = Minecraft.func_71410_x();
        this.selected = -1;
        this.color = rgb;
    }

    public void drawMenuBackground(int mouseX, int mouseY, float partialTicks) {
        this.drawBars();
        this.drawMunnyTime();
        this.drawBiomeDim();
        this.drawTip();
        RenderSystem.pushMatrix();
        RenderSystem.scaled((double)1.3, (double)1.3, (double)1.0);
        this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal(this.getTitle().func_150254_d()), 2, 10, 0xFF9900);
        RenderSystem.popMatrix();
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (!this.drawSeparately) {
            this.drawMenuBackground(mouseX, mouseY, partialTicks);
        }
        super.render(mouseX, mouseY, partialTicks);
    }

    private void clearButtons() {
        for (Widget btn : this.buttons) {
            if (!(btn instanceof MenuButtonBase)) continue;
            ((MenuButtonBase)btn).setSelected(false);
        }
    }

    public void drawBars() {
        this.renderBackground();
        int sh = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        int sw = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        for (int i = 0; i < sh; i += 3) {
            RenderSystem.pushMatrix();
            RenderSystem.color3f((float)((float)this.color.getRed() / 255.0f), (float)((float)this.color.getGreen() / 255.0f), (float)((float)this.color.getBlue() / 255.0f));
            RenderSystem.enableBlend();
            this.minecraft.field_71446_o.func_110577_a(menu);
            RenderSystem.translatef((float)0.0f, (float)i, (float)0.0f);
            RenderSystem.scalef((float)sw, (float)1.0f, (float)1.0f);
            this.blit(0, 0, 77, 92, 1, 1);
            RenderSystem.popMatrix();
        }
        this.topLeftBar.draw();
        this.topRightBar.draw();
        this.bottomLeftBar.draw();
        this.bottomRightBar.draw();
    }

    public void drawBiomeDim() {
        RenderSystem.pushMatrix();
        String text = this.minecraft.field_71439_g.field_71093_bK.getRegistryName().func_110623_a().toUpperCase().replaceAll("_", " ") + " | " + this.minecraft.field_71439_g.field_70170_p.func_226691_t_(this.minecraft.field_71439_g.func_180425_c()).func_205403_k().func_150254_d();
        this.drawString(this.minecraft.field_71466_p, text, this.width - this.minecraft.field_71466_p.func_78256_a(text) - 5, 5, 16091955);
        RenderSystem.popMatrix();
    }

    public void drawMunnyTime() {
        RenderSystem.pushMatrix();
        RenderSystem.scaled((double)1.1, (double)1.1, (double)1.0);
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g);
        this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal("gui.menu.main.munny") + ": " + playerData.getMunny(), 5, (int)(this.topBarHeight + this.middleHeight) - 7, 16148007);
        FontRenderer fontRenderer = this.minecraft.field_71466_p;
        String string = Utils.translateToLocal("gui.menu.main.hearts") + ": " + playerData.getHearts();
        int n = (int)(this.topBarHeight + this.middleHeight);
        this.minecraft.field_71466_p.getClass();
        this.drawString(fontRenderer, string, 5, n + 9 - 7, playerData.getAlignment() == Utils.OrgMember.NONE ? 0x888888 : 0xFF3333);
        FontRenderer fontRenderer2 = this.minecraft.field_71466_p;
        String string2 = Utils.translateToLocal("gui.menu.main.time") + ": " + MenuBackground.getWorldHours((World)this.minecraft.field_71441_e) + ":" + MenuBackground.getWorldMinutes((World)this.minecraft.field_71441_e);
        int n2 = (int)(this.topBarHeight + this.middleHeight);
        this.minecraft.field_71466_p.getClass();
        this.drawString(fontRenderer2, string2, 5, n2 + 9 * 2 - 7, 0xFFFFFF);
        long seconds = this.minecraft.field_71441_e.func_201672_e().func_72820_D() / 20L;
        long h = seconds / 3600L;
        long m = seconds % 3600L / 60L;
        long s = seconds % 3600L % 60L;
        String sec = s < 10L ? "0" + s : s + "";
        String min = m < 10L ? "0" + m : m + "";
        String hou = h < 10L ? "0" + h : h + "";
        String time = hou + ":" + min + ":" + sec;
        FontRenderer fontRenderer3 = this.minecraft.field_71466_p;
        String string3 = Utils.translateToLocal("gui.menu.main.time.spent") + ": " + time;
        int n3 = (int)(this.topBarHeight + this.middleHeight);
        this.minecraft.field_71466_p.getClass();
        this.drawString(fontRenderer3, string3, 5, n3 + 9 * 3 - 7, 4378367);
        RenderSystem.popMatrix();
    }

    public void drawTip() {
        this.tip = null;
        int i = 0;
        for (Widget btn : this.buttons) {
            if (!(btn instanceof MenuButtonBase)) continue;
            ++i;
            if (!btn.isHovered()) continue;
            this.selected = -1;
            this.clearButtons();
            if (!(btn instanceof MenuButton) || !btn.visible) continue;
            this.tip = ((MenuButton)btn).getTip();
        }
        if (this.tip != null) {
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)1.1, (double)1.1, (double)1.0);
            RenderSystem.translated((double)0.0, (double)-5.0, (double)0.0);
            this.minecraft.field_71466_p.func_78279_b(Utils.translateToLocal(this.tip), (int)(this.bottomLeftBarWidth + this.bottomGap), (int)(this.topBarHeight + this.middleHeight), (int)((float)this.width * 0.5f), 0xFF9900);
            RenderSystem.popMatrix();
        }
    }

    public static String getWorldMinutes(World world) {
        int time = (int)Math.abs((world.func_82737_E() + 6000L) % 24000L);
        if (time % 1000 * 6 / 100 < 10) {
            return "0" + time % 1000 * 6 / 100;
        }
        return Integer.toString(time % 1000 * 6 / 100);
    }

    public static int getWorldHours(World world) {
        int time = (int)Math.abs((world.func_82737_E() + 6000L) % 24000L);
        return (int)((float)time / 1000.0f);
    }

    public void init() {
        this.topBarHeight = (float)this.height * 0.17f;
        this.bottomBarHeight = (float)this.height * 0.23f;
        this.topLeftBarWidth = (float)this.width * 0.175f;
        this.topRightBarWidth = (float)this.width * 0.82f;
        this.topGap = (float)this.width * 0.005f;
        this.bottomLeftBarWidth = (float)this.width * 0.304f;
        this.bottomRightBarWidth = (float)this.width * 0.6875f;
        this.bottomGap = (float)this.width * 0.0085f;
        this.middleHeight = (float)this.height * 0.6f;
        this.topLeftBar = new MenuBar(-10, -10, (int)this.topLeftBarWidth + 10, (int)this.topBarHeight + 10, true);
        this.topRightBar = new MenuBar((int)(this.topLeftBarWidth + this.topGap), -10, (int)this.topRightBarWidth + 10, (int)this.topBarHeight + 10, true);
        this.bottomLeftBar = new MenuBar(-10, (int)(this.topBarHeight + this.middleHeight), (int)this.bottomLeftBarWidth + 10, (int)this.bottomBarHeight + 10, false);
        this.bottomRightBar = new MenuBar((int)(this.bottomLeftBarWidth + this.bottomGap), (int)(this.topBarHeight + this.middleHeight), (int)this.bottomRightBarWidth + 10, (int)this.bottomBarHeight + 10, false);
        this.buttonPosX = (float)this.width * 0.03f;
        this.buttonPosY = (int)this.topBarHeight + 5;
        this.buttonWidth = (float)this.width * 0.1744f - 22.0f;
    }

    protected void drawBackground(int screenWidth, int screenHeight, boolean drawPlayer) {
    }
}

