/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.elements;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.util.Utils;

public abstract class MenuPopup
extends Screen {
    MenuButton ok;
    MenuButton cancel;
    int[] alpha;
    int[] timer;
    int scaledWidth;
    int scaledHeight;
    int titleDisplayTime = 35;
    int titleFadeIn = 10;
    int currentTimer = 0;

    public boolean isPauseScreen() {
        return false;
    }

    public abstract void OK();

    public abstract void CANCEL();

    public abstract List<String> getTextToDisplay();

    @Nonnull
    public String OKString() {
        return "soa.menu.ok";
    }

    @Nonnull
    public String CANCELString() {
        return "soa.menu.cancel";
    }

    private void buttonAction(Action a) {
        switch (a) {
            case OK: {
                this.OK();
                break;
            }
            case CANCEL: {
                this.CANCEL();
            }
        }
    }

    public MenuPopup() {
        super((ITextComponent)new TranslationTextComponent("", new Object[0]));
    }

    protected void init() {
        super.init();
        this.scaledWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        this.scaledHeight = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        int buttonWidth = 50;
        int buttonX = this.scaledWidth / 2 - buttonWidth * 2;
        int n = this.scaledHeight / 2 + -10;
        int n2 = this.getTextToDisplay().size();
        this.font.getClass();
        int buttonY = n + n2 * (9 * 2 + 3);
        this.ok = new MenuButton(buttonX, buttonY, buttonWidth, Utils.translateToLocal(this.OKString()), MenuButton.ButtonType.BUTTON, p -> this.buttonAction(Action.OK));
        this.addButton((Widget)this.ok);
        this.cancel = new MenuButton(buttonX + buttonWidth * 2, buttonY, buttonWidth, Utils.translateToLocal(this.CANCELString()), MenuButton.ButtonType.BUTTON, p -> this.buttonAction(Action.CANCEL));
        this.addButton((Widget)this.cancel);
        this.ok.visible = false;
        this.ok.active = false;
        this.cancel.visible = false;
        this.cancel.active = false;
        this.alpha = new int[this.getTextToDisplay().size()];
        this.timer = new int[this.getTextToDisplay().size()];
        this.timer[0] = this.titleDisplayTime + this.titleFadeIn;
        Arrays.fill(this.alpha, 0);
    }

    protected void renderTextBackground(FontRenderer fontRendererIn, int yIn, int stringWidthIn) {
        int i = Minecraft.func_71410_x().field_71474_y.func_216841_b(0.0f);
        if (i != 0) {
            int j = -stringWidthIn / 2;
            MenuPopup.fill((int)(j - 2), (int)(yIn - 2), (int)(j + stringWidthIn + 2), (int)(yIn + 9 + 2), (int)i);
        }
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        float startY = -10.0f;
        RenderSystem.pushMatrix();
        float f = this.scaledWidth / 2;
        float f2 = this.scaledHeight / 2;
        int n = this.getTextToDisplay().size() - 1;
        this.font.getClass();
        RenderSystem.translatef((float)f, (float)(f2 - (startY + (float)(n * (9 + 3))) / 2.0f), (float)0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)2.0f, (float)2.0f, (float)2.0f);
        for (int i = 0; i < this.getTextToDisplay().size(); ++i) {
            float f4 = (float)this.timer[i] - partialTicks;
            if (this.timer[i] > this.titleDisplayTime) {
                float f5 = (float)(this.titleFadeIn + this.titleDisplayTime) - f4;
                this.alpha[i] = (int)(f5 * 255.0f / (float)this.titleFadeIn);
            }
            if (this.timer[i] == -1) {
                this.alpha[i] = 255;
            }
            this.alpha[i] = MathHelper.func_76125_a((int)this.alpha[i], (int)0, (int)255);
            if (this.alpha[i] <= 8) continue;
            int l1 = this.alpha[i] << 24 & 0xFF000000;
            int i2 = this.font.func_78256_a(Utils.translateToLocal(this.getTextToDisplay().get(i)));
            this.font.getClass();
            this.renderTextBackground(this.font, (int)(startY + (float)(i * (9 + 3))), i2);
            String string = Utils.translateToLocal(this.getTextToDisplay().get(i));
            float f3 = -i2 / 2;
            this.font.getClass();
            this.font.func_175063_a(string, f3, startY + (float)(i * (9 + 3)), 0xFFFFFF | l1);
        }
        RenderSystem.popMatrix();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
    }

    public boolean keyPressed(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (32 == p_keyPressed_1_) {
            this.timer[this.currentTimer] = -1;
            if (this.currentTimer + 1 == this.timer.length) {
                this.ok.visible = true;
                this.ok.active = true;
                this.cancel.visible = true;
                this.cancel.active = true;
            } else {
                this.timer[this.currentTimer + 1] = this.titleDisplayTime + this.titleFadeIn;
                ++this.currentTimer;
            }
        }
        return super.keyPressed(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public void tick() {
        for (int i = 0; i < this.timer.length; ++i) {
            if (this.timer[i] <= 0) continue;
            int n = i;
            this.timer[n] = this.timer[n] - 1;
            if (this.timer[i] > 0) continue;
            if (i != this.timer.length - 1) {
                this.timer[i] = -1;
                this.timer[i + 1] = this.titleDisplayTime + this.titleFadeIn;
                this.currentTimer = i + 1;
                continue;
            }
            this.ok.visible = true;
            this.ok.active = true;
            this.cancel.visible = true;
            this.cancel.active = true;
        }
        super.tick();
    }

    static enum Action {
        OK,
        CANCEL;

    }
}

