/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.hud;

import java.awt.Color;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import online.kingdomkeys.kingdomkeys.client.gui.hud.HUDAnchorPosition;
import online.kingdomkeys.kingdomkeys.client.gui.hud.HUDElement;

public class CommandMenuHUDElement
extends HUDElement {
    int currentPage = 0;
    int currentItem = 0;
    Map<Integer, Menu> menuItems = new HashMap<Integer, Menu>();
    final ResourceLocation TEXTURE = new ResourceLocation("kingdomkeys", "textures/gui/commandmenu.png");
    final Color menuColour = new Color(10, 60, 255);
    final Color magicColour = new Color(100, 0, 255);
    final int MENU_HEIGHT = 15;
    final int MENU_WIDTH = 70;
    final int ICON_WIDTH = 10;

    public CommandMenuHUDElement(int anchoredPositionX, int anchoredPositionY, int elementWidth, int elementHeight, HUDAnchorPosition anchor, String name) {
        super(anchoredPositionX, anchoredPositionY, elementWidth, elementHeight, anchor, name);
    }

    public void moveUp() {
        this.currentItem = this.currentItem - 1 == 0 ? this.menuItems.get((Object)Integer.valueOf((int)this.currentPage)).menuItems.size() - 1 : --this.currentItem;
    }

    public void moveDown() {
        this.currentItem = this.currentItem + 1 == this.menuItems.get((Object)Integer.valueOf((int)this.currentPage)).menuItems.size() ? 0 : ++this.currentItem;
    }

    public void enter() {
        this.menuItems.get((Object)Integer.valueOf((int)this.currentPage)).menuItems.get(this.currentItem).onUse();
    }

    public void cancel() {
        this.currentPage = 0;
    }

    public void changePage(int subMenu) {
        this.currentPage = subMenu;
    }

    @Override
    public void initElement() {
        Menu main = new Menu(0, new MenuItem("Attack", this.menuColour){

            @Override
            public void onUse() {
            }
        }, new MenuItem("Magic", this.menuColour){

            @Override
            public void onUse() {
                CommandMenuHUDElement.this.changePage(1);
            }
        }, new MenuItem("Items", this.menuColour){

            @Override
            public void onUse() {
                CommandMenuHUDElement.this.changePage(2);
            }
        }, new MenuItem("Drive", this.menuColour){

            @Override
            public void onUse() {
                CommandMenuHUDElement.this.changePage(3);
            }
        });
        Menu magic = new Menu(1, new MenuItem("Fire", this.magicColour){

            @Override
            public void onUse() {
                CommandMenuHUDElement.this.changePage(0);
            }
        });
        Menu items = new Menu(2, new MenuItem[]{null});
        Menu drive = new Menu(3, new MenuItem[]{null});
        Menu main2 = new Menu(0, new MenuItem("Attack", this.menuColour){

            @Override
            public void onUse() {
            }
        }, new MenuItem("Summon", this.menuColour){

            @Override
            public void onUse() {
            }
        }, new MenuItem("Party", this.menuColour){

            @Override
            public void onUse() {
            }
        }, new MenuItem("Limit", this.menuColour){

            @Override
            public void onUse() {
            }
        });
        this.menuItems.put(0, main);
        this.menuItems.put(1, main2);
        this.setHeight(15 * this.menuItems.get((Object)Integer.valueOf((int)this.currentPage)).menuItems.size());
        this.setWidth(70);
    }

    @Override
    public void tick() {
        if (this.currentTickPos > 200.0f) {
            this.currentTickPos = 0.0f;
        }
        this.previousTickPos = this.currentTickPos;
        this.currentTickPos += 2.0f;
    }

    @Override
    public void drawElement(float partialTicks) {
        this.mcInstance.func_110434_K().func_110577_a(this.TEXTURE);
        this.blit(0, 0, 0, 0, 70, 15);
        this.drawString("COMMANDS", 0, 0, Color.WHITE);
        float lerpedPos = this.previousTickPos + (this.currentTickPos - this.previousTickPos) * partialTicks;
        this.drawString("TEST", Math.round(lerpedPos), 0, Color.RED);
    }

    public static abstract class MenuItem
    extends Screen {
        String name;
        Color colour;

        public MenuItem(String name, Color colour) {
            super((ITextComponent)new TranslationTextComponent("", new Object[0]));
            this.name = name;
            this.colour = colour;
        }

        public void setColour(Color colour) {
            this.colour = colour;
        }

        public abstract void onUse();

        public void draw(float partialTicks) {
        }
    }

    public static class Menu {
        int subMenuIndex;
        List<MenuItem> menuItems;

        public Menu(int subMenuIndex, MenuItem ... items) {
            this.subMenuIndex = subMenuIndex;
            this.menuItems = Arrays.asList(items);
        }

        public void addItem(MenuItem item) {
            this.menuItems.add(item);
        }
    }
}

