/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.hud;

import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import online.kingdomkeys.kingdomkeys.client.gui.hud.HUDAnchorPosition;

public abstract class HUDElement
extends Widget {
    protected Minecraft mcInstance;
    protected HUDAnchorPosition anchor;
    protected int anchoredPositionX;
    protected int anchoredPositionY;
    protected float currentTickPos;
    protected float previousTickPos;

    public HUDElement(int anchoredPositionX, int anchoredPositionY, int elementWidth, int elementHeight, HUDAnchorPosition anchor, String name) {
        super(0, 0, elementWidth, elementHeight, name);
        this.anchoredPositionX = anchoredPositionX;
        this.anchoredPositionY = anchoredPositionY;
        this.width = elementWidth;
        this.height = elementHeight;
        this.anchor = anchor;
        this.mcInstance = Minecraft.func_71410_x();
    }

    public abstract void drawElement(float var1);

    public abstract void initElement();

    public void setAnchoredPosition(int anchoredPositionX, int anchoredPositionY) {
        this.anchoredPositionX = anchoredPositionX;
        this.anchoredPositionY = anchoredPositionY;
        this.anchorElement();
    }

    public void setAnchoredPositionX(int anchoredPositionX) {
        this.anchoredPositionX = anchoredPositionX;
        this.anchorElement();
    }

    public void setAnchoredPositionY(int anchoredPositionY) {
        this.anchoredPositionY = anchoredPositionY;
        this.anchorElement();
    }

    private void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    private void setPositionX(int x) {
        this.setPosition(x, this.y);
    }

    private void setPositionY(int y) {
        this.setPosition(this.x, y);
    }

    protected void setDimensions(int width, int height) {
        this.setWidth(width);
        this.setHeight(height);
        this.anchorElement();
    }

    public void drawString(String string, int posX, int posY, Color colour) {
        this.drawString(this.mcInstance.field_71466_p, string, this.x + posX, this.y + posY, colour.getRGB());
    }

    public void blit(int posX, int posY, int texU, int texV, int texWidth, int texHeight) {
        super.blit(this.x + posX, this.y + posY, texU, texV, texWidth, texHeight);
    }

    public void bindAndBlit(ResourceLocation texture, int posX, int posY, int texU, int texV, int texWidth, int texHeight) {
        this.mcInstance.func_110434_K().func_110577_a(texture);
        this.blit(posX, posY, texU, texV, texWidth, texHeight);
    }

    public final void anchorElement() {
        this.setPosition(0, 0);
        switch (this.anchor) {
            case TOP_LEFT: {
                this.setPosition(this.x + this.anchoredPositionX, this.y + this.anchoredPositionY);
                break;
            }
            case TOP_CENTER: {
                this.setPosition(this.x + this.mcInstance.func_228018_at_().func_198107_o() / 2 - this.getWidth() / 2 + this.anchoredPositionX, this.y + this.anchoredPositionY);
                break;
            }
            case TOP_RIGHT: {
                this.setPosition(this.mcInstance.func_228018_at_().func_198107_o() - this.getWidth() + this.anchoredPositionX, this.y + this.anchoredPositionY);
                break;
            }
            case BOTTOM_LEFT: {
                this.setPosition(this.x + this.anchoredPositionX, this.mcInstance.func_228018_at_().func_198087_p() - this.getHeight() + this.anchoredPositionY);
                break;
            }
            case BOTTOM_CENTER: {
                this.setPosition(this.x + this.mcInstance.func_228018_at_().func_198107_o() / 2 - this.getWidth() / 2 + this.anchoredPositionX, this.mcInstance.func_228018_at_().func_198087_p() - this.getHeight() + this.anchoredPositionY);
                break;
            }
            case BOTTOM_RIGHT: {
                this.setPosition(this.mcInstance.func_228018_at_().func_198107_o() - this.getWidth() + this.anchoredPositionX, this.mcInstance.func_228018_at_().func_198087_p() - this.getHeight() + this.anchoredPositionY);
                break;
            }
            case CENTER_LEFT: {
                this.setPosition(this.x + this.anchoredPositionX, this.y + this.mcInstance.func_228018_at_().func_198087_p() / 2 - this.getHeight() / 2 + this.anchoredPositionY);
                break;
            }
            case CENTER: {
                this.setPosition(this.x + this.mcInstance.func_228018_at_().func_198107_o() / 2 - this.getWidth() / 2 + this.anchoredPositionX, this.y + this.mcInstance.func_228018_at_().func_198087_p() / 2 - this.getHeight() / 2 + this.anchoredPositionY);
                break;
            }
            case CENTER_RIGHT: {
                this.setPosition(this.mcInstance.func_228018_at_().func_198107_o() - this.getWidth() + this.anchoredPositionX, this.y + this.mcInstance.func_228018_at_().func_198087_p() / 2 - this.getHeight() / 2 + this.anchoredPositionY);
            }
        }
    }

    public void render(float partialTicks) {
        this.drawElement(partialTicks);
    }

    public abstract void tick();
}

