/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.abilities;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TranslationTextComponent;
import online.kingdomkeys.kingdomkeys.ability.Ability;
import online.kingdomkeys.kingdomkeys.ability.ModAbilities;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.GuiHelper;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuAbilitiesButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSetEquippedAbilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class MenuAbilitiesScreen
extends MenuBackground {
    IPlayerCapabilities playerData;
    LinkedHashMap<String, int[]> abilitiesMap;
    List<MenuAbilitiesButton> abilities;
    MenuBox box;
    Button prev;
    Button next;
    MenuButton back;
    int page;
    int itemsPerPage;
    Ability hoveredAbility;

    public MenuAbilitiesScreen() {
        super("gui.menu.main.button.abilities", new Color(0, 0, 255));
        this.playerData = ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g);
        this.abilities = new ArrayList<MenuAbilitiesButton>();
        this.page = 0;
    }

    protected void action(String string) {
        switch (string) {
            case "prev": {
                --this.page;
                this.minecraft.field_71441_e.func_184133_a((PlayerEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_180425_c(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                break;
            }
            case "next": {
                ++this.page;
                this.minecraft.field_71441_e.func_184133_a((PlayerEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_180425_c(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void init() {
        this.abilitiesMap = Utils.getSortedAbilities(this.playerData.getAbilityMap());
        this.width = this.width;
        this.height = this.height;
        super.init();
        this.buttons.clear();
        this.children.clear();
        this.abilities.clear();
        float boxPosX = (float)this.width * 0.2f;
        float topBarHeight = (float)this.height * 0.17f;
        float boxWidth = (float)this.width * 0.45f;
        float middleHeight = (float)this.height * 0.6f;
        this.box = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, new Color(4, 4, 68));
        int buttonPosX = (int)boxPosX + 10;
        int buttonPosY = (int)topBarHeight + 5;
        int buttonWidth = 100;
        int i = 0;
        for (i = 0; i < this.abilitiesMap.size(); ++i) {
            String abilityName = (String)this.abilitiesMap.keySet().toArray()[i];
            Ability ability = (Ability)ModAbilities.registry.getValue(new ResourceLocation(abilityName));
            String path = new ResourceLocation(abilityName).func_110623_a();
            this.abilities.add(new MenuAbilitiesButton(buttonPosX, buttonPosY, buttonWidth, Utils.translateToLocal(path), ability.getType(), e -> this.action(ability)));
            this.abilities.get((int)i).visible = false;
        }
        this.abilities.forEach(arg_0 -> ((MenuAbilitiesScreen)this).addButton(arg_0));
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth, new TranslationTextComponent("gui.menu.back", new Object[0]).func_150254_d(), MenuButton.ButtonType.BUTTON, b -> GuiHelper.openMenu());
        this.addButton((Widget)this.back);
        this.prev = new Button(buttonPosX + 10, (int)((float)this.height * 0.1f), 30, 20, Utils.translateToLocal("<--"), e -> this.action("prev"));
        this.addButton((Widget)this.prev);
        this.next = new Button(buttonPosX + 10 + 76, (int)((float)this.height * 0.1f), 30, 20, Utils.translateToLocal("-->"), e -> this.action("next"));
        this.addButton((Widget)this.next);
        this.prev.visible = false;
        this.next.visible = false;
        this.itemsPerPage = (int)(middleHeight / 19.0f);
    }

    private void action(Ability ability) {
        String abilityName = ability.getRegistryName().toString();
        int apCost = ((Ability)ModAbilities.registry.getValue(new ResourceLocation(abilityName))).getAPCost();
        int lvlIncrease = 0;
        if (this.playerData.isAbilityEquipped(abilityName)) {
            lvlIncrease = -1;
        } else {
            if (Utils.getConsumedAP(this.playerData) + apCost > this.playerData.getMaxAP()) {
                System.out.println("Not enough AP");
                return;
            }
            lvlIncrease = 1;
        }
        if (lvlIncrease != 0) {
            this.playerData.addEquippedAbilityLevel(abilityName, lvlIncrease);
            PacketHandler.sendToServer(new CSSetEquippedAbilityPacket(abilityName, lvlIncrease));
            this.init();
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        int i;
        this.box.draw();
        super.render(mouseX, mouseY, partialTicks);
        this.drawAP();
        this.prev.visible = this.page > 0;
        this.next.visible = this.page < this.abilities.size() / this.itemsPerPage;
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(this.prev.x + this.prev.getWidth() + 5), (double)((double)this.height * 0.15 - 18.0), (double)1.0);
        this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal("Page: " + (this.page + 1)), 0, 10, 0xFF9900);
        RenderSystem.popMatrix();
        for (i = 0; i < this.abilities.size(); ++i) {
            this.abilities.get((int)i).visible = false;
        }
        for (i = this.page * this.itemsPerPage; i < this.page * this.itemsPerPage + this.itemsPerPage; ++i) {
            if (i >= this.abilities.size() || this.abilities.get(i) == null) continue;
            this.abilities.get((int)i).visible = true;
            this.abilities.get((int)i).y = (int)this.topBarHeight + i % this.itemsPerPage * 19 + 2;
            this.abilities.get(i).render(mouseX, mouseY, partialTicks);
        }
        this.prev.render(mouseX, mouseY, partialTicks);
        this.next.render(mouseX, mouseY, partialTicks);
        this.back.render(mouseX, mouseY, partialTicks);
        if (this.hoveredAbility != null) {
            this.renderSelectedData(mouseX, mouseY, partialTicks);
        }
    }

    protected void renderSelectedData(int mouseX, int mouseY, float partialTicks) {
        float tooltipPosX = (float)this.width * 0.22f;
        float tooltipPosY = (float)this.height * 0.77f;
        this.minecraft.field_71466_p.func_78279_b(new TranslationTextComponent(this.hoveredAbility.getTranslationKey().replace(".name", ".desc"), new Object[0]).func_150254_d(), (int)tooltipPosX + 60, (int)tooltipPosY + 15, (int)((float)this.width * 0.6f), 65535);
    }

    private void drawAP() {
        int j;
        int percent;
        int requiredAP;
        int j2;
        int consumedAP = Utils.getConsumedAP(this.playerData);
        int maxAP = this.playerData.getMaxAP();
        this.hoveredAbility = null;
        for (int i = 0; i < this.abilitiesMap.size(); ++i) {
            String abilityName = (String)this.abilitiesMap.keySet().toArray()[i];
            Ability ability = (Ability)ModAbilities.registry.getValue(new ResourceLocation(abilityName));
            this.abilities.get((int)i).equipped = this.playerData.isAbilityEquipped(abilityName);
            String lvl = "";
            if (ability.getType() == Ability.AbilityType.GROWTH) {
                int level = this.playerData.getEquippedAbilityLevel(abilityName)[0];
                lvl = lvl + "_" + level;
            }
            abilityName = ability.getTranslationKey();
            String text = Utils.translateToLocal(new StringBuilder(abilityName).insert(abilityName.lastIndexOf(46), lvl).toString());
            if (!(this.buttons.get(i) instanceof MenuAbilitiesButton)) continue;
            MenuAbilitiesButton button = (MenuAbilitiesButton)((Object)this.buttons.get(i));
            if (ability.getAPCost() > this.playerData.getMaxAP() - consumedAP) {
                button.active = false;
            }
            if (this.playerData.isAbilityEquipped(ability.getRegistryName().toString())) {
                button.active = true;
            }
            button.setMessage(text);
            button.setAP(ability.getAPCost());
            if (!button.isHovered()) continue;
            this.hoveredAbility = ability;
        }
        int screenWidth = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        int screenHeight = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        int barWidth = 100;
        int posX = screenWidth - barWidth;
        int posY = screenHeight - 100;
        float scale = 1.0f;
        this.minecraft.field_71446_o.func_110577_a(new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png"));
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)((float)(posX - 2) * scale - 20.0f), (float)((float)posY * scale - 10.0f), (float)0.0f);
        RenderSystem.pushMatrix();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(0, 0, 143, 67, 7, 25);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        for (j2 = 0; j2 < barWidth; ++j2) {
            this.blit(7 + j2, 0, 151, 67, 1, 25);
        }
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        this.blit(7 + barWidth, 0, 153, 67, 7, 25);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        for (j2 = 0; j2 < barWidth; ++j2) {
            this.blit(j2 + 7, 17, 161, 67, 1, 25);
        }
        RenderSystem.popMatrix();
        int n = requiredAP = this.hoveredAbility != null ? this.hoveredAbility.getAPCost() : 0;
        if (this.hoveredAbility != null && this.playerData.isAbilityEquipped(this.hoveredAbility.getRegistryName().toString())) {
            requiredAP *= -1;
            RenderSystem.pushMatrix();
            percent = consumedAP * barWidth / maxAP;
            RenderSystem.pushMatrix();
            for (j = 0; j < percent; ++j) {
                this.blit(j + 7, 17, 165, 67, 1, 5);
            }
            RenderSystem.popMatrix();
            RenderSystem.popMatrix();
        } else if (consumedAP + requiredAP <= this.playerData.getMaxAP()) {
            RenderSystem.pushMatrix();
            percent = (consumedAP + requiredAP) * barWidth / maxAP;
            RenderSystem.pushMatrix();
            for (j = 0; j < percent; ++j) {
                this.blit(j + 7, 17, 167, 67, 1, 5);
            }
            RenderSystem.popMatrix();
            RenderSystem.popMatrix();
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pushMatrix();
        percent = consumedAP * barWidth / maxAP;
        if (requiredAP < 0) {
            percent = (consumedAP + requiredAP) * barWidth / maxAP;
        }
        for (j = 0; j < percent; ++j) {
            this.blit(j + 7, 17, 163, 67, 1, 5);
        }
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)(scale * 1.3f), (float)(scale * 1.1f), (float)0.0f);
        this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal("gui.menu.status.ap") + ": " + consumedAP + "/" + maxAP, 16, 5, 0xFFFFFF);
        RenderSystem.popMatrix();
        RenderSystem.popMatrix();
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        if (mouseButton == 1) {
            GuiHelper.openMenu();
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }
}

