/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.menu.party;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.GuiHelper;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBackground;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Invite;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Kick;
import online.kingdomkeys.kingdomkeys.client.gui.menu.party.GuiMenu_Party_Settings;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSPartyDisband;
import online.kingdomkeys.kingdomkeys.network.cts.CSPartyLeave;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class GuiMenu_Party_Leader
extends MenuBackground {
    MenuButton back;
    MenuButton invite;
    MenuButton settings;
    MenuButton kick;
    MenuButton disband;
    final IPlayerCapabilities playerData;
    IWorldCapabilities worldData;
    Party party;

    public GuiMenu_Party_Leader() {
        super("gui.menu.party", new Color(0, 0, 255));
        this.playerData = ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g);
        this.drawPlayerInfo = true;
        this.worldData = ModCapabilities.getWorld((World)this.minecraft.field_71441_e);
    }

    protected void action(String string) {
        switch (string) {
            case "back": {
                GuiHelper.openMenu();
                break;
            }
            case "disband": {
                PacketHandler.sendToServer(new CSPartyDisband(this.party));
                GuiHelper.openMenu();
                break;
            }
            case "leave": {
                PacketHandler.sendToServer(new CSPartyLeave(this.party, this.minecraft.field_71439_g.func_110124_au()));
                this.party = null;
                break;
            }
            case "settings": {
                this.minecraft.field_71441_e.func_184133_a((PlayerEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_180425_c(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                this.minecraft.func_147108_a((Screen)new GuiMenu_Party_Settings());
                break;
            }
            case "kick": {
                this.minecraft.field_71441_e.func_184133_a((PlayerEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_180425_c(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                this.minecraft.func_147108_a((Screen)new GuiMenu_Party_Kick());
                break;
            }
            case "invite": {
                this.minecraft.field_71441_e.func_184133_a((PlayerEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_180425_c(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                this.minecraft.func_147108_a((Screen)new GuiMenu_Party_Invite());
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
        this.invite.visible = true;
        this.kick.visible = true;
        this.disband.visible = true;
    }

    @Override
    public void init() {
        this.width = this.width;
        this.height = this.height;
        super.init();
        this.buttons.clear();
        this.party = this.worldData.getPartyFromMember(this.minecraft.field_71439_g.func_110124_au());
        float topBarHeight = (float)this.height * 0.17f;
        int button_statsY = (int)topBarHeight + 5;
        float buttonPosX = (float)this.width * 0.03f;
        float buttonWidth = (float)this.width * 0.1744f - 20.0f;
        this.invite = new MenuButton((int)buttonPosX, button_statsY + 0, (int)buttonWidth, Utils.translateToLocal("gui.menu.party.invite"), MenuButton.ButtonType.BUTTON, e -> this.action("invite"));
        this.addButton((Widget)this.invite);
        this.settings = new MenuButton((int)buttonPosX, button_statsY + 18, (int)buttonWidth, Utils.translateToLocal("gui.menu.party.settings"), MenuButton.ButtonType.BUTTON, e -> this.action("settings"));
        this.addButton((Widget)this.settings);
        this.kick = new MenuButton((int)buttonPosX, button_statsY + 36, (int)buttonWidth, Utils.translateToLocal("gui.menu.party.kick"), MenuButton.ButtonType.BUTTON, e -> this.action("kick"));
        this.addButton((Widget)this.kick);
        this.disband = new MenuButton((int)buttonPosX, button_statsY + 54, (int)buttonWidth, Utils.translateToLocal("gui.menu.party.disband"), MenuButton.ButtonType.BUTTON, e -> this.action("disband"));
        this.addButton((Widget)this.disband);
        this.back = new MenuButton((int)buttonPosX, button_statsY + 72, (int)buttonWidth, Utils.translateToLocal("gui.menu.back"), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.addButton((Widget)this.back);
        this.updateButtons();
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        this.worldData = ModCapabilities.getWorld((World)this.minecraft.field_71441_e);
        this.party = this.worldData.getPartyFromMember(this.minecraft.field_71439_g.func_110124_au());
        if (this.party != null) {
            this.invite.active = this.party.getMembers().size() < this.party.getSize();
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)1.5, (double)1.5, (double)1.0);
            this.drawString(this.minecraft.field_71466_p, "[" + this.party.getMembers().size() + "/" + this.party.getSize() + "] " + this.party.getName(), (int)(this.topLeftBarWidth + this.topGap) + 5, 10, 0xFF9900);
            RenderSystem.popMatrix();
            this.drawParty();
        }
    }

    public void drawParty() {
        this.party = this.worldData.getPartyFromMember(this.minecraft.field_71439_g.func_110124_au());
        if (this.party != null) {
            for (int i = 0; i < this.party.getMembers().size(); ++i) {
                Party.Member member = this.party.getMembers().get(i);
                this.drawPlayer(i, member);
            }
        } else {
            Party.Member m = new Party.Member(this.minecraft.field_71439_g.func_110124_au(), this.minecraft.field_71439_g.func_145748_c_().func_150254_d());
            this.drawPlayer(0, m);
        }
    }

    public void drawPlayer(int order, Party.Member member) {
        IPlayerCapabilities playerData;
        int i;
        float playerHeight = (float)this.height * 0.45f;
        float playerPosX = 150.0f + 0.18f * (float)order * (float)this.width;
        float playerPosY = (float)this.height * 0.7f;
        PlayerEntity player = Utils.getPlayerByName((World)this.minecraft.field_71441_e, member.getUsername());
        RenderSystem.pushMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (member != null && player != null) {
            InventoryScreen.func_228187_a_((int)((int)playerPosX), (int)((int)playerPosY), (int)((int)playerHeight / 2), (float)0.0f, (float)0.0f, (LivingEntity)player);
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.translatef((float)9.0f, (float)1.0f, (float)100.0f);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        this.minecraft.func_175598_ae().field_78724_e.func_110577_a(new ResourceLocation("kingdomkeys", "textures/gui/menu/menu_button.png"));
        int infoBoxWidth = (int)((float)this.width * 0.1385f - 14.0f);
        int infoBoxPosX = (int)(105.0f + 0.18f * (float)order * (float)this.width);
        int infoBoxPosY = (int)((float)this.height * 0.54f);
        this.blit(infoBoxPosX, infoBoxPosY, 123, 67, 11, 22);
        for (i = 0; i < infoBoxWidth; ++i) {
            this.blit(infoBoxPosX + 11 + i, infoBoxPosY, 135, 67, 1, 22);
        }
        this.blit(infoBoxPosX + 11 + infoBoxWidth, infoBoxPosY, 137, 67, 3, 22);
        this.blit(infoBoxPosX, infoBoxPosY + 22, 123, 90, 3, 35);
        for (i = 0; i < infoBoxWidth + 8; ++i) {
            this.blit(infoBoxPosX + 3 + i, infoBoxPosY + 22, 127, 90, 1, 35);
        }
        this.blit(infoBoxPosX + 3 + infoBoxWidth + 8, infoBoxPosY + 22, 129, 90, 3, 35);
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)10.0f, (float)2.0f, (float)100.0f);
        RenderSystem.pushMatrix();
        float f = infoBoxPosX + 8;
        this.minecraft.field_71466_p.getClass();
        RenderSystem.translatef((float)f, (float)(infoBoxPosY + (11 - 9 / 2)), (float)1.0f);
        this.drawString(this.minecraft.field_71466_p, member.getUsername(), 0, 0, 0xFFFFFF);
        RenderSystem.popMatrix();
        if (player != null && (playerData = ModCapabilities.getPlayer(player)) != null) {
            this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal("gui.menu.status.level") + ": " + playerData.getLevel(), infoBoxPosX + 4, infoBoxPosY + 26, 16767232);
            FontRenderer fontRenderer = this.minecraft.field_71466_p;
            String string = Utils.translateToLocal("gui.menu.status.hp") + ": " + (int)player.func_110143_aJ() + "/" + (int)player.func_110138_aP();
            this.minecraft.field_71466_p.getClass();
            this.drawString(fontRenderer, string, infoBoxPosX + 4, infoBoxPosY + 26 + 9, 65280);
            FontRenderer fontRenderer2 = this.minecraft.field_71466_p;
            String string2 = Utils.translateToLocal("gui.menu.status.mp") + ": " + (int)playerData.getMP() + "/" + (int)playerData.getMaxMP();
            this.minecraft.field_71466_p.getClass();
            this.drawString(fontRenderer2, string2, infoBoxPosX + 4, infoBoxPosY + 26 + 9 * 2, 0x4444FF);
        }
        RenderSystem.popMatrix();
        RenderSystem.popMatrix();
    }
}

