/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.organization;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.organization.WeaponTreeSelectionScreen;
import online.kingdomkeys.kingdomkeys.item.ModItems;
import online.kingdomkeys.kingdomkeys.lib.Lists;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSummonKeyblade;
import online.kingdomkeys.kingdomkeys.network.cts.CSUnlockEquipOrgWeapon;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class WeaponUnlockScreen
extends Screen {
    IPlayerCapabilities playerData;
    Utils.OrgMember member;
    Button cancel;
    Button next;
    Button prev;
    Button select;
    final int CANCEL = 2;
    final int NEXT = 3;
    final int PREV = 4;
    final int SELECT = 5;
    List<Item> weapons;
    int current = 0;
    private final ResourceLocation GLOW = new ResourceLocation("kingdomkeys", "textures/gui/org/glow.png");
    int startCost = 1000;
    boolean unlock = true;

    public WeaponUnlockScreen(Utils.OrgMember member) {
        super((ITextComponent)new TranslationTextComponent("", new Object[0]));
        this.member = member;
        this.weapons = Lists.getListForMember(member);
        this.playerData = ModCapabilities.getPlayer((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
    }

    public void render(int p_render_1_, int p_render_2_, float p_render_3_) {
        int cost = (int)((double)this.startCost + 0.1 * (double)this.startCost * (double)this.current);
        this.renderBackground();
        String name = "";
        String weapon = "";
        int weapon_w = 128;
        int weapon_h = 128;
        this.renderBackground();
        RenderSystem.pushMatrix();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.GLOW);
        RenderSystem.enableBlend();
        this.blit(this.width / 2 - 128 - 5, this.height / 2 - 128, 0, 0, 256, 256);
        this.drawString(this.font, new ItemStack((IItemProvider)this.weapons.get(this.current)).func_200301_q().getString(), this.width / 2 - 128 - 5, this.height / 2 - 120, 0xFFFFFF);
        this.drawString(this.font, "Hearts Cost: " + cost, this.width / 2 - 128 - 5, this.height / 2 - 110, 0xFF0000);
        this.drawString(this.font, "Current Hearts: " + this.playerData.getHearts(), this.width / 2 - 128 - 5, this.height / 2 - 100, 0xFF0000);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)(this.width / 2 - 128 - 5 + 94), (float)(this.height / 2 - 128 + 88), (float)0.0f);
        RenderSystem.scalef((float)5.0f, (float)5.0f, (float)5.0f);
        RenderSystem.enableBlend();
        RenderSystem.color3f((float)0.0f, (float)0.0f, (float)0.0f);
        Minecraft.func_71410_x().func_175599_af().func_180450_b(new ItemStack((IItemProvider)this.weapons.get(this.current)), 0, 0);
        RenderSystem.popMatrix();
        super.render(p_render_1_, p_render_2_, p_render_3_);
    }

    protected void init() {
        super.init();
        this.cancel = new Button(0, 0, 50, 20, "Back", p -> this.actionPerformed(2));
        this.addButton((Widget)this.cancel);
        this.next = new Button(0, 0, 20, 20, ">", p -> this.actionPerformed(3));
        this.addButton((Widget)this.next);
        this.prev = new Button(0, 0, 20, 20, "<", p -> this.actionPerformed(4));
        this.addButton((Widget)this.prev);
        this.select = new Button(0, 0, 50, 20, "Unlock", p -> this.actionPerformed(5));
        this.addButton((Widget)this.select);
        this.updateButtons();
    }

    public boolean isPauseScreen() {
        return false;
    }

    void actionPerformed(int ID) {
        switch (ID) {
            case 2: {
                Minecraft.func_71410_x().func_147108_a((Screen)new WeaponTreeSelectionScreen(this.member));
                break;
            }
            case 3: {
                if (this.current == this.weapons.size() - 1) {
                    this.current = 0;
                    break;
                }
                ++this.current;
                break;
            }
            case 4: {
                if (this.current == 0) {
                    this.current = this.weapons.size() - 1;
                    break;
                }
                --this.current;
                break;
            }
            case 5: {
                ItemStack weapon = new ItemStack((IItemProvider)this.weapons.get(this.current));
                if (this.unlock) {
                    this.playerData.unlockWeapon(weapon);
                    int cost = (int)((double)this.startCost + 0.1 * (double)this.startCost * (double)this.current);
                    this.playerData.removeHearts(cost);
                    PacketHandler.sendToServer(new CSUnlockEquipOrgWeapon(weapon, cost));
                    break;
                }
                this.playerData.equipWeapon(weapon);
                if (Utils.findSummoned(this.minecraft.field_71439_g.field_71071_by, this.playerData.getEquippedWeapon(), true) > -1) {
                    PacketHandler.sendToServer(new CSSummonKeyblade(true));
                }
                PacketHandler.sendToServer(new CSUnlockEquipOrgWeapon(weapon));
            }
        }
        this.updateButtons();
    }

    public Item getStarterWeapon(Utils.OrgMember member) {
        switch (member) {
            case XEMNAS: {
                return (Item)ModItems.malice.get();
            }
            case XIGBAR: {
                return (Item)ModItems.standalone.get();
            }
            case XALDIN: {
                return (Item)ModItems.zephyr.get();
            }
            case VEXEN: {
                return (Item)ModItems.testerZero.get();
            }
            case LEXAEUS: {
                return (Item)ModItems.reticence.get();
            }
            case ZEXION: {
                return (Item)ModItems.blackPrimer.get();
            }
            case SAIX: {
                return (Item)ModItems.newMoon.get();
            }
            case AXEL: {
                return (Item)ModItems.ashes.get();
            }
            case DEMYX: {
                return (Item)ModItems.basicModel.get();
            }
            case LUXORD: {
                return (Item)ModItems.theFool.get();
            }
            case MARLUXIA: {
                return (Item)ModItems.fickleErica.get();
            }
            case LARXENE: {
                return (Item)ModItems.trancheuse.get();
            }
            case ROXAS: {
                return (Item)ModItems.kingdomKey.get();
            }
        }
        return null;
    }

    public boolean canUnlock() {
        int cost = (int)((double)this.startCost + 0.1 * (double)this.startCost * (double)this.current);
        if (this.playerData.getHearts() >= cost) {
            if (this.current == 0) {
                Utils.OrgMember rightMember = this.member == Utils.OrgMember.ROXAS ? Utils.OrgMember.XEMNAS : Utils.OrgMember.values()[this.member.ordinal() + 1];
                Utils.OrgMember leftMember = this.member == Utils.OrgMember.XEMNAS ? Utils.OrgMember.ROXAS : Utils.OrgMember.values()[this.member.ordinal() - 1];
                if (this.playerData.isWeaponUnlocked(this.getStarterWeapon(leftMember))) {
                    return true;
                }
                return this.playerData.isWeaponUnlocked(this.getStarterWeapon(rightMember));
            }
            return this.playerData.isWeaponUnlocked(this.weapons.get(this.current - 1));
        }
        return false;
    }

    public void updateButtons() {
        if (this.playerData.isWeaponUnlocked(this.weapons.get(this.current))) {
            this.unlock = false;
            this.select.setMessage("Equip");
            if (this.playerData.getEquippedWeapon().func_77973_b() == this.weapons.get(this.current)) {
                this.select.active = false;
                this.select.setMessage("Equipped");
            } else {
                this.select.active = true;
                this.select.setMessage("Equip");
            }
        } else {
            this.unlock = true;
            this.select.setMessage("Unlock");
            this.select.active = this.canUnlock();
        }
        this.next.visible = true;
        this.next.x = this.width / 2 - this.next.getWidth() / 2 + 128;
        this.next.y = this.height / 2 - this.next.getHeight() / 2;
        this.prev.visible = true;
        this.prev.x = this.width / 2 - this.prev.getWidth() / 2 - 128;
        this.prev.y = this.height / 2 - this.prev.getHeight() / 2;
        this.select.visible = true;
        this.select.x = this.width / 2 - this.select.getWidth() / 2;
        this.select.y = this.height / 2 - this.select.getHeight() / 2 + 90;
        this.cancel.visible = true;
        this.cancel.x = this.width / 2 - this.select.getWidth() / 2;
        this.cancel.y = this.height / 2 - this.select.getHeight() / 2 + 115;
    }
}

