/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuScrollBar;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSSynthesiseKeyblade;
import online.kingdomkeys.kingdomkeys.synthesis.material.Material;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class SynthesisCreateScreen
extends MenuFilterable {
    MenuScrollBar scrollBar;
    MenuBox boxL;
    MenuBox boxM;
    MenuBox boxR;
    int itemsX = 100;
    int itemsY = 100;
    int itemWidth = 140;
    int itemHeight = 10;
    Button prev;
    Button next;
    Button create;
    int itemsPerPage;
    private MenuButton back;

    public SynthesisCreateScreen() {
        super("Synthesis", new Color(0, 255, 0));
        this.drawSeparately = true;
    }

    protected void action(String string) {
        switch (string) {
            case "prev": {
                --this.page;
                this.minecraft.field_71441_e.func_184133_a((PlayerEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_180425_c(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                break;
            }
            case "next": {
                ++this.page;
                this.minecraft.field_71441_e.func_184133_a((PlayerEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_180425_c(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                break;
            }
            case "create": {
                PacketHandler.sendToServer(new CSSynthesiseKeyblade(this.selected.func_77973_b().getRegistryName()));
                this.minecraft.field_71441_e.func_184133_a((PlayerEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_180425_c(), (SoundEvent)ModSounds.itemget.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            }
        }
    }

    @Override
    public void init() {
        float boxPosX = (float)this.width * 0.1437f;
        float topBarHeight = (float)this.height * 0.17f;
        float boxWidth = (float)this.width * 0.35f;
        float middleHeight = (float)this.height * 0.6f;
        this.boxL = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, new Color(4, 4, 68));
        this.boxM = new MenuBox((int)boxPosX + (int)boxWidth, (int)topBarHeight, (int)(boxWidth * 0.46f), (int)middleHeight, new Color(4, 4, 68));
        this.boxR = new MenuBox(this.boxM.x + (int)(boxWidth * 0.46f), (int)topBarHeight, (int)boxWidth, (int)middleHeight, new Color(4, 4, 68));
        float filterPosX = (float)this.width * 0.3f;
        float filterPosY = (float)this.height * 0.02f;
        this.filterBar = new MenuFilterBar((int)filterPosX, (int)filterPosY, this);
        this.filterBar.init();
        this.initItems();
        this.buttonPosX -= 10.0f;
        this.buttonWidth = (float)this.width * 0.07f;
        this.back = new MenuButton((int)this.buttonPosX, this.buttonPosY, (int)this.buttonWidth, new TranslationTextComponent("gui.menu.back", new Object[0]).func_150254_d(), MenuButton.ButtonType.BUTTON, b -> this.minecraft.func_147108_a((Screen)new SynthesisScreen()));
        this.addButton((Widget)this.back);
        super.init();
        this.itemsPerPage = (int)(middleHeight / 14.0f);
    }

    @Override
    public void initItems() {
        int i;
        ClientPlayerEntity player = this.minecraft.field_71439_g;
        float invPosX = (float)this.width * 0.1494f;
        float invPosY = (float)this.height * 0.1851f;
        this.inventory.clear();
        this.children.clear();
        this.buttons.clear();
        this.filterBar.buttons.forEach(arg_0 -> ((SynthesisCreateScreen)this).addButton(arg_0));
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
        for (i = 0; i < playerData.getKnownRecipeList().size(); ++i) {
            ResourceLocation itemName = playerData.getKnownRecipeList().get(i);
            Recipe recipe = RecipeRegistry.getInstance().getValue(itemName);
            ItemStack stack2 = new ItemStack((IItemProvider)recipe.getResult());
            if (recipe.getResult() instanceof KeychainItem) {
                stack2 = new ItemStack((IItemProvider)((KeychainItem)recipe.getResult()).getKeyblade());
            }
            if (!this.filterItem(stack2)) continue;
            items.add(stack2);
        }
        items.sort(Comparator.comparing(Utils::getCategoryForStack).thenComparing(stack -> stack.func_200301_q().func_150261_e()));
        for (i = 0; i < items.size(); ++i) {
            this.inventory.add(new MenuStockItem(this, (ItemStack)items.get(i), (int)invPosX, (int)invPosY + i * 14, false));
        }
        this.inventory.forEach(arg_0 -> ((SynthesisCreateScreen)this).addButton(arg_0));
        super.init();
        float buttonPosX = (float)this.width * 0.03f;
        this.prev = new Button((int)buttonPosX + 10, (int)((float)this.height * 0.1f), 30, 20, Utils.translateToLocal("<--"), e -> this.action("prev"));
        this.addButton((Widget)this.prev);
        this.next = new Button((int)buttonPosX + 10 + 76, (int)((float)this.height * 0.1f), 30, 20, Utils.translateToLocal("-->"), e -> this.action("next"));
        this.addButton((Widget)this.next);
        this.create = new Button(this.boxM.x + 3, (int)((double)this.height * 0.67), 70, 20, Utils.translateToLocal("gui.synthesis.synthesise.create"), e -> this.action("create"));
        this.addButton((Widget)this.create);
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        int i;
        this.drawMenuBackground(mouseX, mouseY, partialTicks);
        this.boxL.draw();
        this.boxM.draw();
        this.boxR.draw();
        super.render(mouseX, mouseY, partialTicks);
        this.prev.visible = this.page > 0;
        boolean bl = this.next.visible = this.page < this.inventory.size() / this.itemsPerPage;
        if (this.selected != ItemStack.field_190927_a) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g);
            boolean enoughMats = true;
            if (RecipeRegistry.getInstance().containsKey(this.selected.func_77973_b().getRegistryName())) {
                Recipe recipe = RecipeRegistry.getInstance().getValue(this.selected.func_77973_b().getRegistryName());
                this.create.visible = true;
                for (Map.Entry<Material, Integer> m : recipe.getMaterials().entrySet()) {
                    if (playerData.getMaterialAmount(m.getKey()) >= m.getValue()) continue;
                    enoughMats = false;
                }
            }
            this.create.active = enoughMats;
            if (this.minecraft.field_71439_g.field_71071_by.func_70447_i() == -1) {
                this.create.active = false;
                this.create.setMessage("No empty slot");
            }
            this.create.visible = RecipeRegistry.getInstance().containsKey(this.selected.func_77973_b().getRegistryName());
        } else {
            this.create.visible = false;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)((float)this.width * 0.03f + 45.0f), (double)((double)this.height * 0.15 - 18.0), (double)1.0);
        this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal("Page: " + (this.page + 1)), 0, 10, 0xFF9900);
        RenderSystem.popMatrix();
        for (i = 0; i < this.inventory.size(); ++i) {
            ((MenuStockItem)((Object)this.inventory.get((int)i))).active = false;
        }
        for (i = this.page * this.itemsPerPage; i < this.page * this.itemsPerPage + this.itemsPerPage; ++i) {
            if (i >= this.inventory.size() || this.inventory.get(i) == null) continue;
            ((MenuStockItem)((Object)this.inventory.get((int)i))).visible = true;
            ((MenuStockItem)((Object)this.inventory.get((int)i))).y = (int)this.topBarHeight + i % this.itemsPerPage * 14 + 5;
            ((MenuStockItem)((Object)this.inventory.get(i))).render(mouseX, mouseY, partialTicks);
            ((MenuStockItem)((Object)this.inventory.get((int)i))).active = true;
        }
        this.prev.render(mouseX, mouseY, partialTicks);
        this.next.render(mouseX, mouseY, partialTicks);
        this.create.render(mouseX, mouseY, partialTicks);
        this.back.render(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderSelectedData(int mouseX, int mouseY, float partialTicks) {
        float tooltipPosX = (float)this.width * 0.3333f;
        float tooltipPosY = (float)this.height * 0.8f;
        float iconPosX = this.boxR.x;
        float iconPosY = this.boxR.y + 25;
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g);
        RenderHelper.func_74518_a();
        RenderSystem.pushMatrix();
        double offset = (float)this.boxM.getWidth() * 0.1f;
        RenderSystem.translated((double)((double)this.boxM.x + offset / 2.0), (double)iconPosY, (double)1.0);
        RenderSystem.scaled((double)((double)(this.boxM.getWidth() / 20) - offset / 20.0), (double)((double)(this.boxM.getWidth() / 20) - offset / 20.0), (double)1.0);
        this.itemRenderer.func_175042_a(this.selected, 0, 0);
        RenderSystem.popMatrix();
        if (this.selected.func_77973_b() != null && this.selected.func_77973_b() instanceof KeybladeItem) {
            KeybladeItem kb = (KeybladeItem)this.selected.func_77973_b();
            RenderSystem.pushMatrix();
            String text = Utils.translateToLocal(this.selected.func_77977_a());
            this.drawString(this.minecraft.field_71466_p, text, (int)(tooltipPosX + 5.0f), (int)tooltipPosY + 5, 0xFF9900);
            FontRenderer fontRenderer = this.minecraft.field_71466_p;
            String string = kb.getDescription();
            int n = (int)tooltipPosX + 5;
            int n2 = (int)tooltipPosY + 5;
            this.minecraft.field_71466_p.getClass();
            fontRenderer.func_78279_b(string, n, n2 + 9, (int)((float)this.width * 0.6f), 0xFFFFFF);
            RenderSystem.popMatrix();
            RenderSystem.pushMatrix();
            RenderSystem.translated((double)(this.boxM.x + 10), (double)((double)this.height * 0.58), (double)1.0);
            this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal("gui.menu.status.strength") + ": " + kb.getStrength(0), 0, 0, 0xFF0000);
            this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal("gui.menu.status.magic") + ": " + kb.getMagic(0), 0, 10, 0x4444FF);
            RenderSystem.popMatrix();
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)(iconPosX + 20.0f), (double)((double)this.height * 0.2), (double)1.0);
        if (RecipeRegistry.getInstance().containsKey(this.selected.func_77973_b().getRegistryName())) {
            Recipe recipe = RecipeRegistry.getInstance().getValue(this.selected.func_77973_b().getRegistryName());
            Iterator<Map.Entry<Material, Integer>> materials = Utils.getSortedMaterials(recipe.getMaterials()).entrySet().iterator();
            int i = 0;
            while (materials.hasNext()) {
                Map.Entry<Material, Integer> m = materials.next();
                ItemStack stack = new ItemStack((IItemProvider)ForgeRegistries.ITEMS.getValue(new ResourceLocation(m.getKey().getMaterialName())), m.getValue().intValue());
                String n = Utils.translateToLocal(stack.func_77977_a());
                int color = playerData.getMaterialAmount(m.getKey()) >= m.getValue() ? 65280 : 0xFF0000;
                this.drawString(this.minecraft.field_71466_p, n + " x" + m.getValue() + " (" + playerData.getMaterialAmount(m.getKey()) + ")", 0, i * 16, color);
                this.itemRenderer.func_175042_a(stack, -17, i * 16 - 4);
                ++i;
            }
        }
        RenderSystem.popMatrix();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

