/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.client.gui.synthesis;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuBox;
import online.kingdomkeys.kingdomkeys.client.gui.elements.MenuFilterable;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuButton;
import online.kingdomkeys.kingdomkeys.client.gui.elements.buttons.MenuStockItem;
import online.kingdomkeys.kingdomkeys.client.gui.synthesis.SynthesisScreen;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSDepositMaterials;
import online.kingdomkeys.kingdomkeys.network.cts.CSSyncAllClientDataPacket;
import online.kingdomkeys.kingdomkeys.network.cts.CSTakeMaterials;
import online.kingdomkeys.kingdomkeys.synthesis.material.Material;
import online.kingdomkeys.kingdomkeys.synthesis.material.ModMaterials;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class SynthesisMaterialScreen
extends MenuFilterable {
    MenuButton deposit;
    MenuButton back;
    Button prev;
    Button next;
    Button take;
    MenuBox boxL;
    MenuBox boxR;
    TextFieldWidget amountBox;
    int page = 0;
    int itemsPerPage = 14;

    public SynthesisMaterialScreen() {
        super("gui.synthesis.materials", new Color(0, 255, 0));
        this.drawPlayerInfo = true;
    }

    @Override
    public void action(ItemStack stack) {
        super.action(stack);
        this.amountBox.func_146180_a("" + Math.min(64, stack.func_190916_E()));
    }

    protected void action(String string) {
        switch (string) {
            case "prev": {
                --this.page;
                this.minecraft.field_71441_e.func_184133_a((PlayerEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_180425_c(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                break;
            }
            case "next": {
                ++this.page;
                this.minecraft.field_71441_e.func_184133_a((PlayerEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_180425_c(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                break;
            }
            case "deposit": {
                this.minecraft.field_71441_e.func_184133_a((PlayerEntity)this.minecraft.field_71439_g, this.minecraft.field_71439_g.func_180425_c(), (SoundEvent)ModSounds.menu_in.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                ClientPlayerEntity player = this.minecraft.field_71439_g;
                IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    ItemStack stack = player.field_71071_by.func_70301_a(i);
                    if (ItemStack.func_77989_b((ItemStack)stack, (ItemStack)ItemStack.field_190927_a) || ModMaterials.registry.getValue(new ResourceLocation("kingdomkeys", "mat_" + stack.func_77973_b().getRegistryName().func_110623_a())) == null) continue;
                    Material mat = (Material)ModMaterials.registry.getValue(new ResourceLocation("kingdomkeys", "mat_" + stack.func_77973_b().getRegistryName().func_110623_a()));
                    playerData.addMaterial(mat, stack.func_190916_E());
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                }
                PacketHandler.sendToServer(new CSDepositMaterials());
                PacketHandler.sendToServer(new CSSyncAllClientDataPacket());
                break;
            }
            case "back": {
                this.minecraft.func_147108_a((Screen)new SynthesisScreen());
                break;
            }
            case "take": {
                if (ItemStack.func_179545_c((ItemStack)this.selected, (ItemStack)ItemStack.field_190927_a) || this.minecraft.field_71439_g.field_71071_by.func_70447_i() <= -1) break;
                try {
                    Integer.parseInt(this.amountBox.func_146179_b());
                    PacketHandler.sendToServer(new CSTakeMaterials(this.selected.func_77973_b(), Integer.parseInt(this.amountBox.func_146179_b())));
                    break;
                }
                catch (Exception e) {
                    System.out.println("NaN " + this.amountBox.func_146179_b());
                }
            }
        }
        this.updateButtons();
    }

    private void updateButtons() {
    }

    @Override
    public void init() {
        float boxPosX = (float)this.width * 0.2f;
        float topBarHeight = (float)this.height * 0.17f;
        float boxWidth = (float)this.width * 0.33f;
        float middleHeight = (float)this.height * 0.6f;
        this.boxL = new MenuBox((int)boxPosX, (int)topBarHeight, (int)boxWidth, (int)middleHeight, new Color(4, 4, 68));
        this.boxR = new MenuBox(this.boxL.x + this.boxL.getWidth(), (int)topBarHeight, (int)boxWidth, (int)middleHeight, new Color(4, 4, 68));
        super.init();
        this.initItems();
        this.itemsPerPage = (int)(middleHeight / 14.0f);
    }

    @Override
    public void initItems() {
        float buttonPosX = (float)this.width * 0.008f;
        int button_statsY = (int)this.topBarHeight + 10;
        float buttonWidth = (float)this.width * 0.1744f - 20.0f;
        float invPosX = this.boxL.x;
        float invPosY = (float)this.height * 0.1851f;
        this.inventory.clear();
        this.children.clear();
        this.buttons.clear();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)this.minecraft.field_71439_g);
        for (Map.Entry<String, Integer> mat : playerData.getMaterialMap().entrySet()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(mat.getKey()));
            items.add(new ItemStack((IItemProvider)item, mat.getValue().intValue()));
        }
        items.sort(Comparator.comparing(Utils::getCategoryForStack).thenComparing(stack -> stack.func_77977_a()));
        for (int i = 0; i < items.size(); ++i) {
            this.inventory.add(new MenuStockItem(this, (ItemStack)items.get(i), (int)invPosX, (int)invPosY + i * 14, true));
        }
        this.inventory.forEach(arg_0 -> ((SynthesisMaterialScreen)this).addButton(arg_0));
        this.prev = new Button((int)buttonPosX + 10, (int)((float)this.height * 0.1f), 30, 20, Utils.translateToLocal("<--"), e -> this.action("prev"));
        this.addButton((Widget)this.prev);
        this.next = new Button((int)buttonPosX + 10 + 76, (int)((float)this.height * 0.1f), 30, 20, Utils.translateToLocal("-->"), e -> this.action("next"));
        this.addButton((Widget)this.next);
        this.prev.visible = false;
        this.next.visible = false;
        this.deposit = new MenuButton((int)buttonPosX, button_statsY + 0, (int)buttonWidth, Utils.translateToLocal("gui.synthesis.materials.deposit"), MenuButton.ButtonType.BUTTON, e -> this.action("deposit"));
        this.addButton((Widget)this.deposit);
        this.back = new MenuButton((int)buttonPosX, button_statsY + 18, (int)buttonWidth, Utils.translateToLocal("gui.menu.back"), MenuButton.ButtonType.BUTTON, e -> this.action("back"));
        this.addButton((Widget)this.back);
        this.amountBox = new TextFieldWidget(this.minecraft.field_71466_p, this.boxR.x + 50, (int)(this.topBarHeight + this.middleHeight - 20.0f), this.minecraft.field_71466_p.func_78256_a("#####"), 16, "test"){

            public boolean charTyped(char c, int i) {
                if (SynthesisMaterialScreen.this.isNumber(c)) {
                    String text = new StringBuilder(this.func_146179_b()).insert(this.func_146198_h(), c).toString();
                    if (Integer.parseInt(text) > 64) {
                        return false;
                    }
                } else {
                    return false;
                }
                return super.charTyped(c, i);
            }
        };
        this.addButton((Widget)this.amountBox);
        this.take = new Button(this.amountBox.x + this.amountBox.getWidth() + 1, (int)(this.topBarHeight + this.middleHeight - 22.0f), 50, 20, Utils.translateToLocal("gui.synthesis.materials.take"), e -> this.action("take"));
        this.addButton((Widget)this.take);
        this.take.visible = false;
        this.updateButtons();
    }

    public boolean isNumber(char c) {
        try {
            Integer.parseInt(String.valueOf(c));
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTicks) {
        int i;
        this.drawMenuBackground(mouseX, mouseY, partialTicks);
        this.boxL.draw();
        this.boxR.draw();
        super.render(mouseX, mouseY, partialTicks);
        this.prev.visible = this.page > 0;
        boolean bl = this.next.visible = this.page < this.inventory.size() / this.itemsPerPage;
        if (this.minecraft.field_71439_g.field_71071_by.func_70447_i() == -1) {
            this.take.active = false;
            this.take.setMessage("No empty slot");
        }
        RenderSystem.pushMatrix();
        RenderSystem.translated((double)((float)this.width * 0.008f + 45.0f), (double)((double)this.height * 0.15 - 18.0), (double)1.0);
        this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal("Page: " + (this.page + 1)), 0, 10, 0xFF9900);
        RenderSystem.popMatrix();
        for (i = 0; i < this.inventory.size(); ++i) {
            ((MenuStockItem)((Object)this.inventory.get((int)i))).active = false;
        }
        for (i = this.page * this.itemsPerPage; i < this.page * this.itemsPerPage + this.itemsPerPage; ++i) {
            if (i >= this.inventory.size() || this.inventory.get(i) == null) continue;
            ((MenuStockItem)((Object)this.inventory.get((int)i))).visible = true;
            ((MenuStockItem)((Object)this.inventory.get((int)i))).y = (int)this.topBarHeight + i % this.itemsPerPage * 14 + 5;
            ((MenuStockItem)((Object)this.inventory.get(i))).render(mouseX, mouseY, partialTicks);
            ((MenuStockItem)((Object)this.inventory.get((int)i))).active = true;
        }
        this.prev.render(mouseX, mouseY, partialTicks);
        this.next.render(mouseX, mouseY, partialTicks);
        this.deposit.render(mouseX, mouseY, partialTicks);
        this.back.render(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderSelectedData(int mouseX, int mouseY, float partialTicks) {
        this.amountBox.render(mouseX, mouseY, partialTicks);
        this.take.render(mouseX, mouseY, partialTicks);
        this.take.visible = true;
        float iconPosX = this.boxR.x;
        float iconPosY = this.boxR.y + 15;
        RenderSystem.pushMatrix();
        String name = this.selected.func_200301_q().func_150254_d();
        RenderSystem.translated((double)(this.boxR.x + this.boxR.getWidth() / 2 - this.minecraft.field_71466_p.func_78256_a(name) / 2), (double)(this.boxR.y + 3), (double)1.0);
        this.drawString(this.minecraft.field_71466_p, Utils.translateToLocal(name), 0, 0, 0xFF9900);
        RenderSystem.popMatrix();
        RenderSystem.pushMatrix();
        double offset = (float)this.boxR.getWidth() * 0.2f;
        RenderSystem.translated((double)((double)iconPosX + offset / 2.0), (double)iconPosY, (double)1.0);
        RenderSystem.scaled((double)((double)(this.boxR.getWidth() / 16) - offset / 16.0), (double)((double)(this.boxR.getWidth() / 16) - offset / 16.0), (double)1.0);
        this.itemRenderer.func_175042_a(this.selected, 0, 0);
        RenderSystem.popMatrix();
    }

    public boolean isPauseScreen() {
        return false;
    }
}

