/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.common.ModDimension;
import net.minecraftforge.common.util.ITeleporter;
import net.minecraftforge.fml.RegistryObject;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.world.dimension.ModDimensions;
import online.kingdomkeys.kingdomkeys.world.utils.BaseTeleporter;

public class DimensionCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSource> SUGGEST_DIMENSIONS = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        list.add("overworld");
        for (RegistryObject location : ModDimensions.DIMENSIONS.getEntries()) {
            list.add(((ModDimension)location.get()).getRegistryName().toString());
        }
        return ISuggestionProvider.func_197013_a(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"kk_dimension").requires(source -> source.func_197034_c(3));
        builder.then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"dim", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_DIMENSIONS).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(DimensionCommand::changeDim))).executes(DimensionCommand::changeDim));
        dispatcher.register(builder);
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
    }

    private static int changeDim(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = DimensionCommand.getPlayers(context, 2);
        String dim = StringArgumentType.getString(context, (String)"dim");
        DimensionType dimension = DimensionType.func_193417_a((ResourceLocation)new ResourceLocation(dim));
        if (dimension == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Invalid dimension " + dim, new Object[0]), true);
            return 1;
        }
        for (ServerPlayerEntity player : players) {
            BlockPos coords = DimensionCommand.getWorldCoords((PlayerEntity)player, dimension);
            player.changeDimension(dimension, (ITeleporter)new BaseTeleporter(coords.func_177958_n(), coords.func_177956_o(), coords.func_177952_p()));
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Teleported" + player.func_145748_c_().func_150254_d() + " to dimension " + dimension.getRegistryName().toString(), new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("You have been teleported to " + dimension.getRegistryName().toString(), new Object[0]));
        }
        return 1;
    }

    private static BlockPos getWorldCoords(PlayerEntity player, DimensionType dimension) {
        if (dimension == ModDimensions.DIVE_TO_THE_HEART_TYPE) {
            return new BlockPos(0, 26, 0);
        }
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        return new BlockPos(playerData.getReturnLocation());
    }
}

