/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.lib.SoAState;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

public class KKLevelCommand
extends BaseCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"kk_level").requires(source -> source.func_197034_c(3));
        builder.then(Commands.func_197057_a((String)"set").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKLevelCommand::setValue))).executes(KKLevelCommand::setValue)));
        dispatcher.register(builder);
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
    }

    private static int setValue(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKLevelCommand.getPlayers(context, 3);
        int level = IntegerArgumentType.getInteger(context, (String)"level");
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            playerData.setLevel(1);
            playerData.setExperience(0);
            playerData.setMaxHP(20);
            player.func_70606_j((float)playerData.getMaxHP());
            player.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a((double)playerData.getMaxHP());
            playerData.setMaxMP(0.0);
            playerData.setMP(playerData.getMaxMP());
            playerData.setMaxAP(10);
            playerData.setStrength(1);
            playerData.setMagic(1);
            playerData.setDefense(1);
            SoAState.applyStatsForChoices(playerData);
            playerData.clearAbilities();
            playerData.addAbility("kingdomkeys:ability_zero_exp", false);
            while (playerData.getLevel() < level) {
                playerData.addExperience((PlayerEntity)player, playerData.getExpNeeded(level - 1, playerData.getExperience()), false);
            }
            LinkedHashMap<String, int[]> driveForms = playerData.getDriveFormMap();
            for (Map.Entry<String, int[]> entry : driveForms.entrySet()) {
                int dfLevel = entry.getValue()[0];
                DriveForm form = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(entry.getKey()));
                if (form.getRegistryName().equals((Object)DriveForm.NONE)) continue;
                for (int i = 1; i <= dfLevel; ++i) {
                    String baseAbility = form.getBaseAbilityForLevel(i);
                    if (baseAbility.equals("")) continue;
                    playerData.addAbility(baseAbility, false);
                }
            }
            player.func_70691_i((float)playerData.getMaxHP());
            playerData.setMP(playerData.getMaxMP());
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Set " + player.func_145748_c_().func_150254_d() + " level to " + level, new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Your level is now " + level, new Object[0]));
        }
        return 1;
    }

    private static int addValue(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKLevelCommand.getPlayers(context, 3);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            playerData.setMunny(playerData.getMunny() + value);
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Added " + value + " munny to " + player.func_145748_c_().func_150254_d(), new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Your munny has been increased by " + value, new Object[0]));
        }
        return 1;
    }

    private static int removeValue(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKLevelCommand.getPlayers(context, 3);
        int value = IntegerArgumentType.getInteger(context, (String)"value");
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            playerData.setMunny(playerData.getMunny() - value);
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Taken " + value + " munny from " + player.func_145748_c_().func_150254_d(), new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Your munny has been decreased by " + value, new Object[0]));
        }
        return 1;
    }
}

