/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.synthesis.material.Material;
import online.kingdomkeys.kingdomkeys.synthesis.material.ModMaterials;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KKMaterialCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSource> SUGGEST_MATERIALS = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (ResourceLocation actual : ModMaterials.registry.getKeys()) {
            list.add(actual.toString());
        }
        return ISuggestionProvider.func_197013_a(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"kk_material").requires(source -> source.func_197034_c(3));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"give").then(Commands.func_197056_a((String)"material", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_MATERIALS).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKMaterialCommand::addMaterial))).executes(KKMaterialCommand::addMaterial)))).then(Commands.func_197057_a((String)"all").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKMaterialCommand::addAllMaterials))).executes(KKMaterialCommand::addAllMaterials))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"take").then(Commands.func_197056_a((String)"material", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_MATERIALS).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKMaterialCommand::takeMaterial))).executes(KKMaterialCommand::takeMaterial)))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"all").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKMaterialCommand::takeAllMaterials))).executes(KKMaterialCommand::takeAllMaterials)));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"set").then(Commands.func_197056_a((String)"material", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_MATERIALS).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKMaterialCommand::setMaterial))).executes(KKMaterialCommand::setMaterial)))).then(Commands.func_197057_a((String)"all").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1)).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKMaterialCommand::setAllMaterials))).executes(KKMaterialCommand::setAllMaterials))));
        dispatcher.register(builder);
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
    }

    private static int addMaterial(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKMaterialCommand.getPlayers(context, 4);
        String materialName = StringArgumentType.getString(context, (String)"material");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        Material material = (Material)ModMaterials.registry.getValue(new ResourceLocation(materialName));
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            playerData.addMaterial(material, amount);
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Given x" + amount + " '" + Utils.translateToLocal(material.getMaterialName()) + "' to " + player.func_145748_c_().func_150254_d(), new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("You have been given x" + amount + " '" + Utils.translateToLocal(material.getMaterialName()) + "'", new Object[0]));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int takeMaterial(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKMaterialCommand.getPlayers(context, 4);
        String materialName = StringArgumentType.getString(context, (String)"material");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        Material material = (Material)ModMaterials.registry.getValue(new ResourceLocation(materialName));
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            playerData.removeMaterial(material, amount);
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Removed material '" + Utils.translateToLocal(material.getMaterialName()) + "' from " + player.func_145748_c_().func_150254_d(), new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("x" + amount + " '" + Utils.translateToLocal(material.getMaterialName()) + "' have been taken away from you", new Object[0]));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int addAllMaterials(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKMaterialCommand.getPlayers(context, 4);
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            for (Material material : ModMaterials.registry.getValues()) {
                playerData.addMaterial(material, amount);
            }
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Given all materials to " + player.func_145748_c_().func_150254_d(), new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("You have been given all the materials", new Object[0]));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int takeAllMaterials(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKMaterialCommand.getPlayers(context, 3);
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            playerData.clearMaterials();
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Taken all materials from " + player.func_145748_c_().func_150254_d(), new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Your materials have been taken away", new Object[0]));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int setMaterial(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKMaterialCommand.getPlayers(context, 4);
        String materialName = StringArgumentType.getString(context, (String)"material");
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        Material material = (Material)ModMaterials.registry.getValue(new ResourceLocation(materialName));
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            playerData.setMaterial(material, amount);
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Set x" + amount + " '" + Utils.translateToLocal(material.getMaterialName()) + "' to " + player.func_145748_c_().func_150254_d(), new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Your '" + Utils.translateToLocal(material.getMaterialName()) + "' have been set to x" + amount, new Object[0]));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int setAllMaterials(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKMaterialCommand.getPlayers(context, 4);
        int amount = IntegerArgumentType.getInteger(context, (String)"amount");
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            for (Material material : ModMaterials.registry.getValues()) {
                playerData.setMaterial(material, amount);
            }
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Set all materials for " + player.func_145748_c_().func_150254_d() + " to " + amount, new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("You have been set all the materials to " + amount, new Object[0]));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }
}

