/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.command.BaseCommand;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.RecipeRegistry;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KKRecipeCommand
extends BaseCommand {
    private static final SuggestionProvider<CommandSource> SUGGEST_RECIPES = (p_198296_0_, p_198296_1_) -> {
        ArrayList<String> list = new ArrayList<String>();
        for (Recipe actual : RecipeRegistry.getInstance().getValues()) {
            list.add(actual.getRegistryName().toString());
        }
        return ISuggestionProvider.func_197013_a(list.stream().map(StringArgumentType::escapeIfRequired), (SuggestionsBuilder)p_198296_1_);
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"kk_recipe").requires(source -> source.func_197034_c(3));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"give").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"recipe", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_RECIPES).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKRecipeCommand::addRecipe))).executes(KKRecipeCommand::addRecipe))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"all").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKRecipeCommand::addAllRecipes))).executes(KKRecipeCommand::addAllRecipes)));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"take").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"recipe", (ArgumentType)StringArgumentType.string()).suggests(SUGGEST_RECIPES).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKRecipeCommand::removeRecipe))).executes(KKRecipeCommand::removeRecipe))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"all").then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(KKRecipeCommand::removeAllRecipes))).executes(KKRecipeCommand::removeAllRecipes)));
        dispatcher.register(builder);
        KingdomKeys.LOGGER.warn("Registered command " + builder.getLiteral());
    }

    private static int addRecipe(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKRecipeCommand.getPlayers(context, 3);
        String recipe = StringArgumentType.getString(context, (String)"recipe");
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            playerData.addKnownRecipe(new ResourceLocation(recipe));
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Added '" + Utils.translateToLocal(recipe) + "' recipe to " + player.func_145748_c_().func_150254_d(), new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("You have been given '" + Utils.translateToLocal(recipe) + "' recipe", new Object[0]));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int removeRecipe(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKRecipeCommand.getPlayers(context, 3);
        String recipe = StringArgumentType.getString(context, (String)"recipe");
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            playerData.removeKnownRecipe(new ResourceLocation(recipe));
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Removed recipe '" + Utils.translateToLocal(recipe) + "' from " + player.func_145748_c_().func_150254_d(), new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Your recipe '" + Utils.translateToLocal(recipe) + "' has been taken away", new Object[0]));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int addAllRecipes(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKRecipeCommand.getPlayers(context, 3);
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            for (Recipe actual : RecipeRegistry.getInstance().getValues()) {
                playerData.addKnownRecipe(actual.getRegistryName());
            }
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Added all recipes to " + player.func_145748_c_().func_150254_d(), new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("You have been given all the recipes", new Object[0]));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }

    private static int removeAllRecipes(CommandContext<CommandSource> context) throws CommandSyntaxException {
        Collection<ServerPlayerEntity> players = KKRecipeCommand.getPlayers(context, 3);
        for (ServerPlayerEntity player : players) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            playerData.clearRecipes();
            if (player != ((CommandSource)context.getSource()).func_197035_h()) {
                ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("Removed all recipes from " + player.func_145748_c_().func_150254_d(), new Object[0]), true);
            }
            player.func_145747_a((ITextComponent)new TranslationTextComponent("Your recipes have been taken away", new Object[0]));
            PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
        }
        return 1;
    }
}

