/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import online.kingdomkeys.kingdomkeys.entity.SpawningMode;

public class CommonConfig {
    public ForgeConfigSpec.EnumValue<SpawningMode> heartlessSpawningMode;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> mobSpawnRate;
    public ForgeConfigSpec.BooleanValue oreGen;
    public ForgeConfigSpec.BooleanValue bloxGen;
    public ForgeConfigSpec.BooleanValue debugConsoleOutput;
    public ForgeConfigSpec.DoubleValue limitLaserCircleMult;
    public ForgeConfigSpec.DoubleValue limitLaserDomeMult;

    CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.oreGen = builder.comment("Allow Synthesis Materials ores to generate").translation("kingdomkeys.config.ore_gen").define("oreGen", true);
        this.bloxGen = builder.comment("Allow Blox to generate").translation("kingdomkeys.config.blox_gen").define("bloxGen", true);
        this.debugConsoleOutput = builder.comment("Enable debug console output").translation("kingdomkeys.config.debug").define("debugConsoleOutput", false);
        builder.pop();
        builder.push("spawning");
        this.heartlessSpawningMode = builder.comment("Heartless spawning mode: NEVER, ALWAYS, AFTER_KEYCHAIN (after the first keychain is synthesized), AFTER_DRAGON (after the Ender Dragon is defeated)").translation("kingdomkeys.config.heartless_spawning_mode").defineEnum("heartlessSpawningMode", (Enum)SpawningMode.AFTER_KEYCHAIN);
        this.mobSpawnRate = builder.comment("Mob Spawn").translation("kingdomkeys.config.mob_spawn").defineList("mobSpawn", (List)Lists.newArrayList((Object[])new String[]{"Moogle,2,0,1", "Pureblood,2,0,1", "Emblem,2,0,1", "Nobody,2,0,1"}), o -> o instanceof String);
        builder.pop();
        builder.push("limits");
        this.limitLaserCircleMult = builder.comment("Laser Circle Damage Multiplier ((strength + magic) / 2 * multiplier)").translation("kingdomkeys.config.laser_circle_mult").defineInRange("laserCircleMult", 2.0, 0.0, 100.0);
        this.limitLaserDomeMult = builder.comment("Laser Dome Damage Multiplier ((strength + magic) / 2 * multiplier)").translation("kingdomkeys.config.laser_dome_mult").defineInRange("laserDomeMult", 0.3, 0.0, 100.0);
        builder.pop();
    }
}

