/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.config;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ServerConfig {
    public ForgeConfigSpec.IntValue recipeDropChance;
    public ForgeConfigSpec.IntValue partyRangeLimit;
    public ForgeConfigSpec.ConfigValue<List<? extends String>> driveFormXPMultiplier;
    public ForgeConfigSpec.DoubleValue xpMultiplier;
    public ForgeConfigSpec.DoubleValue heartMultiplier;
    public ForgeConfigSpec.DoubleValue partyXPShare;

    ServerConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.recipeDropChance = builder.comment("Recipe drop chance").translation("kingdomkeys.config.recipe_drop_chance").defineInRange("recipeDropChance", 2, 0, 100);
        this.partyRangeLimit = builder.comment("Party range limit").translation("kingdomkeys.config.party_range_limit").defineInRange("partyRangeLimit", 50, 1, 150);
        builder.pop();
        builder.push("leveling");
        this.xpMultiplier = builder.comment("XP Multiplier").translation("kingdomkeys.config.xp_multiplier").defineInRange("xpMultiplier", 1.0, 0.0, 1000.0);
        this.heartMultiplier = builder.comment("Hearts Multiplier").translation("kingdomkeys.config.heart_multiplier").defineInRange("heartMultiplier", 1.0, 0.0, 1000.0);
        this.partyXPShare = builder.comment("XP Share in party (killer gets 100%, the rest of party members the % specified here)").translation("kingdomkeys.config.party_xp_share").defineInRange("partyXPShare", 0.0, 0.0, 100.0);
        this.driveFormXPMultiplier = builder.comment("Drive Form XP Multiplier").translation("kingdomkeys.config.drive_form_xp_multiplier").defineList("driveFormXPMultiplier", (List)Lists.newArrayList((Object[])new String[]{"Valor,1", "Wisdom,1", "Limit,1", "Master,1", "Final,1"}), o -> o instanceof String);
        builder.pop();
    }
}

