/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.container;

import java.util.function.Supplier;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import online.kingdomkeys.kingdomkeys.client.gui.container.MagicalChestScreen;
import online.kingdomkeys.kingdomkeys.client.gui.container.PedestalScreen;
import online.kingdomkeys.kingdomkeys.client.gui.container.SynthesisBagScreen;
import online.kingdomkeys.kingdomkeys.container.MagicalChestContainer;
import online.kingdomkeys.kingdomkeys.container.PedestalContainer;
import online.kingdomkeys.kingdomkeys.container.SynthesisBagContainer;

public class ModContainers {
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"kingdomkeys");
    public static final RegistryObject<ContainerType<?>> SYNTHESIS_BAG = ModContainers.createContainer("synthesis_bag", SynthesisBagContainer::fromNetwork);
    public static final RegistryObject<ContainerType<?>> PEDESTAL = ModContainers.createContainer("pedestal_container", PedestalContainer::new);
    public static final RegistryObject<ContainerType<?>> MAGICAL_CHEST = ModContainers.createContainer("magical_chest", MagicalChestContainer::new);

    public static <M extends Container> RegistryObject<ContainerType<?>> createContainer(String name, IContainerFactory<M> container) {
        ContainerType newContainer = IForgeContainerType.create(container);
        RegistryObject result = CONTAINERS.register(name, (Supplier)newContainer.delegate);
        return result;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <M extends Container, U extends Screen> void registerGUIFactory(ContainerType<M> container, ScreenManager.IScreenFactory<M, U> guiFactory) {
        ScreenManager.func_216911_a(container, guiFactory);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerGUIFactories() {
        ModContainers.registerGUIFactory((ContainerType)SYNTHESIS_BAG.get(), SynthesisBagScreen::new);
        ModContainers.registerGUIFactory((ContainerType)PEDESTAL.get(), PedestalScreen::new);
        ModContainers.registerGUIFactory((ContainerType)MAGICAL_CHEST.get(), MagicalChestScreen::new);
    }
}

