/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.datagen.provider;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ExistingFileHelper;
import online.kingdomkeys.kingdomkeys.datagen.builder.KeybladeBuilder;

public abstract class KeybladeProvider<T extends KeybladeBuilder<T>>
implements IDataProvider {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    protected final DataGenerator generator;
    protected final String modid;
    protected final Function<ResourceLocation, T> factory;
    @VisibleForTesting
    public final Map<ResourceLocation, T> generatedModels = new HashMap<ResourceLocation, T>();
    @VisibleForTesting
    public final ExistingFileHelper existingFileHelper;

    public KeybladeProvider(DataGenerator generator, String modid, Function<ResourceLocation, T> factory, ExistingFileHelper existingFileHelper) {
        this.generator = generator;
        this.modid = modid;
        this.existingFileHelper = existingFileHelper;
        this.factory = factory;
    }

    public KeybladeProvider(DataGenerator generator, String modid, BiFunction<ResourceLocation, ExistingFileHelper, T> builderFromModId, ExistingFileHelper existingFileHelper) {
        this(generator, modid, (ResourceLocation loc) -> (KeybladeBuilder)((Object)((Object)builderFromModId.apply((ResourceLocation)loc, existingFileHelper))), existingFileHelper);
    }

    protected abstract void registerKeyblades();

    public T getBuilder(String path) {
        Preconditions.checkNotNull((Object)path, (Object)"Path must not be null");
        ResourceLocation outputLoc = path.contains(":") ? new ResourceLocation(path) : new ResourceLocation(this.modid, path);
        return (T)((Object)((KeybladeBuilder)((Object)this.generatedModels.computeIfAbsent(outputLoc, this.factory))));
    }

    protected void clear() {
        this.generatedModels.clear();
    }

    public void func_200398_a(DirectoryCache cache) throws IOException {
        this.clear();
        this.registerKeyblades();
        this.generateAll(cache);
    }

    protected void generateAll(DirectoryCache cache) {
        for (KeybladeBuilder model : this.generatedModels.values()) {
            Path target = this.getPath(model);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)model.toJson(), (Path)target);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private Path getPath(T model) {
        ResourceLocation loc = model.getLocation();
        return this.generator.func_200391_b().resolve("data/" + loc.func_110624_b() + "/keyblades/" + loc.func_110623_a() + ".json");
    }
}

