/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.driveform;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.registries.ForgeRegistryEntry;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;

public abstract class DriveForm
extends ForgeRegistryEntry<DriveForm> {
    public static final ResourceLocation NONE = new ResourceLocation("kingdomkeys:none");
    public static final float[] VALOR_JUMP_BOOST = new float[]{0.0f, 0.02f, 0.02f, 0.03f, 0.03f, 0.04f, 0.04f, 0.05f};
    public static final float[] MASTER_AERIAL_DODGE_BOOST = new float[]{0.0f, 1.0f, 1.0f, 1.2f, 1.2f, 1.4f, 1.4f, 1.6f};
    public static final float[] FINAL_JUMP_BOOST = new float[]{0.0f, 0.02f, 0.02f, 0.025f, 0.025f, 0.03f, 0.03f, 0.04f};
    public static final float[] FINAL_GLIDE = new float[]{0.0f, -0.12f, -0.12f, -0.08f, -0.08f, -0.04f, -0.04f, -0.01f};
    String name;
    int driveCost;
    int ap;
    int[] levelUpCosts;
    int maxLevel;
    int order;
    float[] color;
    ResourceLocation skinRL;
    String translationKey;
    boolean hasKeychain = false;

    public DriveForm(ResourceLocation registryName, int order, boolean hasKeychain) {
        this.name = registryName.toString();
        this.maxLevel = 7;
        this.setRegistryName(registryName);
        this.order = order;
        this.hasKeychain = hasKeychain;
        this.translationKey = "form." + this.getRegistryName().func_110623_a() + ".name";
    }

    public DriveForm(String registryName, int order, boolean hasKeychain) {
        this(new ResourceLocation(registryName), order, hasKeychain);
    }

    public boolean hasKeychain() {
        return this.hasKeychain;
    }

    public String getName() {
        return this.name;
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public int getDriveCost() {
        return this.driveCost;
    }

    public int getFormAntiPoints() {
        return this.ap;
    }

    public int[] getLevelUpCosts() {
        return this.levelUpCosts;
    }

    public int getOrder() {
        return this.order;
    }

    public final float[] getDriveColor() {
        return this.color;
    }

    public ResourceLocation getTextureLocation() {
        return this.skinRL;
    }

    public abstract String getBaseAbilityForLevel(int var1);

    public abstract String getDFAbilityForLevel(int var1);

    public int getLevelUpCost(int level) {
        if (this.levelUpCosts != null) {
            return this.levelUpCosts[level - 1];
        }
        return -1;
    }

    public int getLevelFromExp(int exp) {
        for (int i = 0; i < this.levelUpCosts.length; ++i) {
            if (this.levelUpCosts[i] <= exp) continue;
            return i;
        }
        return this.getMaxLevel();
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public void initDrive(PlayerEntity player) {
        if (!this.getRegistryName().equals((Object)NONE)) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            playerData.setActiveDriveForm(this.getName());
            int cost = ((DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(this.getName()))).getDriveCost();
            playerData.remDP(cost);
            playerData.setFP(300 + playerData.getDriveFormLevel(playerData.getActiveDriveForm()) * 100);
            playerData.setAntiPoints(playerData.getAntiPoints() + this.getFormAntiPoints());
            player.field_70170_p.func_184133_a(player, player.func_180425_c(), (SoundEvent)ModSounds.drive.get(), SoundCategory.MASTER, 1.0f, 1.0f);
            this.pushEntities(player);
            PacketHandler.syncToAllAround(player, playerData);
        }
    }

    private void pushEntities(PlayerEntity player) {
        List list = player.field_70170_p.func_72839_b((Entity)player, player.func_174813_aQ().func_72314_b(4.0, 3.0, 4.0));
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                Entity e = (Entity)list.get(i);
                if (!(e instanceof LivingEntity)) continue;
                double d = e.func_226277_ct_() - player.func_226277_ct_();
                double d1 = e.func_226281_cx_() - player.func_226281_cx_();
                ((LivingEntity)e).func_70653_a(e, 1.0f, -d, -d1);
                e.func_213293_j(e.func_213322_ci().field_72450_a, (double)0.7f, e.func_213322_ci().field_72449_c);
            }
        }
    }

    public void updateDrive(PlayerEntity player) {
        double formDecrease = 0.2;
        if (!this.getRegistryName().equals((Object)NONE)) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            if (playerData.isAbilityEquipped("kingdomkeys:ability_form_boost")) {
                formDecrease = 0.15;
            }
            if (playerData.getFP() > 0.0) {
                playerData.setFP(playerData.getFP() - formDecrease);
            } else {
                this.endDrive(player);
            }
        }
    }

    public void endDrive(PlayerEntity player) {
        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
        playerData.setActiveDriveForm(NONE.toString());
        player.field_70170_p.func_184133_a(player, player.func_180425_c(), (SoundEvent)ModSounds.unsummon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
        if (!player.field_70170_p.field_72995_K) {
            PacketHandler.syncToAllAround(player, playerData);
        }
    }
}

