/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

public abstract class ItemDropEntity
extends Entity {
    public int delayBeforeCanPickup;
    public int value;
    private PlayerEntity closestPlayer;

    public ItemDropEntity(EntityType<? extends Entity> type, World worldIn, double x, double y, double z, int expValue) {
        this(type, worldIn);
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(this.field_70146_Z.nextDouble() * 360.0);
        this.func_213293_j((this.field_70146_Z.nextDouble() * (double)0.2f - (double)0.1f) * 2.0, this.field_70146_Z.nextDouble() * 0.2 * 2.0, (this.field_70146_Z.nextDouble() * (double)0.2f - (double)0.1f) * 2.0);
        this.value = expValue;
        this.delayBeforeCanPickup = 20;
    }

    public ItemDropEntity(EntityType<ItemDropEntity> type, FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super(type, world);
    }

    public ItemDropEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        Vec3d vec3d;
        double d1;
        super.func_70071_h_();
        if (this.delayBeforeCanPickup > 0) {
            --this.delayBeforeCanPickup;
        }
        this.field_70169_q = this.func_226277_ct_();
        this.field_70167_r = this.func_226278_cu_();
        this.field_70166_s = this.func_226281_cx_();
        if (this.func_208600_a(FluidTags.field_206959_a)) {
            this.applyFloatMotion();
        } else if (!this.func_189652_ae()) {
            this.func_213317_d(this.func_213322_ci().func_72441_c(0.0, -0.03, 0.0));
        }
        if (this.field_70170_p.func_204610_c(new BlockPos((Entity)this)).func_206884_a(FluidTags.field_206960_b)) {
            this.func_213293_j((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f, 0.2f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
            this.func_184185_a(SoundEvents.field_187658_bx, 0.4f, 2.0f + this.field_70146_Z.nextFloat() * 0.4f);
        }
        if (!this.field_70170_p.func_226664_a_(this.func_174813_aQ())) {
            this.func_213282_i(this.func_226277_ct_(), (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.func_226281_cx_());
        }
        double maxDist = 8.0;
        if (this.closestPlayer == null || this.closestPlayer.func_70068_e((Entity)this) > Math.pow(maxDist, 2.0)) {
            this.closestPlayer = this.field_70170_p.func_217362_a((Entity)this, maxDist);
        }
        if (this.closestPlayer != null && this.closestPlayer.func_175149_v()) {
            this.closestPlayer = null;
        }
        if (this.closestPlayer != null && (d1 = (vec3d = new Vec3d(this.closestPlayer.func_226277_ct_() - this.func_226277_ct_(), this.closestPlayer.func_226278_cu_() + (double)this.closestPlayer.func_70047_e() / 2.0 - this.func_226278_cu_(), this.closestPlayer.func_226281_cx_() - this.func_226281_cx_())).func_189985_c()) < Math.pow(maxDist, 2.0)) {
            double d2 = 1.0 - Math.sqrt(d1) / maxDist;
            this.func_213317_d(this.func_213322_ci().func_178787_e(vec3d.func_72432_b().func_186678_a(d2 * d2 * 0.1)));
        }
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        float f = 0.98f;
        if (this.field_70122_E) {
            BlockPos pos = new BlockPos(this.func_226277_ct_(), this.func_226278_cu_() - 1.0, this.func_226281_cx_());
            f = this.field_70170_p.func_180495_p(pos).getSlipperiness((IWorldReader)this.field_70170_p, pos, (Entity)this) * 0.98f;
        }
        this.func_213317_d(this.func_213322_ci().func_216372_d((double)f, 0.98, (double)f));
        if (this.field_70122_E) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, -0.9, 1.0));
        }
    }

    private void applyFloatMotion() {
        Vec3d vec3d = this.func_213322_ci();
        this.func_213293_j(vec3d.field_72450_a * (double)0.99f, Math.min(vec3d.field_72448_b + (double)5.0E-4f, (double)0.06f), vec3d.field_72449_c * (double)0.99f);
    }

    protected void func_70081_e(int amount) {
        this.func_70097_a(DamageSource.field_76372_a, amount);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        this.func_70018_K();
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("Value", this.value);
    }

    public void func_70037_a(CompoundNBT compound) {
        this.value = compound.func_74762_e("Value");
    }

    public void func_70100_b_(PlayerEntity entityIn) {
        if (!this.field_70170_p.field_72995_K && this.delayBeforeCanPickup == 0) {
            this.onPickup(entityIn);
            this.func_184185_a(this.getPickupSound(), 1.0f, 1.0f);
            this.func_70106_y();
            PacketHandler.sendTo(new SCSyncCapabilityPacket(ModCapabilities.getPlayer(entityIn)), (ServerPlayerEntity)entityIn);
        }
    }

    abstract void onPickup(PlayerEntity var1);

    abstract SoundEvent getPickupSound();

    public int getValue() {
        return this.value;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getTextureByXP() {
        if (this.value >= 2477) {
            return 10;
        }
        if (this.value >= 1237) {
            return 9;
        }
        if (this.value >= 617) {
            return 8;
        }
        if (this.value >= 307) {
            return 7;
        }
        if (this.value >= 149) {
            return 6;
        }
        if (this.value >= 73) {
            return 5;
        }
        if (this.value >= 37) {
            return 4;
        }
        if (this.value >= 17) {
            return 3;
        }
        if (this.value >= 7) {
            return 2;
        }
        return this.value >= 3 ? 1 : 0;
    }

    public boolean func_70075_an() {
        return false;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

