/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSOrgPortalTPPacket;

public class OrgPortalEntity
extends Entity
implements IEntityAdditionalSpawnData {
    int maxTicks = 100;
    BlockPos destinationPos;
    int destinationDim;
    boolean shouldTeleport;

    public OrgPortalEntity(EntityType<? extends Entity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public OrgPortalEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_ORG_PORTAL.get(), world);
    }

    public OrgPortalEntity(World world) {
        super((EntityType)ModEntities.TYPE_ORG_PORTAL.get(), world);
        this.field_70156_m = true;
    }

    public OrgPortalEntity(World world, PlayerEntity player, BlockPos spawnPos, BlockPos destinationPos, int destinationDim, boolean shouldTP) {
        super((EntityType)ModEntities.TYPE_ORG_PORTAL.get(), world);
        this.func_70107_b((double)spawnPos.func_177958_n() + 0.5, spawnPos.func_177956_o(), (double)spawnPos.func_177952_p() + 0.5);
        this.destinationPos = destinationPos;
        this.destinationDim = destinationDim;
        this.shouldTeleport = shouldTP;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks) {
            this.func_70106_y();
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197616_i, this.func_226277_ct_() - 1.0 + this.field_70146_Z.nextDouble() * 2.0, this.func_226278_cu_() + this.field_70146_Z.nextDouble() * 4.0, this.func_226281_cx_() - 1.0 + this.field_70146_Z.nextDouble() * 2.0, 0.0, 0.0, 0.0);
        super.func_70071_h_();
    }

    public void func_70100_b_(PlayerEntity player) {
        if (this.shouldTeleport) {
            if (!this.func_70089_S()) {
                return;
            }
            if (player != null && this.destinationPos != null && this.destinationPos.func_177958_n() != 0 && this.destinationPos.func_177956_o() != 0 && this.destinationPos.func_177952_p() != 0) {
                player.func_70107_b((double)this.destinationPos.func_177958_n(), (double)this.destinationPos.func_177956_o(), (double)this.destinationPos.func_177952_p());
                if (player.field_70170_p.field_72995_K) {
                    PacketHandler.sendToServer(new CSOrgPortalTPPacket(this.destinationDim, this.destinationPos.func_177958_n(), this.destinationPos.func_177956_o() + 1, this.destinationPos.func_177952_p()));
                }
            }
        }
        super.func_70100_b_(player);
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
    }

    public void func_70037_a(CompoundNBT compound) {
    }

    protected void func_70088_a() {
    }

    public void writeSpawnData(PacketBuffer buffer) {
        if (this.destinationPos == null) {
            return;
        }
        buffer.func_179255_a(new BlockPos(this.destinationPos.func_177958_n(), this.destinationPos.func_177956_o(), this.destinationPos.func_177952_p()));
        buffer.writeInt(this.destinationDim);
        buffer.writeBoolean(this.shouldTeleport);
    }

    public void readSpawnData(PacketBuffer additionalData) {
        this.destinationPos = additionalData.func_179259_c();
        this.destinationDim = additionalData.readInt();
        this.shouldTeleport = additionalData.readBoolean();
    }
}

