/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCRecalculateEyeHeight;

public class GravityEntity
extends ThrowableEntity {
    int maxTicks = 100;

    public GravityEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public GravityEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_GRAVITY.get(), world);
    }

    public GravityEntity(World world) {
        super((EntityType)ModEntities.TYPE_GRAVITY.get(), world);
        this.field_70156_m = true;
    }

    public GravityEntity(World world, PlayerEntity player) {
        super((EntityType)ModEntities.TYPE_GRAVITY.get(), (LivingEntity)player, world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks) {
            this.func_70106_y();
        }
        if (this.field_70173_aa > 2) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197616_i, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        }
        super.func_70071_h_();
    }

    protected void func_70184_a(RayTraceResult rtRes) {
        int radius = 2;
        double freq = 0.5;
        double X = this.func_226277_ct_();
        double Y = this.func_226278_cu_();
        double Z = this.func_226281_cx_();
        for (double x = X - (double)radius; x <= X + (double)radius; x += freq) {
            for (double y = Y; y <= Y + (double)radius; y += freq) {
                for (double z = Z - (double)radius; z <= Z + (double)radius; z += freq) {
                    if (!((X - x) * (X - x) + (Y - y) * (Y - y) + (Z - z) * (Z - z) <= (double)(radius * radius))) continue;
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197616_i, x, y + 1.0, z, 0.0, 0.0, 0.0);
                }
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_72839_b((Entity)this.func_85052_h(), this.func_174813_aQ().func_72314_b(2.0, 2.0, 2.0).func_72317_d(-1.0, -1.0, -1.0));
            Party casterParty = ModCapabilities.getWorld(this.field_70170_p).getPartyFromMember(this.func_85052_h().func_110124_au());
            if (casterParty != null) {
                for (Party.Member m : casterParty.getMembers()) {
                    list.remove(this.field_70170_p.func_217371_b(m.getUUID()));
                }
            } else {
                list.remove(this.func_85052_h());
            }
            if (!list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity e = (Entity)list.get(i);
                    if (!(e instanceof LivingEntity)) continue;
                    IGlobalCapabilities globalData = ModCapabilities.getGlobal((LivingEntity)e);
                    globalData.setFlatTicks(100);
                    if (e instanceof LivingEntity) {
                        PacketHandler.syncToAllAround((LivingEntity)e, globalData);
                    }
                    if (e instanceof ServerPlayerEntity) {
                        PacketHandler.sendTo(new SCRecalculateEyeHeight(), (ServerPlayerEntity)e);
                    }
                    e.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), 1.0f);
                }
            }
            this.func_70106_y();
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
    }

    public void func_70037_a(CompoundNBT compound) {
    }

    protected void func_70088_a() {
    }
}

