/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.WitchEntity;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.passive.PigEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SSpawnGlobalEntityPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class ThunderBoltEntity
extends ThrowableEntity {
    private int lightningState;
    public long boltVertex;
    private int boltLivingTime;
    private boolean effectOnly;
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(ThunderBoltEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public ThunderBoltEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public ThunderBoltEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_THUNDERBOLT.get(), world);
    }

    public ThunderBoltEntity(World world) {
        super((EntityType)ModEntities.TYPE_THUNDERBOLT.get(), world);
        this.field_70156_m = true;
    }

    public ThunderBoltEntity(World world, PlayerEntity player, double x, double y, double z) {
        super((EntityType)ModEntities.TYPE_THUNDERBOLT.get(), (LivingEntity)player, world);
        this.setCaster(player.func_110124_au());
        this.field_70158_ak = true;
        this.func_70012_b(x, y, z, 0.0f, 0.0f);
        this.lightningState = 2;
        this.boltVertex = this.field_70146_Z.nextLong();
        this.boltLivingTime = this.field_70146_Z.nextInt(3) + 1;
        this.effectOnly = false;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.WEATHER;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        --this.lightningState;
        if (this.lightningState < 0) {
            if (this.boltLivingTime == 0) {
                this.func_70106_y();
            } else if (this.lightningState < -this.field_70146_Z.nextInt(10)) {
                --this.boltLivingTime;
                this.lightningState = 1;
                this.boltVertex = this.field_70146_Z.nextLong();
            }
        }
        if (this.lightningState >= 0) {
            if (this.field_70170_p.field_72995_K) {
                this.field_70170_p.func_225605_c_(2);
            } else if (!this.effectOnly) {
                double d0 = 3.0;
                List list = this.field_70170_p.func_175674_a((Entity)this, new AxisAlignedBB(this.func_226277_ct_() - 2.0, this.func_226278_cu_() - 2.0, this.func_226281_cx_() - 2.0, this.func_226277_ct_() + 2.0, this.func_226278_cu_() + 6.0 + 2.0, this.func_226281_cx_() + 2.0), Entity::func_70089_S);
                Party casterParty = ModCapabilities.getWorld(this.field_70170_p).getPartyFromMember(this.func_85052_h().func_110124_au());
                if (casterParty != null) {
                    for (Party.Member m : casterParty.getMembers()) {
                        list.remove(this.field_70170_p.func_217371_b(m.getUUID()));
                    }
                } else {
                    list.remove(this.func_85052_h());
                }
                for (Entity entity : list) {
                    float dmg = this.func_85052_h() instanceof PlayerEntity ? DamageCalculation.getMagicDamage((PlayerEntity)this.func_85052_h(), 1) : 2.0f;
                    entity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), dmg);
                    if (entity instanceof PigEntity) {
                        ZombiePigmanEntity zombiepigmanentity = (ZombiePigmanEntity)EntityType.field_200785_Y.func_200721_a(entity.field_70170_p);
                        zombiepigmanentity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)Items.field_151010_B));
                        zombiepigmanentity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
                        zombiepigmanentity.func_94061_f(((PigEntity)entity).func_175446_cd());
                        if (this.func_145818_k_()) {
                            zombiepigmanentity.func_200203_b(entity.func_200201_e());
                            zombiepigmanentity.func_174805_g(entity.func_174833_aM());
                        }
                        entity.field_70170_p.func_217376_c((Entity)zombiepigmanentity);
                        entity.func_70106_y();
                    }
                    if (entity instanceof VillagerEntity) {
                        WitchEntity witchentity = (WitchEntity)EntityType.field_200759_ay.func_200721_a(entity.field_70170_p);
                        witchentity.func_70012_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70177_z, entity.field_70125_A);
                        witchentity.func_213386_a((IWorld)entity.field_70170_p, entity.field_70170_p.func_175649_E(new BlockPos((Entity)witchentity)), SpawnReason.CONVERSION, (ILivingEntityData)null, (CompoundNBT)null);
                        witchentity.func_94061_f(((VillagerEntity)entity).func_175446_cd());
                        if (this.func_145818_k_()) {
                            witchentity.func_200203_b(entity.func_200201_e());
                            witchentity.func_174805_g(entity.func_174833_aM());
                        }
                        entity.field_70170_p.func_217376_c((Entity)witchentity);
                        entity.func_70106_y();
                    }
                    if (!(entity instanceof CreeperEntity)) continue;
                    LightningBoltEntity lightningBoltEntity = new LightningBoltEntity(this.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), true);
                    lightningBoltEntity.func_204809_d(this.getCaster() instanceof ServerPlayerEntity ? (ServerPlayerEntity)this.getCaster() : null);
                    entity.func_70077_a(lightningBoltEntity);
                }
                if (this.getCaster() != null) {
                    CriteriaTriggers.field_204812_E.func_204814_a((ServerPlayerEntity)this.getCaster(), (Collection)list);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = 64.0 * ThunderBoltEntity.func_184183_bd();
        return distance < d0 * d0;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_70180_af.func_187225_a(OWNER) != null) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
    }

    public PlayerEntity getCaster() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, Optional.of(new UUID(0L, 0L)));
    }

    public IPacket<?> func_213297_N() {
        return new SSpawnGlobalEntityPacket((Entity)this);
    }

    protected void func_70184_a(RayTraceResult result) {
    }
}

