/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.magic.ThunderBoltEntity;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class ThunderEntity
extends ThrowableEntity {
    int maxTicks = 20;
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(ThunderEntity.class, (IDataSerializer)DataSerializers.field_187203_m);

    public ThunderEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public ThunderEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_THUNDER.get(), world);
    }

    public ThunderEntity(World world) {
        super((EntityType)ModEntities.TYPE_THUNDER.get(), world);
        this.field_70156_m = true;
    }

    public ThunderEntity(World world, PlayerEntity player) {
        super((EntityType)ModEntities.TYPE_THUNDER.get(), (LivingEntity)player, world);
        this.setCaster(player.func_110124_au());
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
        if (this.field_70180_af.func_187225_a(OWNER) != null) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
    }

    public PlayerEntity getCaster() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, Optional.of(new UUID(0L, 0L)));
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks) {
            this.func_70106_y();
        }
        if (this.getCaster() == null) {
            this.func_70106_y();
            return;
        }
        if (!this.field_70170_p.field_72995_K && this.getCaster() != null && this.field_70173_aa % 5 == 0) {
            double radius = 2.0;
            List list = this.field_70170_p.func_175674_a((Entity)this.getCaster(), new AxisAlignedBB(this.func_226277_ct_() - radius, this.func_226278_cu_() - radius, this.func_226281_cx_() - radius, this.func_226277_ct_() + radius, this.func_226278_cu_() + 6.0 + radius, this.func_226281_cx_() + radius), Entity::func_70089_S);
            Party casterParty = ModCapabilities.getWorld(this.field_70170_p).getPartyFromMember(this.func_85052_h().func_110124_au());
            if (casterParty != null) {
                for (Party.Member m : casterParty.getMembers()) {
                    list.remove(this.field_70170_p.func_217371_b(m.getUUID()));
                }
            } else {
                list.remove(this.func_85052_h());
            }
            if (!list.isEmpty() && list.get(0) != this) {
                for (int i = 0; i < list.size(); ++i) {
                    Entity e = (Entity)list.get(i);
                    if (!(e instanceof LivingEntity)) continue;
                    ThunderBoltEntity shot = new ThunderBoltEntity(this.getCaster().field_70170_p, this.getCaster(), e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_());
                    shot.setCaster(this.getCaster().func_110124_au());
                    this.field_70170_p.func_217376_c((Entity)shot);
                    LightningBoltEntity lightning = new LightningBoltEntity(this.getCaster().field_70170_p, e.func_226277_ct_(), e.func_226278_cu_(), e.func_226281_cx_(), true);
                    lightning.func_204809_d(this.getCaster() instanceof ServerPlayerEntity ? (ServerPlayerEntity)this.getCaster() : null);
                    ((ServerWorld)this.getCaster().field_70170_p).func_217468_a(lightning);
                }
            } else {
                int x = (int)this.getCaster().func_226277_ct_();
                int z = (int)this.getCaster().func_226281_cx_();
                int posX = x + this.getCaster().field_70170_p.field_73012_v.nextInt(6) - 3;
                int posZ = z + this.getCaster().field_70170_p.field_73012_v.nextInt(6) - 3;
                ThunderBoltEntity shot = new ThunderBoltEntity(this.getCaster().field_70170_p, this.getCaster(), posX, this.getCaster().field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, posX, posZ), posZ);
                shot.setCaster(this.getCaster().func_110124_au());
                this.field_70170_p.func_217376_c((Entity)shot);
                LightningBoltEntity lightning = new LightningBoltEntity(this.getCaster().field_70170_p, (double)posX, (double)this.getCaster().field_70170_p.func_201676_a(Heightmap.Type.WORLD_SURFACE, posX, posZ), (double)posZ, true);
                lightning.func_204809_d(this.getCaster() instanceof ServerPlayerEntity ? (ServerPlayerEntity)this.getCaster() : null);
                ((ServerWorld)this.getCaster().field_70170_p).func_217468_a(lightning);
            }
        }
        super.func_70071_h_();
    }

    protected void func_70184_a(RayTraceResult result) {
    }
}

