/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.magic;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.magic.MagnetEntity;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;

public class WaterEntity
extends ThrowableEntity {
    int maxTicks = 100;
    PlayerEntity player;
    String caster;
    double a = 0.0;
    private static final DataParameter<String> CASTER = EntityDataManager.func_187226_a(MagnetEntity.class, (IDataSerializer)DataSerializers.field_187194_d);

    public WaterEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public WaterEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_WATER.get(), world);
    }

    public WaterEntity(World world) {
        super((EntityType)ModEntities.TYPE_WATER.get(), world);
        this.field_70156_m = true;
    }

    public WaterEntity(World world, PlayerEntity player) {
        super((EntityType)ModEntities.TYPE_WATER.get(), (LivingEntity)player, world);
        this.player = player;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        for (PlayerEntity playerFromList : this.field_70170_p.func_217369_A()) {
            if (!playerFromList.func_145748_c_().func_150254_d().equals(this.getCaster())) continue;
            this.player = playerFromList;
            break;
        }
        if (this.field_70173_aa > this.maxTicks || this.player == null) {
            this.func_70106_y();
        }
        if (this.field_70173_aa <= 1) {
            this.func_213293_j(0.0, 0.0, 0.0);
        } else if (this.field_70173_aa < 50) {
            this.func_70107_b(this.player.func_226277_ct_(), this.func_226278_cu_(), this.player.func_226281_cx_());
            double r = 1.0;
            double cx = this.func_226277_ct_();
            double cy = this.func_226278_cu_();
            double cz = this.func_226281_cx_();
            this.a += 30.0;
            double x = cx + r * Math.cos(Math.toRadians(this.a));
            double z = cz + r * Math.sin(Math.toRadians(this.a));
            double x2 = cx + r * Math.cos(Math.toRadians(-this.a));
            double z2 = cz + r * Math.sin(Math.toRadians(-this.a));
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197618_k, x, cy + 0.5 - this.a / 1080.0, z, 0.0, 0.0, 0.0);
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_206864_X, x2, cy + 0.5 - this.a / 1080.0, z2, 0.0, 0.0, 0.0);
            double radius = 2.0;
            List list = this.field_70170_p.func_175674_a((Entity)this.player, new AxisAlignedBB(this.func_226277_ct_() - radius, this.func_226278_cu_() - radius, this.func_226281_cx_() - radius, this.func_226277_ct_() + radius, this.func_226278_cu_() + 6.0 + radius, this.func_226281_cx_() + radius), Entity::func_70089_S);
            if (!list.isEmpty() && list.get(0) != this) {
                float dmg = DamageCalculation.getMagicDamage((PlayerEntity)this.func_85052_h(), 1);
                for (int i = 0; i < list.size(); ++i) {
                    Entity e = (Entity)list.get(i);
                    if (!(e instanceof LivingEntity)) continue;
                    e.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)((PlayerEntity)this.func_85052_h())), dmg);
                }
            }
        } else {
            this.func_184538_a((Entity)this.player, this.player.field_70125_A, this.player.field_70177_z, 0.0f, 1.0f, 0.0f);
            this.field_70133_I = true;
            for (double px = -0.3; px < 0.3; px += 0.1) {
                for (double pz = -0.3; pz < 0.3; pz += 0.1) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_206864_X, this.func_226277_ct_() + px, this.func_226278_cu_(), this.func_226281_cx_() + pz, 0.0, 0.0, 0.0);
                }
            }
        }
        super.func_70071_h_();
    }

    protected void func_70184_a(RayTraceResult rtRes) {
        if (!this.field_70170_p.field_72995_K) {
            EntityRayTraceResult ertResult = null;
            BlockRayTraceResult brtResult = null;
            if (rtRes instanceof EntityRayTraceResult) {
                ertResult = (EntityRayTraceResult)rtRes;
            }
            if (rtRes instanceof BlockRayTraceResult) {
                brtResult = (BlockRayTraceResult)rtRes;
            }
            if (ertResult != null && ertResult.func_216348_a() != null && ertResult.func_216348_a() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)ertResult.func_216348_a();
                if (target != this.func_85052_h()) {
                    float dmg = DamageCalculation.getMagicDamage((PlayerEntity)this.func_85052_h(), 1);
                    target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)((PlayerEntity)this.func_85052_h())), dmg);
                    this.func_70106_y();
                }
            } else {
                this.func_70106_y();
            }
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
        compound.func_74778_a("caster", this.getCaster());
    }

    public void func_70037_a(CompoundNBT compound) {
        this.setCaster(compound.func_74779_i("caster"));
    }

    public String getCaster() {
        return this.caster;
    }

    public void setCaster(String name) {
        this.field_70180_af.func_187227_b(CASTER, (Object)name);
        this.caster = name;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (key.equals(CASTER)) {
            this.caster = this.getCasterDataManager();
        }
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(CASTER, (Object)"");
    }

    public String getCasterDataManager() {
        return (String)this.field_70180_af.func_187225_a(CASTER);
    }
}

