/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;

public class DarkballEntity
extends MonsterEntity
implements IKHMob {
    private SpecialAttack currentAttack;
    private SpecialAttack previousAttack;
    protected final int DAMAGE_HIT = 0;
    protected final int DAMAGE_CHARGE = 6;
    protected final int DAMAGE_BERSERK = 5;
    protected final int DAMAGE_DARKCLOUD = 4;

    public DarkballEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public DarkballEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_DARKBALL.get(), world);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return ModCapabilities.getWorld((World)worldIn).getHeartlessSpawnLevel() > 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(0, (Goal)new DarkCloudGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new ChargeGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BerserkGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.22);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(90.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    public int func_70641_bl() {
        return 4;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EntityHelper.STATE, (Object)0);
    }

    @Override
    public EntityHelper.MobType getMobType() {
        return EntityHelper.MobType.HEARTLESS_PUREBLOOD;
    }

    public boolean func_145773_az() {
        return true;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_70619_bc() {
        LivingEntity target = this.func_70638_az();
        if (EntityHelper.getState((Entity)this) == 3) {
            this.func_184224_h(true);
        } else {
            this.func_184224_h(false);
        }
        super.func_70619_bc();
    }

    public boolean func_70652_k(Entity ent) {
        int i = EntityHelper.getState((Entity)this) == 0 ? 0 : (EntityHelper.getState((Entity)this) == 1 ? 6 : (EntityHelper.getState((Entity)this) == 2 ? 5 : (EntityHelper.getState((Entity)this) == 3 ? 0 : 0)));
        return ent.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)i);
    }

    public void setCurrentAttackState(SpecialAttack state) {
        this.currentAttack = state;
    }

    public SpecialAttack getCurrentAttackState() {
        return this.currentAttack;
    }

    public void setPreviousAttackState(SpecialAttack state) {
        this.previousAttack = state;
    }

    public SpecialAttack getPreviousAttackState() {
        return this.previousAttack;
    }

    class ChargeGoal
    extends Goal {
        private DarkballEntity theEntity;
        private boolean canUseAttack = true;
        private int attackTimer = 50;
        private int whileAttackTimer;
        private double[] posToCharge;
        private float initialHealth;

        public ChargeGoal(DarkballEntity e) {
            this.theEntity = e;
        }

        public boolean func_75250_a() {
            if (this.theEntity.func_70638_az() != null && this.theEntity.getCurrentAttackState() == null && this.theEntity.func_70068_e((Entity)this.theEntity.func_70638_az()) > 4.0) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        --this.attackTimer;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.CHARGE) {
                return this.theEntity.field_70146_Z.nextFloat() <= 0.1f;
            }
            return true;
        }

        public boolean func_75253_b() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                EntityHelper.setState((Entity)this.theEntity, 0);
            }
            return flag;
        }

        public void func_75249_e() {
            this.canUseAttack = true;
            this.attackTimer = 50;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.CHARGE);
            EntityHelper.setState((Entity)this.theEntity, 0);
            LivingEntity target = this.theEntity.func_70638_az();
            this.initialHealth = this.theEntity.func_110143_aJ();
            if (target != null) {
                this.posToCharge = new double[]{target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_()};
            }
        }

        public void func_75246_d() {
            if (this.theEntity.func_70638_az() != null && this.canUseAttack) {
                ++this.whileAttackTimer;
                EntityHelper.setState((Entity)this.theEntity, 1);
                LivingEntity target = this.theEntity.func_70638_az();
                this.theEntity.func_70661_as().func_75492_a(this.posToCharge[0], this.posToCharge[1], this.posToCharge[2], 3.0);
                if (this.whileAttackTimer > 100) {
                    this.canUseAttack = false;
                }
                if (this.theEntity.func_180425_c().func_177958_n() == (int)this.posToCharge[0] && this.theEntity.func_180425_c().func_177956_o() == (int)this.posToCharge[1] && this.theEntity.func_180425_c().func_177952_p() == (int)this.posToCharge[2]) {
                    this.canUseAttack = false;
                }
                if (this.theEntity.func_70068_e((Entity)this.theEntity.func_70638_az()) < 3.0) {
                    this.canUseAttack = false;
                }
                if (this.initialHealth > this.theEntity.func_110143_aJ()) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    class BerserkGoal
    extends Goal {
        private DarkballEntity theEntity;
        private boolean canUseAttack = true;
        private int attackTimer = 70;
        private int whileAttackTimer;
        private double[] pivotPosToBerserk;

        public BerserkGoal(DarkballEntity e) {
            this.theEntity = e;
        }

        public boolean func_75250_a() {
            if (this.theEntity.func_70638_az() != null && this.theEntity.getCurrentAttackState() == null && this.theEntity.func_70068_e((Entity)this.theEntity.func_70638_az()) < 15.0) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        --this.attackTimer;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.BERSERK) {
                return this.theEntity.field_70146_Z.nextFloat() <= 0.5f;
            }
            return true;
        }

        public boolean func_75253_b() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                EntityHelper.setState((Entity)this.theEntity, 0);
            }
            return flag;
        }

        public void func_75249_e() {
            this.canUseAttack = true;
            this.attackTimer = 70;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.BERSERK);
            EntityHelper.setState((Entity)this.theEntity, 0);
            this.pivotPosToBerserk = new double[]{this.theEntity.func_180425_c().func_177958_n(), this.theEntity.func_180425_c().func_177956_o(), this.theEntity.func_180425_c().func_177952_p()};
        }

        public void func_75246_d() {
            if (this.theEntity.func_70638_az() != null && this.canUseAttack) {
                ++this.whileAttackTimer;
                EntityHelper.setState((Entity)this.theEntity, 2);
                for (int i = 0; i < 20; ++i) {
                    double offsetX = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    double offsetY = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    double offsetZ = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    LivingEntity target = this.theEntity.func_70638_az();
                    this.theEntity.func_70661_as().func_75492_a(this.pivotPosToBerserk[0] + offsetX, this.pivotPosToBerserk[1] + offsetY, this.pivotPosToBerserk[2] + offsetZ, 5.0);
                }
                if (this.whileAttackTimer > 40) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    class DarkCloudGoal
    extends Goal {
        private DarkballEntity theEntity;
        private boolean canUseAttack = true;
        private int attackTimer = 50;
        private int whileAttackTimer;
        private double[] pivotPosToMove;

        public DarkCloudGoal(DarkballEntity e) {
            this.theEntity = e;
        }

        public boolean func_75250_a() {
            if (this.theEntity.func_70638_az() != null && this.theEntity.getCurrentAttackState() == null) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        --this.attackTimer;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.DARKCLOUD) {
                return this.theEntity.field_70146_Z.nextFloat() <= 0.3f;
            }
            return true;
        }

        public boolean func_75253_b() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                EntityHelper.setState((Entity)this.theEntity, 0);
                for (Entity entity : EntityHelper.getEntitiesNear((Entity)this.theEntity, 1.4)) {
                    DamageSource damageSource = DamageSource.func_76358_a((LivingEntity)this.theEntity);
                    this.theEntity.getClass();
                    entity.func_70097_a(damageSource, 4.0f);
                }
            }
            return flag;
        }

        public void func_75249_e() {
            this.canUseAttack = true;
            this.attackTimer = 50;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.DARKCLOUD);
            EntityHelper.setState((Entity)this.theEntity, 0);
        }

        public void func_75246_d() {
            if (this.theEntity.func_70638_az() != null && this.canUseAttack) {
                ++this.whileAttackTimer;
                EntityHelper.setState((Entity)this.theEntity, 3);
                LivingEntity target = this.theEntity.func_70638_az();
                for (int i = 0; i < 20; ++i) {
                    double d = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    double offsetY = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    double offsetZ = (double)new Random().nextInt(5) + 1.0 + 5.0 - 5.0;
                    this.theEntity.func_70661_as().func_75492_a((double)target.func_180425_c().func_177958_n(), (double)target.func_180425_c().func_177956_o(), (double)target.func_180425_c().func_177952_p(), 1.5);
                }
                for (Entity entity : EntityHelper.getEntitiesNear((Entity)this.theEntity, 1.0)) {
                    if (entity != target) continue;
                    this.canUseAttack = false;
                }
                if (this.whileAttackTimer > 80) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    static enum SpecialAttack {
        CHARGE,
        BERSERK,
        DARKCLOUD;

    }
}

