/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.FMLPlayMessages;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.mob.BaseElementalMusicalHeartlessEntity;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;

public class GreenRequiemEntity
extends BaseElementalMusicalHeartlessEntity {
    public GreenRequiemEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public GreenRequiemEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType<? extends MonsterEntity>)((EntityType)ModEntities.TYPE_GREEN_REQUIEM.get()), spawnEntity, world);
    }

    @Override
    protected Goal goalToUse() {
        return new GreenRequiemGoal(this);
    }

    @Override
    protected double getMaxHP() {
        return 40.0;
    }

    @Override
    public BaseElementalMusicalHeartlessEntity.Element getElementToUse() {
        return BaseElementalMusicalHeartlessEntity.Element.BLIZZARD;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getTexture() {
        return new ResourceLocation("kingdomkeys", "textures/entity/mob/green_requiem.png");
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        float multiplier = 1.0f;
        return super.func_70097_a(source, amount * multiplier);
    }

    class GreenRequiemGoal
    extends Goal {
        private GreenRequiemEntity theEntity;
        private boolean canUseAttack = true;
        private int attackTimer = 5;
        private int whileAttackTimer;
        private float initialHealth;

        public GreenRequiemGoal(GreenRequiemEntity e) {
            this.theEntity = e;
        }

        public boolean func_75250_a() {
            if (this.theEntity.func_70638_az() != null) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        --this.attackTimer;
                        return false;
                    }
                    return true;
                }
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            boolean flag = this.canUseAttack;
            return flag;
        }

        public void func_75249_e() {
            this.canUseAttack = true;
            this.attackTimer = 25 + GreenRequiemEntity.this.field_70170_p.field_73012_v.nextInt(5);
            EntityHelper.setState((Entity)this.theEntity, 0);
            this.theEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
            this.whileAttackTimer = 0;
            this.initialHealth = this.theEntity.func_110143_aJ();
        }

        public void func_75246_d() {
            if (this.theEntity.func_70638_az() != null && this.canUseAttack) {
                ++this.whileAttackTimer;
                LivingEntity target = this.theEntity.func_70638_az();
                if (EntityHelper.getState((Entity)this.theEntity) == 0) {
                    this.theEntity.func_70671_ap().func_75651_a((Entity)target, 30.0f, 30.0f);
                    if ((double)GreenRequiemEntity.this.field_70170_p.field_73012_v.nextInt(100) + GreenRequiemEntity.this.field_70170_p.field_73012_v.nextDouble() <= 20.0) {
                        EntityHelper.setState((Entity)this.theEntity, 1);
                        this.theEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
                        if (EntityHelper.getEntitiesNear((Entity)this.theEntity, 10.0).size() > 0) {
                            for (LivingEntity heartless : EntityHelper.getEntitiesNear((Entity)this.theEntity, 10.0)) {
                                if (!(heartless instanceof IKHMob) || ((IKHMob)heartless).getMobType() == EntityHelper.MobType.NPC) continue;
                                if (heartless.func_110143_aJ() < heartless.func_110138_aP() - 10.0f) {
                                    heartless.func_70606_j(heartless.func_110143_aJ() + 10.0f);
                                } else if (heartless.func_110143_aJ() > heartless.func_110138_aP() - 10.0f) {
                                    heartless.func_70606_j(heartless.func_110138_aP());
                                }
                                if (this.theEntity.field_70170_p.field_72995_K) continue;
                                this.theEntity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, heartless.func_226277_ct_(), heartless.func_226278_cu_(), heartless.func_226281_cx_(), 0.0, 1.0, 0.0);
                                this.theEntity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, heartless.func_226277_ct_(), heartless.func_226278_cu_(), heartless.func_226281_cx_(), 0.0, 1.0, 0.0);
                                this.theEntity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, heartless.func_226277_ct_(), heartless.func_226278_cu_(), heartless.func_226281_cx_(), 0.0, 1.0, 0.0);
                                this.theEntity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, heartless.func_226277_ct_() + 0.3, heartless.func_226278_cu_(), heartless.func_226281_cx_(), 0.0, 1.0, 0.0);
                                this.theEntity.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, heartless.func_226277_ct_() - 0.3, heartless.func_226278_cu_(), heartless.func_226281_cx_(), 0.0, 1.0, 0.0);
                            }
                        }
                    }
                }
                if (EntityHelper.getState((Entity)this.theEntity) == 1 && this.whileAttackTimer > 50) {
                    this.canUseAttack = false;
                    EntityHelper.setState((Entity)this.theEntity, 0);
                    this.theEntity.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
                }
            }
        }
    }
}

