/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.mob;

import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.EntityHelper;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.mob.IKHMob;

public class LargeBodyEntity
extends MonsterEntity
implements IKHMob {
    private SpecialAttack currentAttack;
    private SpecialAttack previousAttack;
    private int timeForNextAI = 80;
    private boolean isAngry = false;
    protected final int DAMAGE_HIT = 0;
    protected final int DAMAGE_CHARGE = 6;
    protected final int DAMAGE_MOWDOWN = 5;
    protected final int DAMAGE_SHOCKWAVE = 4;

    public LargeBodyEntity(EntityType<? extends MonsterEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public LargeBodyEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_LARGE_BODY.get(), world);
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return ModCapabilities.getWorld((World)worldIn).getHeartlessSpawnLevel() > 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.0, false));
        this.field_70714_bg.func_75776_a(0, (Goal)new ChargeGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MowdownGoal(this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(0, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(35.0);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(1.0);
    }

    @Override
    public EntityHelper.MobType getMobType() {
        return EntityHelper.MobType.HEARTLESS_EMBLEM;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        int rotation = MathHelper.func_76128_c((double)((double)(this.func_70079_am() * 4.0f / 360.0f) + 0.5)) & 3;
        if (this.func_110143_aJ() < this.func_110138_aP() / 3.0f) {
            this.isAngry = true;
        }
        if (this.getCurrentAttackState() == SpecialAttack.MOWDOWN) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
        }
        if (this.getPreviousAttackState() != SpecialAttack.WAIT && this.timeForNextAI > 0) {
            this.setCurrentAttackState(SpecialAttack.WAIT);
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.0);
            this.func_70624_b(null);
            EntityHelper.setState((Entity)this, 10);
            --this.timeForNextAI;
        } else if (this.timeForNextAI <= 0) {
            this.setPreviousAttackState(SpecialAttack.WAIT);
            this.setCurrentAttackState(null);
            if (this.isAngry) {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.2);
            } else {
                this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.15);
            }
            EntityHelper.setState((Entity)this, 0);
            this.func_70624_b(null);
            this.timeForNextAI = 80;
        }
        if (this.isAngry) {
            // empty if block
        }
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (source.func_76346_g() instanceof LivingEntity) {
            Entity attacker = source.func_76364_f();
            double d1 = attacker.func_226277_ct_() - this.func_226277_ct_();
            double d0 = attacker.func_226281_cx_() - this.func_226281_cx_();
            float attackYaw = (float)Math.toDegrees(MathHelper.func_181159_b((double)d0, (double)d1));
            float diff = MathHelper.func_76142_g((float)(attackYaw - this.field_70177_z));
            if (diff > 30.0f && diff < 150.0f) {
                if (attacker instanceof LivingEntity) {
                    ((LivingEntity)attacker).func_70653_a(attacker, 0.8f, -d1, -d0);
                    attacker.func_213293_j(attacker.func_213322_ci().field_72450_a, 0.5, attacker.func_213322_ci().field_72449_c);
                }
                return false;
            }
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity ent) {
        int i = 0;
        if (EntityHelper.getState((Entity)this) == 0) {
            i = 0;
        } else if (EntityHelper.getState((Entity)this) == 1) {
            i = 6;
        } else if (EntityHelper.getState((Entity)this) == 2) {
            i = 5;
        } else if (EntityHelper.getState((Entity)this) == 3) {
            i = 4;
        }
        if (this.isAngry) {
            i = (int)((float)i * 1.5f);
        }
        return ent.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)i);
    }

    public World getWorld() {
        return this.field_70170_p;
    }

    public void setCurrentAttackState(SpecialAttack state) {
        this.currentAttack = state;
    }

    public SpecialAttack getCurrentAttackState() {
        return this.currentAttack;
    }

    public void setPreviousAttackState(SpecialAttack state) {
        this.previousAttack = state;
    }

    public SpecialAttack getPreviousAttackState() {
        return this.previousAttack;
    }

    public float func_213355_cm() {
        return 2.0f;
    }

    public int func_70641_bl() {
        return 4;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(EntityHelper.STATE, (Object)0);
    }

    class ChargeGoal
    extends Goal {
        private LargeBodyEntity theEntity;
        private boolean canUseAttack = true;
        private final int ATTACK_MAX_TIMER = 70;
        private int attackTimer = 70;
        private int whileAttackTimer;
        private double[] posToCharge;
        private float initialHealth;

        public ChargeGoal(LargeBodyEntity e) {
            this.theEntity = e;
        }

        public boolean func_75250_a() {
            if (this.theEntity.func_70638_az() != null && this.theEntity.getCurrentAttackState() == null && this.theEntity.func_70068_e((Entity)this.theEntity.func_70638_az()) > 4.0) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        --this.attackTimer;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.CHARGE) {
                return this.theEntity.field_70146_Z.nextFloat() <= 0.2f;
            }
            return true;
        }

        public boolean func_75253_b() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                EntityHelper.setState((Entity)this.theEntity, 0);
            }
            return flag;
        }

        public void func_75249_e() {
            this.canUseAttack = true;
            this.attackTimer = 70;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.CHARGE);
            EntityHelper.setState((Entity)this.theEntity, 1);
            LivingEntity target = this.theEntity.func_70638_az();
            this.initialHealth = this.theEntity.func_110143_aJ();
            if (target != null) {
                this.posToCharge = new double[]{target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_()};
            }
        }

        public void func_75246_d() {
            if (this.theEntity.func_70638_az() != null && this.canUseAttack) {
                ++this.whileAttackTimer;
                this.theEntity.func_70661_as().func_75492_a(this.posToCharge[0], this.posToCharge[1], this.posToCharge[2], this.theEntity.isAngry ? 2.3 : 2.0);
                if (this.whileAttackTimer > 70) {
                    this.canUseAttack = false;
                }
                if (this.theEntity.func_180425_c().func_177958_n() == (int)this.posToCharge[0] && this.theEntity.func_180425_c().func_177956_o() == (int)this.posToCharge[1] && this.theEntity.func_180425_c().func_177952_p() == (int)this.posToCharge[2] || this.theEntity.func_180425_c().func_177958_n() == (int)this.posToCharge[0] + 1 && this.theEntity.func_180425_c().func_177956_o() == (int)this.posToCharge[1] && this.theEntity.func_180425_c().func_177952_p() == (int)this.posToCharge[2] + 1 || this.theEntity.func_180425_c().func_177958_n() == (int)this.posToCharge[0] - 1 && this.theEntity.func_180425_c().func_177956_o() == (int)this.posToCharge[1] && this.theEntity.func_180425_c().func_177952_p() == (int)this.posToCharge[2] - 1) {
                    this.canUseAttack = false;
                }
                if (this.theEntity.func_70068_e((Entity)this.theEntity.func_70638_az()) < 2.0) {
                    this.canUseAttack = false;
                }
                if (this.initialHealth > this.theEntity.func_110143_aJ()) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    class MowdownGoal
    extends Goal {
        private LargeBodyEntity theEntity;
        private boolean canUseAttack = true;
        private final int ATTACK_MAX_TIMER = 50;
        private int attackTimer = 50;
        private int whileAttackTimer;
        private double[] posToCharge;
        private float initialHealth;

        public MowdownGoal(LargeBodyEntity e) {
            this.theEntity = e;
        }

        public boolean func_75250_a() {
            if (this.theEntity.func_70638_az() != null && this.theEntity.getCurrentAttackState() == null && this.theEntity.func_70032_d((Entity)this.theEntity.func_70638_az()) < 5.0f) {
                if (!this.canUseAttack) {
                    if (this.attackTimer > 0) {
                        --this.attackTimer;
                        return false;
                    }
                    return this.prevAttackCalc();
                }
                return this.prevAttackCalc();
            }
            return false;
        }

        public boolean prevAttackCalc() {
            if (this.theEntity.getPreviousAttackState() == SpecialAttack.MOWDOWN) {
                return this.theEntity.field_70146_Z.nextFloat() <= 0.5f;
            }
            return true;
        }

        public boolean func_75253_b() {
            boolean flag = this.canUseAttack;
            if (!flag) {
                this.theEntity.setPreviousAttackState(this.theEntity.getCurrentAttackState());
                this.theEntity.setCurrentAttackState(null);
                EntityHelper.setState((Entity)this.theEntity, 0);
            }
            return flag;
        }

        public void func_75249_e() {
            this.canUseAttack = true;
            this.attackTimer = 50;
            this.whileAttackTimer = 0;
            this.theEntity.setCurrentAttackState(SpecialAttack.MOWDOWN);
            EntityHelper.setState((Entity)this.theEntity, 2);
            this.initialHealth = this.theEntity.func_110143_aJ();
        }

        public void func_75246_d() {
            if (this.theEntity.func_70638_az() != null && this.canUseAttack) {
                ++this.whileAttackTimer;
                for (Entity entity : EntityHelper.getEntitiesNear((Entity)this.theEntity, 0.2)) {
                    float f;
                    DamageSource damageSource = DamageSource.func_76358_a((LivingEntity)this.theEntity);
                    if (this.theEntity.isAngry) {
                        this.theEntity.getClass();
                        f = 5.0f * 1.5f;
                    } else {
                        this.theEntity.getClass();
                        f = 5.0f;
                    }
                    entity.func_70097_a(damageSource, f);
                }
                if (this.whileAttackTimer > 40) {
                    this.canUseAttack = false;
                }
                if (this.initialHealth > this.theEntity.func_110143_aJ()) {
                    this.canUseAttack = false;
                }
            }
        }
    }

    static enum SpecialAttack {
        WAIT,
        CHARGE,
        MOWDOWN,
        SHOCKWAVE;

    }
}

