/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;

public class ArrowgunShotEntity
extends ThrowableEntity {
    int maxTicks = 120;

    public ArrowgunShotEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public ArrowgunShotEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_ARROWGUN_SHOT.get(), world);
    }

    public ArrowgunShotEntity(World world) {
        super((EntityType)ModEntities.TYPE_ARROWGUN_SHOT.get(), world);
        this.field_70156_m = true;
    }

    public ArrowgunShotEntity(World world, LivingEntity player) {
        super((EntityType)ModEntities.TYPE_ARROWGUN_SHOT.get(), player, world);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks) {
            this.func_70106_y();
        }
        super.func_70071_h_();
    }

    protected void func_70184_a(RayTraceResult rtRes) {
        if (!this.field_70170_p.field_72995_K) {
            EntityRayTraceResult ertResult = null;
            BlockRayTraceResult brtResult = null;
            if (rtRes instanceof EntityRayTraceResult) {
                ertResult = (EntityRayTraceResult)rtRes;
            }
            if (rtRes instanceof BlockRayTraceResult) {
                brtResult = (BlockRayTraceResult)rtRes;
            }
            if (ertResult != null && ertResult.func_216348_a() instanceof LivingEntity) {
                LivingEntity target = (LivingEntity)ertResult.func_216348_a();
                if (target != this.func_85052_h()) {
                    float dmg = 0.0f;
                    if (this.func_85052_h() instanceof PlayerEntity) {
                        PlayerEntity player = (PlayerEntity)this.func_85052_h();
                        IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
                        if (player.func_184614_ca() != null) {
                            dmg = DamageCalculation.getOrgStrengthDamage(player, player.func_184614_ca()) / 2.0f;
                        }
                    }
                    target.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.func_85052_h()), dmg);
                    this.func_70106_y();
                }
            } else {
                this.func_70106_y();
            }
        }
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
    }

    public void func_70037_a(CompoundNBT compound) {
    }

    protected void func_70088_a() {
    }
}

