/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.entity.organization;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.entity.ItemDropEntity;
import online.kingdomkeys.kingdomkeys.entity.ModEntities;
import online.kingdomkeys.kingdomkeys.entity.organization.LaserDomeShotEntity;
import online.kingdomkeys.kingdomkeys.lib.Party;

public class FireRingCoreEntity
extends ThrowableEntity {
    int maxTicks = 240;
    List<LaserDomeShotEntity> list = new ArrayList<LaserDomeShotEntity>();
    List<Entity> targetList = new ArrayList<Entity>();
    Set<Integer> usedIndexes = new HashSet<Integer>();
    float dmg;
    float radius;
    int space;
    int shotsPerTick;
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(FireRingCoreEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Optional<UUID>> TARGET = EntityDataManager.func_187226_a(FireRingCoreEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Integer> TIER = EntityDataManager.func_187226_a(FireRingCoreEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public FireRingCoreEntity(EntityType<? extends ThrowableEntity> type, World world) {
        super(type, world);
        this.field_70156_m = true;
    }

    public FireRingCoreEntity(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        super((EntityType)ModEntities.TYPE_FIRE_RING.get(), world);
    }

    public FireRingCoreEntity(World world) {
        super((EntityType)ModEntities.TYPE_FIRE_RING.get(), world);
        this.field_70156_m = true;
    }

    public FireRingCoreEntity(World world, PlayerEntity player, LivingEntity target, float dmg, int tier) {
        super((EntityType)ModEntities.TYPE_FIRE_RING.get(), (LivingEntity)player, world);
        this.setCaster(player.func_110124_au());
        this.setTarget(target.func_110124_au());
        this.setTier(tier);
        this.dmg = dmg;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected float func_70185_h() {
        return 0.0f;
    }

    public void func_70071_h_() {
        if (this.field_70173_aa > this.maxTicks || this.getCaster() == null) {
            this.func_70106_y();
        }
        switch (this.getTier()) {
            case 0: {
                this.radius = 10.0f;
                this.space = 1;
                this.shotsPerTick = 1;
                this.maxTicks = 240;
                break;
            }
            case 1: {
                this.radius = 10.0f;
                this.space = 18;
                this.shotsPerTick = 2;
                this.maxTicks = 180;
                break;
            }
            case 2: {
                this.radius = 15.0f;
                this.space = 12;
                this.shotsPerTick = 3;
                this.maxTicks = 240;
            }
        }
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0, 0.0, 0.0);
        double X = this.func_226277_ct_();
        double Y = this.func_226278_cu_();
        double Z = this.func_226281_cx_();
        for (double i = -1.0; i < 4.0; i += 0.1) {
            for (int a = 1; a <= 360; a += this.space) {
                double x = X + (double)this.radius * Math.cos(Math.toRadians(a));
                double z = Z + (double)this.radius * Math.sin(Math.toRadians(a));
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197631_x, x, Y + i, z, 0.0, 0.0, 0.0);
            }
        }
        this.updateList();
        if (this.field_70173_aa % 10 == 0 && !this.targetList.isEmpty()) {
            for (Entity target : this.targetList) {
                if (!(target instanceof LivingEntity)) continue;
                LivingEntity entity = (LivingEntity)target;
                entity.func_70606_j(entity.func_110143_aJ() - 1.0f);
            }
        }
        super.func_70071_h_();
    }

    private void updateList() {
        List tempList = this.field_70170_p.func_72839_b((Entity)this.getCaster(), this.func_174813_aQ().func_72314_b((double)this.radius, (double)this.radius, (double)this.radius));
        Party casterParty = ModCapabilities.getWorld(this.field_70170_p).getPartyFromMember(this.getCaster().func_110124_au());
        if (casterParty != null) {
            for (Party.Member m : casterParty.getMembers()) {
                tempList.remove(this.field_70170_p.func_217371_b(m.getUUID()));
            }
        } else {
            tempList.remove(this.func_85052_h());
        }
        this.targetList.clear();
        for (Entity t : tempList) {
            if (t instanceof LaserDomeShotEntity || t instanceof ItemDropEntity || t instanceof ItemEntity || t instanceof ExperienceOrbEntity) continue;
            this.targetList.add(t);
        }
    }

    protected void func_70184_a(RayTraceResult rtRes) {
    }

    public int getMaxTicks() {
        return this.maxTicks;
    }

    public void setMaxTicks(int maxTicks) {
        this.maxTicks = maxTicks;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_70180_af.func_187225_a(OWNER) != null) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
            compound.func_74778_a("TargetUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(TARGET)).get()).toString());
            compound.func_74768_a("Tier", ((Integer)this.field_70180_af.func_187225_a(TIER)).intValue());
        }
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
        this.field_70180_af.func_187227_b(TARGET, Optional.of(UUID.fromString(compound.func_74779_i("TargetUUID"))));
        this.field_70180_af.func_187227_b(TIER, (Object)compound.func_74762_e("Tier"));
    }

    public PlayerEntity getCaster() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }

    public void setCaster(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    public PlayerEntity getTarget() {
        return ((Optional)this.func_184212_Q().func_187225_a(TARGET)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(TARGET)).get()) : null;
    }

    public void setTarget(UUID uuid) {
        this.field_70180_af.func_187227_b(TARGET, Optional.of(uuid));
    }

    public int getTier() {
        return (Integer)this.field_70180_af.func_187225_a(TIER);
    }

    public void setTier(int tier) {
        this.field_70180_af.func_187227_b(TIER, (Object)tier);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(OWNER, Optional.of(new UUID(0L, 0L)));
        this.field_70180_af.func_187214_a(TARGET, Optional.of(new UUID(0L, 0L)));
        this.field_70180_af.func_187214_a(TIER, (Object)0);
    }
}

