/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.SwordItem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.DoubleBlockHalf;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import online.kingdomkeys.kingdomkeys.api.item.IItemCategory;
import online.kingdomkeys.kingdomkeys.api.item.ItemCategory;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.client.sound.ModSounds;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.item.KeybladeItemTier;
import online.kingdomkeys.kingdomkeys.lib.DamageCalculation;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.cts.CSAttackOffhandPacket;
import online.kingdomkeys.kingdomkeys.synthesis.keybladeforge.KeybladeData;
import online.kingdomkeys.kingdomkeys.synthesis.material.Material;
import online.kingdomkeys.kingdomkeys.synthesis.recipe.Recipe;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class KeybladeItem
extends SwordItem
implements IItemCategory {
    public KeybladeData data;
    private Item.Properties properties;
    public Recipe recipe;

    public KeybladeItem(Item.Properties properties) {
        super((IItemTier)new KeybladeItemTier(0.0f), 0, 1.0f, properties);
        this.properties = properties;
    }

    public int getStrength(int level) {
        return this.data.getStrength(level);
    }

    public int getMagic(int level) {
        return this.data.getMagic(level);
    }

    public int getStrength(ItemStack stack) {
        return this.data.getStrength(this.getKeybladeLevel(stack));
    }

    public int getMagic(ItemStack stack) {
        return this.data.getMagic(this.getKeybladeLevel(stack));
    }

    public String getDescription() {
        return this.data.getDescription();
    }

    public void setKeybladeData(KeybladeData data) {
        this.data = data;
    }

    public int getKeybladeLevel(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("level")) {
            return stack.func_77978_p().func_74762_e("level");
        }
        return 0;
    }

    public void setKeybladeLevel(ItemStack stack, int level) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new CompoundNBT());
        }
        stack.func_77978_p().func_74768_a("level", level);
    }

    public Item.Properties getProperties() {
        return this.properties;
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (entityIn instanceof PlayerEntity && !worldIn.field_72995_K && Utils.hasID(stack)) {
            ItemStack mainChain;
            IPlayerCapabilities playerData;
            PlayerEntity player = (PlayerEntity)entityIn;
            int slot = itemSlot;
            if (slot == 0 && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)player.func_184592_cb())) {
                slot = 40;
            }
            if ((playerData = ModCapabilities.getPlayer(player)) != null && (mainChain = playerData.getEquippedKeychain(DriveForm.NONE)) != null) {
                ItemStack formChain = null;
                if (!playerData.getActiveDriveForm().equals(DriveForm.NONE.toString())) {
                    formChain = playerData.getEquippedKeychain(new ResourceLocation(playerData.getActiveDriveForm()));
                }
                if (formChain == null) {
                    formChain = ItemStack.field_190927_a;
                }
                UUID stackID = Utils.getID(stack);
                if (!ItemStack.func_77989_b((ItemStack)mainChain, (ItemStack)ItemStack.field_190927_a) || !ItemStack.func_77989_b((ItemStack)formChain, (ItemStack)ItemStack.field_190927_a)) {
                    UUID mainChainID = Utils.getID(mainChain);
                    UUID formChainID = Utils.getID(formChain);
                    if (mainChainID == null) {
                        mainChainID = new UUID(0L, 0L);
                    }
                    if (formChainID == null) {
                        formChainID = new UUID(0L, 0L);
                    }
                    if (!mainChainID.equals(stackID) && !formChainID.equals(stackID)) {
                        player.field_71071_by.func_70299_a(slot, ItemStack.field_190927_a);
                        player.field_70170_p.func_184133_a(null, player.func_180425_c(), (SoundEvent)ModSounds.unsummon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                    }
                } else {
                    player.field_71071_by.func_70299_a(slot, ItemStack.field_190927_a);
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), (SoundEvent)ModSounds.unsummon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                }
                for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                    UUID id;
                    slot = itemSlot;
                    if (i == 40 && ItemStack.func_77989_b((ItemStack)stack, (ItemStack)player.func_184592_cb())) {
                        slot = 40;
                    }
                    if (i == slot || (id = Utils.getID(player.field_71071_by.func_70301_a(i))) == null || !(player.field_71071_by.func_70301_a(i).func_77973_b() instanceof KeybladeItem) || !id.equals(stackID) || i == player.field_71071_by.field_70461_c) continue;
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                    player.field_70170_p.func_184133_a(null, player.func_180425_c(), (SoundEvent)ModSounds.unsummon.get(), SoundCategory.MASTER, 1.0f, 1.0f);
                }
            }
        }
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        RayTraceResult rtr;
        ItemStack itemstack = player.func_184586_b(hand);
        if (world.field_72995_K && player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() instanceof KeybladeItem && (rtr = Minecraft.func_71410_x().field_71476_x) != null) {
            player.func_184609_a(Hand.OFF_HAND);
            if (rtr.func_216346_c() == RayTraceResult.Type.ENTITY) {
                EntityRayTraceResult ertr = (EntityRayTraceResult)rtr;
                if (!ItemStack.func_77989_b((ItemStack)player.func_184586_b(Hand.OFF_HAND), (ItemStack)ItemStack.field_190927_a) && player.func_184586_b(Hand.OFF_HAND).func_77973_b() instanceof KeybladeItem && hand == Hand.OFF_HAND) {
                    if (ertr.func_216348_a() != null) {
                        PacketHandler.sendToServer(new CSAttackOffhandPacket(ertr.func_216348_a().func_145782_y()));
                        return ActionResult.func_226248_a_((Object)itemstack);
                    }
                    return ActionResult.func_226251_d_((Object)itemstack);
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        PlayerEntity player = context.func_195999_j();
        if (world.func_180495_p(pos).func_177230_c() instanceof DoorBlock) {
            SoundEvent sound;
            DoubleBlockHalf doubleblockhalf = (DoubleBlockHalf)world.func_180495_p(pos).func_177229_b((IProperty)DoorBlock.field_176523_O);
            if (doubleblockhalf == DoubleBlockHalf.UPPER) {
                world.func_175656_a(pos.func_177977_b(), (BlockState)world.func_180495_p(pos.func_177977_b()).func_206870_a((IProperty)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf((Boolean)world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)DoorBlock.field_176519_b) == false)));
                sound = (Boolean)world.func_180495_p(pos.func_177977_b()).func_177229_b((IProperty)DoorBlock.field_176519_b) != false ? SoundEvents.field_187608_cH : SoundEvents.field_187611_cI;
            } else {
                world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((IProperty)DoorBlock.field_176519_b, (Comparable)Boolean.valueOf((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DoorBlock.field_176519_b) == false)));
                sound = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)DoorBlock.field_176519_b) != false ? SoundEvents.field_187608_cH : SoundEvents.field_187611_cI;
            }
            world.func_184133_a(player, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        if (world.func_180495_p(pos).func_177230_c() instanceof TrapDoorBlock) {
            world.func_175656_a(pos, (BlockState)world.func_180495_p(pos).func_206870_a((IProperty)TrapDoorBlock.field_176283_b, (Comparable)Boolean.valueOf((Boolean)world.func_180495_p(pos).func_177229_b((IProperty)TrapDoorBlock.field_176283_b) == false)));
            SoundEvent sound = (Boolean)world.func_180495_p(pos).func_177229_b((IProperty)TrapDoorBlock.field_176283_b) != false ? SoundEvents.field_187608_cH : SoundEvents.field_187611_cI;
            world.func_184133_a(player, pos, sound, SoundCategory.BLOCKS, 1.0f, 1.0f);
            return ActionResultType.SUCCESS;
        }
        return ActionResultType.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.data != null) {
            if (this.getKeybladeLevel(stack) > 0) {
                tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + "Level %s", new Object[]{this.getKeybladeLevel(stack)}));
            }
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "Strength %s", new Object[]{(float)this.getStrength(this.getKeybladeLevel(stack)) + DamageCalculation.getSharpnessDamage(stack) + " [" + DamageCalculation.getKBStrengthDamage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, stack) + "]"}));
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.BLUE + "Magic %s", new Object[]{this.getMagic(this.getKeybladeLevel(stack)) + " [" + DamageCalculation.getMagicDamage((PlayerEntity)Minecraft.func_71410_x().field_71439_g, 1, stack) + "]"}));
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.WHITE + "" + TextFormatting.ITALIC + this.getDescription(), new Object[0]));
            if (this.recipe != null) {
                for (Map.Entry<Material, Integer> mat : this.recipe.getMaterials().entrySet()) {
                    tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.WHITE + "" + mat.getKey().getMaterialName() + " x" + mat.getValue(), new Object[0]));
                }
            }
        }
        if (flagIn.func_194127_a() && stack.func_77978_p() != null && stack.func_77978_p().func_186855_b("keybladeID")) {
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.RED + "DEBUG:", new Object[0]));
            tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.WHITE + stack.func_77978_p().func_186857_a("keybladeID").toString(), new Object[0]));
        }
    }

    @Override
    public ItemCategory getCategory() {
        return ItemCategory.TOOL;
    }

    @Mod.EventBusSubscriber
    public static class Events {
        @SubscribeEvent
        public static void onItemDropped(EntityJoinWorldEvent event) {
            ItemStack droppedItem;
            UUID droppedID;
            if (event.getEntity() instanceof ItemEntity && (droppedID = Utils.getID(droppedItem = ((ItemEntity)event.getEntity()).func_92059_d())) != null && droppedItem.func_77973_b() instanceof KeybladeItem) {
                event.setCanceled(true);
            }
        }
    }
}

