/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item;

import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.driveform.DriveForm;
import online.kingdomkeys.kingdomkeys.driveform.ModDriveForms;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class UpgradeDriveFormItem
extends Item {
    String formName;

    public UpgradeDriveFormItem(Item.Properties properties, String name) {
        super(properties);
        this.formName = name;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        IPlayerCapabilities playerData;
        if (!world.field_72995_K && (playerData = ModCapabilities.getPlayer(player)) != null && playerData.getDriveFormMap() != null) {
            DriveForm form = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(this.formName));
            if (playerData.getDriveFormMap().containsKey(this.formName)) {
                int level;
                int n = level = playerData.getDriveFormMap().containsKey(this.formName) ? playerData.getDriveFormMap().get(this.formName)[0] + 1 : 1;
                if (level <= 7) {
                    int exp = form.getLevelUpCost(level);
                    int oldExp = 0;
                    if (level > 1) {
                        oldExp = form.getLevelUpCost(level - 1);
                    }
                    int newExp = exp - oldExp;
                    playerData.setDriveFormExp(player, this.formName, playerData.getDriveFormExp(this.formName) + Math.max(newExp / 10, 1));
                    player.func_145747_a((ITextComponent)new TranslationTextComponent(Utils.translateToLocal(form.getTranslationKey()) + " has got +" + Math.max(newExp / 10, 1) + " exp", new Object[0]));
                    if (!ItemStack.func_77989_b((ItemStack)player.func_184614_ca(), (ItemStack)ItemStack.field_190927_a) && player.func_184614_ca().func_77973_b() == this) {
                        player.func_184614_ca().func_190918_g(1);
                    } else if (!ItemStack.func_77989_b((ItemStack)player.func_184592_cb(), (ItemStack)ItemStack.field_190927_a) && player.func_184592_cb().func_77973_b() == this) {
                        player.func_184592_cb().func_190918_g(1);
                    }
                }
            } else {
                playerData.setDriveFormLevel(this.formName, 1);
                playerData.setNewKeychain(new ResourceLocation(this.formName), ItemStack.field_190927_a);
                player.func_145747_a((ITextComponent)new TranslationTextComponent("message.form_unlocked", new Object[]{Utils.translateToLocal(form.getTranslationKey())}));
                if (!ItemStack.func_77989_b((ItemStack)player.func_184614_ca(), (ItemStack)ItemStack.field_190927_a) && player.func_184614_ca().func_77973_b() == this) {
                    player.func_184614_ca().func_190918_g(1);
                } else if (!ItemStack.func_77989_b((ItemStack)player.func_184592_cb(), (ItemStack)ItemStack.field_190927_a) && player.func_184592_cb().func_77973_b() == this) {
                    player.func_184592_cb().func_190918_g(1);
                }
            }
            PacketHandler.sendTo(new SCSyncCapabilityPacket(ModCapabilities.getPlayer(player)), (ServerPlayerEntity)player);
        }
        return ActionResult.func_226248_a_((Object)player.func_184586_b(hand));
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        DriveForm form = (DriveForm)ModDriveForms.registry.getValue(new ResourceLocation(this.formName));
        if (form != null) {
            tooltip.add((ITextComponent)new TranslationTextComponent("Upgrade " + Utils.translateToLocal(form.getTranslationKey()), new Object[0]));
        }
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
    }
}

