/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.item.organization;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;
import online.kingdomkeys.kingdomkeys.KingdomKeys;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationData;
import online.kingdomkeys.kingdomkeys.item.organization.OrganizationDataDeserializer;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncOrganizationData;
import org.apache.commons.io.IOUtils;

public class OrganizationDataLoader
extends JsonReloadListener {
    public static final Gson GSON_BUILDER = new GsonBuilder().registerTypeAdapter(OrganizationData.class, (Object)new OrganizationDataDeserializer()).setPrettyPrinting().create();
    public static List<String> names = new LinkedList<String>();
    public static List<String> dataList = new LinkedList<String>();

    public OrganizationDataLoader() {
        super(GSON_BUILDER, "organization");
    }

    protected void apply(Map<ResourceLocation, JsonObject> objectIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        KingdomKeys.LOGGER.info("Loading organization data");
        this.loadData(resourceManagerIn);
        PacketHandler.sendToAllPlayers(new SCSyncOrganizationData(names, dataList));
    }

    public void loadData(IResourceManager manager) {
        String folder = "organization";
        String extension = ".json";
        for (ResourceLocation file : manager.func_199003_a(folder, n -> n.endsWith(extension))) {
            ResourceLocation organizationDataID = new ResourceLocation(file.func_110624_b(), file.func_110623_a().substring(folder.length() + 1, file.func_110623_a().length() - extension.length()));
            IOrgWeapon weapon = (IOrgWeapon)ForgeRegistries.ITEMS.getValue(organizationDataID);
            try {
                OrganizationData result;
                BufferedReader br = new BufferedReader(new InputStreamReader(manager.func_199002_a(file).func_199027_b()));
                BufferedReader br2 = new BufferedReader(new InputStreamReader(manager.func_199002_a(file).func_199027_b()));
                String data = "";
                while (br.ready()) {
                    data = data + br.readLine();
                }
                dataList.add(data);
                try {
                    result = (OrganizationData)GSON_BUILDER.fromJson((Reader)br2, OrganizationData.class);
                    names.add(organizationDataID.toString());
                }
                catch (JsonParseException e) {
                    KingdomKeys.LOGGER.error("Error parsing json file {}: {}", (Object)manager.func_199002_a(file).func_199029_a().toString(), (Object)e);
                    continue;
                }
                weapon.setOrganizationData(result);
                IOUtils.closeQuietly((Closeable)manager.func_199002_a(file));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

