/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.lib;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Hand;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.item.KeybladeItem;
import online.kingdomkeys.kingdomkeys.item.KeychainItem;
import online.kingdomkeys.kingdomkeys.item.organization.IOrgWeapon;

public class DamageCalculation {
    public static float getMagicDamage(PlayerEntity player, int level, ItemStack stack) {
        if (player != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            float damage = 0.0f;
            float finalDamage = 0.0f;
            KeybladeItem keyblade = null;
            if (stack.func_77973_b() instanceof KeychainItem) {
                keyblade = ((KeychainItem)stack.func_77973_b()).getKeyblade();
            } else if (stack.func_77973_b() instanceof KeybladeItem) {
                keyblade = (KeybladeItem)stack.func_77973_b();
            }
            if (keyblade != null) {
                damage = keyblade.getMagic(stack) + playerData.getMagic();
                switch (playerData.getActiveDriveForm()) {
                    case "kingdomkeys:form_wisdom": {
                        damage *= 2.0f;
                        break;
                    }
                    case "kingdomkeys:form_master": {
                        damage = (float)((double)damage * 2.25);
                        break;
                    }
                    case "kingdomkeys:form_final": {
                        damage = (float)((double)damage * 2.5);
                    }
                }
                switch (level) {
                    case 1: {
                        finalDamage = damage;
                        break;
                    }
                    case 2: {
                        finalDamage = (float)((double)damage + 0.1 * (double)damage);
                        break;
                    }
                    case 3: {
                        finalDamage = (float)((double)damage + 0.2 * (double)damage);
                    }
                }
            }
            return finalDamage;
        }
        return 0.0f;
    }

    public static float getOrgMagicDamage(PlayerEntity player, int level, IOrgWeapon weapon) {
        if (player != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            float damage = 0.0f;
            float finalDamage = 0.0f;
            damage = weapon.getMagic() + playerData.getMagic();
            switch (level) {
                case 1: {
                    finalDamage = damage;
                    break;
                }
                case 2: {
                    finalDamage = (float)((double)damage + 0.1 * (double)damage);
                    break;
                }
                case 3: {
                    finalDamage = (float)((double)damage + 0.2 * (double)damage);
                }
            }
            return finalDamage;
        }
        return 0.0f;
    }

    public static float getMagicDamage(PlayerEntity player, int level) {
        if (player != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            float finalDamage = 0.0f;
            if (!ItemStack.func_77989_b((ItemStack)player.func_184586_b(Hand.MAIN_HAND), (ItemStack)ItemStack.field_190927_a)) {
                if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof KeybladeItem) {
                    finalDamage = DamageCalculation.getMagicDamage(player, level, player.func_184614_ca());
                } else if (player.func_184586_b(Hand.MAIN_HAND).func_77973_b() instanceof IOrgWeapon) {
                    finalDamage = DamageCalculation.getOrgMagicDamage(player, level, (IOrgWeapon)player.func_184614_ca().func_77973_b());
                }
            } else {
                finalDamage = playerData.getMagic();
            }
            return finalDamage;
        }
        return 0.0f;
    }

    public static float getKBStrengthDamage(PlayerEntity player, ItemStack stack) {
        if (player != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            float damage = 0.0f;
            float finalDamage = 0.0f;
            KeybladeItem keyblade = null;
            if (stack.func_77973_b() instanceof KeychainItem) {
                keyblade = ((KeychainItem)stack.func_77973_b()).getKeyblade();
            } else if (stack.func_77973_b() instanceof KeybladeItem) {
                keyblade = (KeybladeItem)stack.func_77973_b();
            }
            if (keyblade != null) {
                damage = keyblade.getStrength(stack) + playerData.getStrength();
                switch (playerData.getActiveDriveForm()) {
                    case "kingdomkeys:form_valor": {
                        damage = (float)((double)damage * 1.5);
                        break;
                    }
                    case "kingdomkeys:form_limit": {
                        damage = (float)((double)damage * 1.2);
                        break;
                    }
                    case "kingdomkeys:form_master": {
                        damage = (float)((double)damage * 1.5);
                        break;
                    }
                    case "kingdomkeys:form_final": {
                        damage = (float)((double)damage * 1.7);
                    }
                }
            }
            finalDamage = damage + DamageCalculation.getSharpnessDamage(stack);
            return finalDamage;
        }
        return 0.0f;
    }

    public static float getOrgStrengthDamage(PlayerEntity player, ItemStack stack) {
        if (player != null) {
            IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
            float damage = 0.0f;
            float finalDamage = 0.0f;
            if (stack.func_77973_b() instanceof IOrgWeapon) {
                IOrgWeapon org = (IOrgWeapon)stack.func_77973_b();
                damage = (float)org.getStrength() + (float)playerData.getStrength();
                finalDamage = damage + DamageCalculation.getSharpnessDamage(stack);
            }
            return finalDamage;
        }
        return 0.0f;
    }

    public static float getSharpnessDamage(ItemStack stack) {
        ListNBT nbttaglist = stack.func_77986_q();
        float sharpnessDamage = 0.0f;
        for (int i = 0; i < nbttaglist.size(); ++i) {
            String id = nbttaglist.func_150305_b(i).func_74779_i("id");
            short lvl = nbttaglist.func_150305_b(i).func_74765_d("lvl");
            if (!id.equals("minecraft:sharpness")) continue;
            sharpnessDamage = DamageCalculation.getSharpnessDamageFromLevel(lvl);
        }
        return sharpnessDamage;
    }

    private static float getSharpnessDamageFromLevel(float lvl) {
        return lvl / 2.0f + 0.5f;
    }
}

