/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;

public class Party {
    public static final byte PARTY_LIMIT = 4;
    private String name;
    private List<Member> members = new ArrayList<Member>();
    private boolean priv;
    private byte size;

    public Party() {
    }

    public Party(String name, UUID leaderId, String username, boolean priv, byte size) {
        this.name = name;
        this.addMember(leaderId, username).setIsLeader();
        this.priv = priv;
        this.size = size;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setPriv(boolean priv) {
        this.priv = priv;
    }

    public boolean getPriv() {
        return this.priv;
    }

    public void setSize(byte size) {
        this.size = size;
    }

    public byte getSize() {
        return this.size;
    }

    public Member addMember(LivingEntity entity) {
        return this.addMember(entity.func_110124_au(), entity.func_145748_c_().func_150254_d());
    }

    public Member addMember(UUID uuid, String username) {
        Member member = new Member(uuid, username);
        this.members.add(member);
        return member;
    }

    public void removeMember(UUID id) {
        Member member = this.getMember(id);
        if (member.isLeader()) {
            this.members.removeAll(this.members);
        } else {
            this.members.remove(member);
        }
    }

    public Member getMember(UUID id) {
        return this.members.stream().filter(member -> member.getUUID().equals(id)).findFirst().orElse(null);
    }

    public boolean hasMember(UUID id) {
        return this.getMember(id) != null;
    }

    @Nullable
    public Member getLeader() {
        return this.members.stream().filter(member -> member.isLeader()).findFirst().orElse(null);
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public int getMemberIndex(UUID memberUUID) {
        int i = 0;
        for (i = 0; i < this.members.size(); ++i) {
            if (!this.members.get(i).getUUID().equals(memberUUID)) continue;
            return i;
        }
        return -1;
    }

    public CompoundNBT write() {
        CompoundNBT partyNBT = new CompoundNBT();
        partyNBT.func_74778_a("name", this.getName());
        partyNBT.func_74757_a("private", this.priv);
        partyNBT.func_74774_a("size", this.size);
        ListNBT members = new ListNBT();
        for (Member member : this.getMembers()) {
            CompoundNBT memberNBT = new CompoundNBT();
            memberNBT.func_186854_a("id", member.getUUID());
            memberNBT.func_74778_a("username", member.getUsername());
            memberNBT.func_74757_a("isLeader", member.isLeader());
            members.add((Object)memberNBT);
        }
        partyNBT.func_218657_a("members", (INBT)members);
        return partyNBT;
    }

    public void read(CompoundNBT nbt) {
        this.setName(nbt.func_74779_i("name"));
        this.setPriv(nbt.func_74767_n("private"));
        this.setSize(nbt.func_74771_c("size"));
        ListNBT members = nbt.func_150295_c("members", 10);
        for (int j = 0; j < members.size(); ++j) {
            CompoundNBT memberNBT = members.func_150305_b(j);
            Member member = this.addMember(memberNBT.func_186857_a("id"), memberNBT.func_74779_i("username"));
            if (!memberNBT.func_74767_n("isLeader")) continue;
            member.setIsLeader();
        }
    }

    public static class Member {
        private UUID uuid;
        private String username;
        private boolean isLeader;

        public Member(LivingEntity entity) {
            this(entity.func_110124_au(), entity.func_145748_c_().func_150254_d());
        }

        public Member(UUID uuid, String username) {
            this.uuid = uuid;
            this.username = username;
        }

        public Member setIsLeader() {
            this.isLeader = true;
            return this;
        }

        public boolean isLeader() {
            return this.isLeader;
        }

        public UUID getUUID() {
            return this.uuid;
        }

        public String getUsername() {
            return this.username;
        }
    }
}

