/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncWorldCapability;

public class CSPartyAddMember {
    String name;
    UUID memberUUID;
    String memberName;

    public CSPartyAddMember() {
    }

    public CSPartyAddMember(Party party, PlayerEntity member) {
        this.name = party.getName();
        this.memberUUID = member.func_110124_au();
        this.memberName = member.func_145748_c_().func_150254_d();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.name.length());
        buffer.func_180714_a(this.name);
        buffer.func_179252_a(this.memberUUID);
        buffer.writeInt(this.memberName.length());
        buffer.func_180714_a(this.memberName);
    }

    public static CSPartyAddMember decode(PacketBuffer buffer) {
        CSPartyAddMember msg = new CSPartyAddMember();
        int length = buffer.readInt();
        msg.name = buffer.func_150789_c(length);
        msg.memberUUID = buffer.func_179253_g();
        length = buffer.readInt();
        msg.memberName = buffer.func_150789_c(length);
        return msg;
    }

    public static void handle(CSPartyAddMember message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            IWorldCapabilities worldData = ModCapabilities.getWorld(player.field_70170_p);
            for (Party p : worldData.getParties()) {
                if (p.getName().equals(message.name)) {
                    p.addMember(message.memberUUID, message.memberName);
                }
                PlayerEntity target = player.field_70170_p.func_217371_b(message.memberUUID);
                ModCapabilities.getPlayer(target).removePartiesInvited(message.name);
                PacketHandler.sendTo(new SCSyncCapabilityPacket(ModCapabilities.getPlayer(target)), (ServerPlayerEntity)target);
            }
            PacketHandler.sendToAll(new SCSyncWorldCapability(worldData), (PlayerEntity)player);
        });
        ctx.get().setPacketHandled(true);
    }
}

