/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncWorldCapability;

public class CSPartyCreate {
    String name;
    String username;
    UUID uuid;
    boolean priv;
    byte size;

    public CSPartyCreate() {
    }

    public CSPartyCreate(Party party) {
        this.name = party.getName();
        this.uuid = party.getLeader().getUUID();
        this.username = party.getLeader().getUsername();
        this.priv = party.getPriv();
        this.size = party.getSize();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.name.length());
        buffer.func_180714_a(this.name);
        buffer.func_179252_a(this.uuid);
        buffer.writeInt(this.username.length());
        buffer.func_180714_a(this.username);
        buffer.writeBoolean(this.priv);
        buffer.writeByte((int)this.size);
    }

    public static CSPartyCreate decode(PacketBuffer buffer) {
        CSPartyCreate msg = new CSPartyCreate();
        int length = buffer.readInt();
        msg.name = buffer.func_150789_c(length);
        msg.uuid = buffer.func_179253_g();
        length = buffer.readInt();
        msg.username = buffer.func_150789_c(length);
        msg.priv = buffer.readBoolean();
        msg.size = buffer.readByte();
        return msg;
    }

    public static void handle(CSPartyCreate message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            IWorldCapabilities worldData = ModCapabilities.getWorld(player.field_70170_p);
            Party party = new Party(message.name, message.uuid, message.username, message.priv, message.size);
            worldData.addParty(party);
            PacketHandler.sendToAll(new SCSyncWorldCapability(worldData), (PlayerEntity)player);
        });
        ctx.get().setPacketHandled(true);
    }
}

