/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.IWorldCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.lib.Party;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;

public class CSPartyInvite {
    String name;
    UUID playerUUID;

    public CSPartyInvite() {
    }

    public CSPartyInvite(Party party, UUID playerUUID) {
        this.name = party.getName();
        this.playerUUID = playerUUID;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.name.length());
        buffer.func_180714_a(this.name);
        buffer.func_179252_a(this.playerUUID);
    }

    public static CSPartyInvite decode(PacketBuffer buffer) {
        CSPartyInvite msg = new CSPartyInvite();
        int length = buffer.readInt();
        msg.name = buffer.func_150789_c(length);
        msg.playerUUID = buffer.func_179253_g();
        return msg;
    }

    public static void handle(CSPartyInvite message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            PlayerEntity target = player.field_70170_p.func_217371_b(message.playerUUID);
            IPlayerCapabilities targetPlayerData = ModCapabilities.getPlayer(target);
            if (!targetPlayerData.getPartiesInvited().contains(message.name)) {
                targetPlayerData.addPartiesInvited(message.name);
                IWorldCapabilities worldData = ModCapabilities.getWorld(player.field_70170_p);
                Party p = worldData.getPartyFromName(message.name);
                target.func_145747_a((ITextComponent)new TranslationTextComponent(TextFormatting.YELLOW + p.getLeader().getUsername() + " has invited you to " + p.getName(), new Object[0]));
            }
            PacketHandler.sendTo(new SCSyncCapabilityPacket(targetPlayerData), (ServerPlayerEntity)target);
        });
        ctx.get().setPacketHandled(true);
    }
}

