/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;

public class CSSetAerialDodgeTicksPacket {
    private int ticks;
    private boolean hasJumped;

    public CSSetAerialDodgeTicksPacket() {
    }

    public CSSetAerialDodgeTicksPacket(boolean hasJumped, int ticks) {
        this.hasJumped = hasJumped;
        this.ticks = ticks;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeBoolean(this.hasJumped);
        buffer.writeInt(this.ticks);
    }

    public static CSSetAerialDodgeTicksPacket decode(PacketBuffer buffer) {
        CSSetAerialDodgeTicksPacket msg = new CSSetAerialDodgeTicksPacket();
        msg.hasJumped = buffer.readBoolean();
        msg.ticks = buffer.readInt();
        return msg;
    }

    public static void handle(CSSetAerialDodgeTicksPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            playerData.setHasJumpedAerialDodge(message.hasJumped);
            playerData.setAerialDodgeTicks(message.ticks);
            PacketHandler.syncToAllAround((PlayerEntity)player, playerData);
        });
        ctx.get().setPacketHandled(true);
    }
}

