/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.cts;

import java.util.function.Supplier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;
import online.kingdomkeys.kingdomkeys.magic.Magic;
import online.kingdomkeys.kingdomkeys.magic.ModMagic;
import online.kingdomkeys.kingdomkeys.network.PacketHandler;
import online.kingdomkeys.kingdomkeys.network.stc.SCSyncCapabilityPacket;
import online.kingdomkeys.kingdomkeys.util.Utils;

public class CSUseMagicPacket {
    String name;
    String target;

    public CSUseMagicPacket() {
    }

    public CSUseMagicPacket(String name) {
        this.name = name;
        this.target = "";
    }

    public CSUseMagicPacket(String name, String target) {
        this.name = name;
        this.target = target;
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.name.length());
        buffer.func_180714_a(this.name);
        buffer.writeInt(this.target.length());
        buffer.func_180714_a(this.target);
    }

    public static CSUseMagicPacket decode(PacketBuffer buffer) {
        CSUseMagicPacket msg = new CSUseMagicPacket();
        int length = buffer.readInt();
        msg.name = buffer.func_150789_c(length);
        length = buffer.readInt();
        msg.target = buffer.func_150789_c(length);
        return msg;
    }

    public static void handle(CSUseMagicPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            ServerPlayerEntity player = ((NetworkEvent.Context)ctx.get()).getSender();
            IPlayerCapabilities playerData = ModCapabilities.getPlayer((PlayerEntity)player);
            if (playerData.getMP() >= 0.0 && !playerData.getRecharge()) {
                int cost = ((Magic)ModMagic.registry.getValue(new ResourceLocation(message.name))).getCost();
                playerData.remMP(cost);
                PacketHandler.sendTo(new SCSyncCapabilityPacket(playerData), player);
                if (message.target.equals("")) {
                    ((Magic)ModMagic.registry.getValue(new ResourceLocation(message.name))).onUse((PlayerEntity)player, (PlayerEntity)player);
                } else {
                    PlayerEntity targetEntity = Utils.getPlayerByName(player.field_70170_p, message.target);
                    ((Magic)ModMagic.registry.getValue(new ResourceLocation(message.name))).onUse(targetEntity, (PlayerEntity)player);
                }
            }
            PacketHandler.syncToAllAround((PlayerEntity)player, playerData);
        });
        ctx.get().setPacketHandled(true);
    }
}

