/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IPlayerCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;

public class SCSyncCapabilityToAllPacket {
    private String name;
    private String driveForm;
    private int level = 0;
    private int exp = 0;
    private int expGiven = 0;
    private int strength = 0;
    private int magic = 0;
    private int defense = 0;
    private int reflectTicks = 0;
    private int aeroTicks = 0;
    private int antipoints = 0;
    private int maxHP = 20;
    double mp = 0.0;
    double maxMP = 0.0;
    LinkedHashMap<String, int[]> driveFormMap = new LinkedHashMap();
    List<String> magicList = new ArrayList<String>();
    private double dp = 0.0;
    private double fp = 0.0;
    private int aerialDodgeTicks = 0;
    private boolean isGliding = false;
    private boolean hasJumpedAD = false;

    public SCSyncCapabilityToAllPacket() {
    }

    public SCSyncCapabilityToAllPacket(String name, IPlayerCapabilities capability) {
        this.name = name;
        this.level = capability.getLevel();
        this.exp = capability.getExperience();
        this.expGiven = capability.getExperienceGiven();
        this.strength = capability.getStrength();
        this.magic = capability.getMagic();
        this.defense = capability.getDefense();
        this.driveForm = capability.getActiveDriveForm();
        this.aeroTicks = capability.getAeroTicks();
        this.reflectTicks = capability.getReflectTicks();
        this.fp = capability.getFP();
        this.dp = capability.getDP();
        this.antipoints = capability.getAntiPoints();
        this.maxHP = capability.getMaxHP();
        this.mp = capability.getMP();
        this.maxMP = capability.getMaxMP();
        this.magicList = capability.getMagicList();
        this.driveFormMap = capability.getDriveFormMap();
        this.isGliding = capability.getIsGliding();
        this.aerialDodgeTicks = capability.getAerialDodgeTicks();
        this.hasJumpedAD = capability.hasJumpedAerialDodge();
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_180714_a(this.name);
        buffer.writeInt(this.level);
        buffer.writeInt(this.exp);
        buffer.writeInt(this.expGiven);
        buffer.writeInt(this.strength);
        buffer.writeInt(this.magic);
        buffer.writeInt(this.defense);
        buffer.func_180714_a(this.driveForm);
        buffer.writeInt(this.aeroTicks);
        buffer.writeInt(this.reflectTicks);
        buffer.writeDouble(this.dp);
        buffer.writeDouble(this.fp);
        buffer.writeInt(this.antipoints);
        buffer.writeInt(this.maxHP);
        buffer.writeDouble(this.mp);
        buffer.writeDouble(this.maxMP);
        CompoundNBT magics = new CompoundNBT();
        for (String m : this.magicList) {
            magics.func_74768_a(m, 1);
        }
        buffer.func_150786_a(magics);
        CompoundNBT forms = new CompoundNBT();
        for (Map.Entry<String, int[]> pair : this.driveFormMap.entrySet()) {
            forms.func_74783_a(pair.getKey().toString(), pair.getValue());
        }
        buffer.func_150786_a(forms);
        buffer.writeBoolean(this.isGliding);
        buffer.writeInt(this.aerialDodgeTicks);
        buffer.writeBoolean(this.hasJumpedAD);
    }

    public static SCSyncCapabilityToAllPacket decode(PacketBuffer buffer) {
        SCSyncCapabilityToAllPacket msg = new SCSyncCapabilityToAllPacket();
        msg.name = buffer.func_218666_n();
        msg.level = buffer.readInt();
        msg.exp = buffer.readInt();
        msg.expGiven = buffer.readInt();
        msg.strength = buffer.readInt();
        msg.magic = buffer.readInt();
        msg.defense = buffer.readInt();
        msg.driveForm = buffer.func_218666_n();
        msg.aeroTicks = buffer.readInt();
        msg.reflectTicks = buffer.readInt();
        msg.dp = buffer.readDouble();
        msg.fp = buffer.readDouble();
        msg.antipoints = buffer.readInt();
        msg.maxHP = buffer.readInt();
        msg.mp = buffer.readDouble();
        msg.maxMP = buffer.readDouble();
        CompoundNBT magicsTag = buffer.func_150793_b();
        for (String key : magicsTag.func_150296_c()) {
            msg.magicList.add(key);
        }
        CompoundNBT driveFormsTag = buffer.func_150793_b();
        for (String driveFormName : driveFormsTag.func_150296_c()) {
            msg.driveFormMap.put(driveFormName, driveFormsTag.func_74759_k(driveFormName));
        }
        msg.isGliding = buffer.readBoolean();
        msg.aerialDodgeTicks = buffer.readInt();
        msg.hasJumpedAD = buffer.readBoolean();
        return msg;
    }

    public static void handle(SCSyncCapabilityToAllPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            List list = Minecraft.func_71410_x().field_71441_e.func_217369_A();
            PlayerEntity player = null;
            for (int i = 0; i < list.size(); ++i) {
                String name = ((AbstractClientPlayerEntity)list.get(i)).func_200200_C_().func_150254_d();
                if (!name.equals(message.name)) continue;
                player = (PlayerEntity)list.get(i);
            }
            if (player != null) {
                IPlayerCapabilities playerData = ModCapabilities.getPlayer(player);
                playerData.setLevel(message.level);
                playerData.setExperience(message.exp);
                playerData.setExperienceGiven(message.expGiven);
                playerData.setStrength(message.strength);
                playerData.setMagic(message.magic);
                playerData.setDefense(message.defense);
                playerData.setActiveDriveForm(message.driveForm);
                playerData.setAeroTicks(message.aeroTicks);
                playerData.setReflectTicks(message.reflectTicks);
                playerData.setDP(message.dp);
                playerData.setFP(message.fp);
                playerData.setAntiPoints(message.antipoints);
                playerData.setMaxHP(message.maxHP);
                playerData.setMP(message.mp);
                playerData.setMaxMP(message.maxMP);
                playerData.setMagicList(message.magicList);
                playerData.setDriveFormMap(message.driveFormMap);
                playerData.setIsGliding(message.isGliding);
                playerData.setAerialDodgeTicks(message.aerialDodgeTicks);
                playerData.setHasJumpedAerialDodge(message.hasJumpedAD);
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

