/*
 * Decompiled with CFR 0.152.
 */
package online.kingdomkeys.kingdomkeys.network.stc;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.network.NetworkEvent;
import online.kingdomkeys.kingdomkeys.capability.IGlobalCapabilities;
import online.kingdomkeys.kingdomkeys.capability.ModCapabilities;

public class SCSyncGlobalCapabilityPacket {
    private int stoppedTicks;
    private int stopDmg;
    private int flatTicks;

    public SCSyncGlobalCapabilityPacket() {
    }

    public SCSyncGlobalCapabilityPacket(IGlobalCapabilities capability) {
        this.stoppedTicks = capability.getStoppedTicks();
        this.stopDmg = capability.getDamage();
        this.flatTicks = capability.getFlatTicks();
    }

    public void encode(PacketBuffer buffer) {
        buffer.writeInt(this.stoppedTicks);
        buffer.writeInt(this.stopDmg);
        buffer.writeInt(this.flatTicks);
    }

    public static SCSyncGlobalCapabilityPacket decode(PacketBuffer buffer) {
        SCSyncGlobalCapabilityPacket msg = new SCSyncGlobalCapabilityPacket();
        msg.stoppedTicks = buffer.readInt();
        msg.stopDmg = buffer.readInt();
        msg.flatTicks = buffer.readInt();
        return msg;
    }

    public static void handle(SCSyncGlobalCapabilityPacket message, Supplier<NetworkEvent.Context> ctx) {
        ctx.get().enqueueWork(() -> {
            LazyOptional globalData = Minecraft.func_71410_x().field_71439_g.getCapability(ModCapabilities.GLOBAL_CAPABILITIES);
            globalData.ifPresent(cap -> cap.setStoppedTicks(message.stoppedTicks));
            globalData.ifPresent(cap -> cap.setDamage(message.stopDmg));
            globalData.ifPresent(cap -> cap.setFlatTicks(message.flatTicks));
        });
        ctx.get().setPacketHandled(true);
    }
}

